#!/usr/local/etc/pagsh
#
# RCSID: $Header: /afs/andrew.cmu.edu/system/src/local/novstat/001/andrew/RCS/novstat-check-fetch,v 1.3 1993/10/07 21:53:01 ms5u Exp $
#
# Script to check to see if novstat-fetch-report completed successfully.
#
# Revision History:
# $Log: novstat-check-fetch,v $
# Revision 1.3  1993/10/07  21:53:01  ms5u
# Can't use functions on pmax sh.  Using awk instead.
#
# Revision 1.2  1993/10/07  21:45:14  ms5u
# The ${1:?"text text text"} doesn't work on the pmax, so I replaced it
# with an if...then...fi block.
#
# Revision 1.1  1993/10/07  19:05:14  ms5u
# Initial revision
#
#
# Load configuration from script parameter
if [ x$1 = "x" ]
then
    echo "$0: no configuration file specified"
    exit 1
fi
. $1
#
#
# Start off in the right place
cd $workdir

runstat=`/usr/local/etc/ezfax2/bin/faevery read week stat.$hostname`
isok=`echo $runstat | awk '{ print $3 }'`

if [ $isok = "ok" ]
then
    /usr/local/bin/klog $authuser `cat $scriptpassfile`

    echo -n "Date: " > message.$$
    date | awk '{ print $1", "$3" "$2" "$6" "$4" "$5 }' >> message.$$
    echo "From: Novell Statistics Daemon <$authuser+@ANDREW.CMU.EDU>" >> message.$$
    echo "Subject: Failed to retrieve current report" >> message.$$
    echo "To: $recipient" >> message.$$
    echo "" >> message.$$
    echo "I tried to retrieve the new NovStat report from $hostname" >> message.$$
    echo "but have repeatedly failed." >> message.$$
    echo "" >> message.$$
    echo "Please investigate this manually." >> message.$$

    /usr/local/etc/queuemail -f message.$$ $recipient && rm message.$$
fi
