/*
 *  NovStat V1.1
 *
 *  Copyright (C) 1993 by Carnegie Mellon University
 *
 *  This software is freely available for any purpose other than commercial
 *  gain.  You may distribute this code provided this copyright remains
 *  intact.  Any modifications made to this code must be noted as not part
 *  of the original NovStat V1.1 code.
 *
 */

static char rcsid[] = "$Header: /afs/andrew.cmu.edu/system/src/local/novstat/003/src/RCS/track.c,v 1.4 1994/02/15 18:25:50 ms5u Exp $";
/* track.c
 *
 * This module will simply track logins and logouts through the two routines
 * TRACK_addinfo (to add information concerning a login) and TRACK_logtime
 * (to obtain the time logged in if known, 0 otherwise).
 *
 * Revision History:
 *   $Log: track.c,v $
 * Revision 1.4  1994/02/15  18:25:50  ms5u
 * Change version to V1.1.
 *
 * Revision 1.3  1993/10/05  15:35:05  ms5u
 * Add copyright header.
 *
 * Revision 1.2  1993/10/05  15:26:44  ms5u
 * Didn't update xlist properly -- removed if statement to always update
 * xlist when a new element has been added.
 *
 * Revision 1.1  1993/09/13  19:36:29  ms5u
 * Initial revision
 *
 */

#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "acctrec.h"

static struct xinfo {
	LONG net;
	LONG nodehigh;
	WORD nodelow;
	BYTE timestamp[6];
	struct xinfo *next;
} *xlist = NULL;

void TRACK_addinfo(LONG net, LONG nodehigh, WORD nodelow, BYTE timestamp[6])
{
	struct xinfo *tmp;
	
	tmp = xlist;
	while ((tmp != NULL) &&
		((tmp->net != net) || (tmp->nodehigh != nodehigh) ||
		 (tmp->nodelow != nodelow)))
		tmp = tmp->next;
	if (tmp == NULL)
	{
		tmp = (struct xinfo *)malloc(sizeof(struct xinfo));
		tmp->net = net;
		tmp->nodehigh = nodehigh;
		tmp->nodelow = nodelow;
		tmp->next = xlist;
		xlist = tmp;
	}
	memcpy(&(tmp->timestamp), timestamp, 6);
}

LONG TRACK_logtime(LONG net, LONG nodehigh, WORD nodelow, BYTE timestamp[6])
{
	struct xinfo *tmp;
	struct tm logintime, logouttime;
	
	tmp = xlist;
	while ((tmp != NULL) &&
		((tmp->net != net) || (tmp->nodehigh != nodehigh) ||
		 (tmp->nodelow != nodelow)))
		tmp = tmp->next;
	
	if (tmp == NULL)
		return(0);
	else
	{
		memset(&logintime, 0, sizeof(logintime));
		memset(&logouttime, 0, sizeof(logouttime));
		logintime.tm_year = tmp->timestamp[0];
		logintime.tm_mon = tmp->timestamp[1] - 1;
		logintime.tm_mday = tmp->timestamp[2];
		logintime.tm_hour = tmp->timestamp[3];
		logintime.tm_min = tmp->timestamp[4];
		logintime.tm_sec = tmp->timestamp[5];
		mktime(&logintime);
		
		logouttime.tm_year = timestamp[0];
		logouttime.tm_mon = timestamp[1] - 1;
		logouttime.tm_mday = timestamp[2];
		logouttime.tm_hour = timestamp[3];
		logouttime.tm_min = timestamp[4];
		logouttime.tm_sec = timestamp[5];
		mktime(&logouttime);
		
		return (((((logouttime.tm_year - logintime.tm_year) * 365 +
			   (logouttime.tm_yday - logintime.tm_yday)) * 24 +
			  (logouttime.tm_hour - logintime.tm_hour)) * 60 +
			 (logouttime.tm_min - logintime.tm_min)) * 60 +
			(logouttime.tm_sec - logintime.tm_sec));
	}
}

void TRACK_cleanup()
{
	struct xinfo *tmp;
	
	while (xlist != NULL)
	{
		tmp = xlist;
		xlist = xlist->next;
		free(tmp);
	}
}
