/*
 *  NovStat V1.1
 *
 *  Copyright (C) 1993 by Carnegie Mellon University
 *
 *  This software is freely available for any purpose other than commercial
 *  gain.  You may distribute this code provided this copyright remains
 *  intact.  Any modifications made to this code must be noted as not part
 *  of the original NovStat V1.1 code.
 *
 */

static char rcsid[] = "$Header: /afs/andrew.cmu.edu/system/src/local/novstat/003/src/RCS/sparse.c,v 1.3 1994/02/15 18:25:27 ms5u Exp $";
/* sparse.c provides routines to count things that are sparse in nature
 *
 * Revision History:
 *   $Log: sparse.c,v $
 * Revision 1.3  1994/02/15  18:25:27  ms5u
 * Change version to V1.1.
 *
 * Revision 1.2  1993/10/05  15:35:03  ms5u
 * Add copyright header.
 *
 * Revision 1.1  1993/09/13  19:36:21  ms5u
 * Initial revision
 *
 */

#include <stdlib.h>
#include "sparse.h"

void SPARSE_increment(struct sparsecounter **list, LONG newval, LONG addtot)
{
	struct sparsecounter *tmp;
	
	if (*list == NULL)
	{
		*list = (struct sparsecounter *)malloc(sizeof(struct sparsecounter));
		(*list)->value = newval;
		(*list)->count = 1;
		(*list)->total = addtot;
		(*list)->next = NULL;
	} else
		for (tmp = *list; tmp != NULL;
			tmp = ((tmp == NULL) ? NULL : tmp->next))
		{
			if (tmp->value == newval)
			{
				tmp->count++;
				tmp->total += addtot;
				tmp = NULL;
			} else if (tmp->next == NULL)
			{
				tmp->next = (struct sparsecounter *)
					malloc(sizeof(struct sparsecounter));
				tmp = tmp->next;
				tmp->value = newval;
				tmp->count = 1;
				tmp->total = addtot;
				tmp->next = NULL;
			}
		}
}

void SPARSE_sort(struct sparsecounter *list)
{
	struct sparsecounter *outer, *inner;
	LONG tempval, tempcount, temptot;
	
	outer = list;
	while (outer != NULL)
	{
		inner = outer->next;
		while (inner != NULL)
		{
			if (inner->count > outer->count)
			{
				tempval = inner->value;
				tempcount = inner->count;
				temptot = inner->total;
				inner->value = outer->value;
				inner->count = outer->count;
				inner->total = outer->total;
				outer->value = tempval;
				outer->count = tempcount;
				outer->total = temptot;
			}
			inner = inner->next;
		}
		outer = outer->next;
	}
}

void SPARSE_cleanup(struct sparsecounter *list)
{
	struct sparsecounter *tmp;
	
	while (list != NULL)
	{
		tmp = list;
		list = list->next;
		free(tmp);
	}
}

void SPARSE_m_increment(struct sparse_m_counter **list, LONG newval_1,
			LONG newval_2, WORD newval_3, LONG addtot)
{
	struct sparse_m_counter *tmp;
	
	if (*list == NULL)
	{
		*list = (struct sparse_m_counter *)malloc(sizeof(struct sparse_m_counter));
		(*list)->value_1 = newval_1;
		(*list)->value_2 = newval_2;
		(*list)->value_3 = newval_3;
		(*list)->count = 1;
		(*list)->total = addtot;
		(*list)->next = NULL;
	} else
		for (tmp = *list; tmp != NULL;
			tmp = ((tmp == NULL) ? NULL : tmp->next))
		{
			if ((tmp->value_1 == newval_1) &&
				(tmp->value_2 == newval_2) &&
				(tmp->value_3 == newval_3))
			{
				tmp->count++;
				tmp->total += addtot;
				tmp = NULL;
			} else if (tmp->next == NULL)
			{
				tmp->next = (struct sparse_m_counter *)
					malloc(sizeof(struct sparse_m_counter));
				tmp = tmp->next;
				tmp->value_1 = newval_1;
				tmp->value_2 = newval_2;
				tmp->value_3 = newval_3;
				tmp->count = 1;
				tmp->total = addtot;
				tmp->next = NULL;
			}
		}
}

void SPARSE_m_sort(struct sparse_m_counter *list)
{
	struct sparse_m_counter *outer, *inner;
	LONG tempcount, temptot;
	LONG tmpval1, tmpval2;
	WORD tmpval3;
	
	outer = list;
	while (outer != NULL)
	{
		inner = outer->next;
		while (inner != NULL)
		{
			if (inner->count > outer->count)
			{
				tmpval1 = inner->value_1;
				tmpval2 = inner->value_2;
				tmpval3 = inner->value_3;
				tempcount = inner->count;
				temptot = inner->total;

				inner->value_1 = outer->value_1;
				inner->value_2 = outer->value_2;
				inner->value_3 = outer->value_3;
				inner->count = outer->count;
				inner->total = outer->total;

				outer->value_1 = tmpval1;
				outer->value_2 = tmpval2;
				outer->value_3 = tmpval3;
				outer->count = tempcount;
				outer->total = temptot;
			}
			inner = inner->next;
		}
		outer = outer->next;
	}
}

void SPARSE_m_cleanup(struct sparse_m_counter *list)
{
	struct sparse_m_counter *tmp;
	
	while (list != NULL)
	{
		tmp = list;
		list = list->next;
		free(tmp);
	}
}
