/*
 *  NovStat V1.1
 *
 *  Copyright (C) 1993 by Carnegie Mellon University
 *
 *  This software is freely available for any purpose other than commercial
 *  gain.  You may distribute this code provided this copyright remains
 *  intact.  Any modifications made to this code must be noted as not part
 *  of the original NovStat V1.1 code.
 *
 */

/* static char rcsid[] = "$Header: /afs/andrew.cmu.edu/system/src/local/novstat/003/src/RCS/prototyp.h,v 1.5 1994/02/15 21:21:50 ms5u Exp $"; */
/* prototyp.h
 *
 * All we do here is declare the functions used everywhere.  Those functions
 * declared in the different modules but which are not to be exported are
 * not included here.
 *
 * Revision History:
 *   $Log: prototyp.h,v $
 * Revision 1.5  1994/02/15  21:21:50  ms5u
 * Add definitions for delold.c module.
 *
 * Revision 1.4  1994/02/15  18:24:47  ms5u
 * Change version to V1.1.
 *
 * Revision 1.3  1993/10/05  15:40:17  ms5u
 * Comment out rcsid for header files.
 *
 * Revision 1.2  1993/10/05  15:34:59  ms5u
 * Add copyright header.
 *
 * Revision 1.1  1993/09/13  19:36:13  ms5u
 * Initial revision
 *
 */

#include <time.h>
#include "acctrec.h"
#include "sparse.h"

/* From load.c */
void LOAD_init(), LOAD_update_filename(), LOAD_idle_counter(),
     LOAD_compute_period_load(), LOAD_graph_console(), LOAD_store(),
     LOAD_flush();
int LOAD_get_load();
struct LOAD_rec {
	int curload;
	time_t curtime;
};

/* From sched.c */
void SCHED_init();

/* From down.c */
int *DOWN_find(char *filename);

/* From report.c */
void REPORT_init(), REPORT_generate();
extern int REPORT_start_month, REPORT_start_day, REPORT_start_year,
	REPORT_start_jul,
	REPORT_end_month, REPORT_end_day, REPORT_end_year, REPORT_end_jul,
	REPORT_weeknum;

/* From acctsum.c */
void REPORT_report_acct(FILE *rptfile, int *downtime);

/* From acctread.c */
int ACCT_openfile(char *filename);
void ACCT_closefile();
void ACCT_initrec(struct ACCT_rec tobe0);
int ACCT_readnextrec(struct ACCT_rec *readrec);
void ACCT_disposerec(struct ACCT_rec *rec);

/* From track.c */
void TRACK_addinfo(LONG net, LONG nodehigh, WORD nodelow, BYTE timestamp[6]);
LONG TRACK_logtime(LONG net, LONG nodehigh, WORD nodelow, BYTE timestamp[6]);
void TRACK_cleanup();

/* From sparse.c */
void SPARSE_increment(struct sparsecounter **list, LONG newval, LONG addtot);
void SPARSE_sort(struct sparsecounter *list);
void SPARSE_cleanup(struct sparsecounter *list);
void SPARSE_m_increment(struct sparse_m_counter **list, LONG newval_1, LONG newval_2, WORD newval_3, LONG addtot);
void SPARSE_m_sort(struct sparse_m_counter *list);
void SPARSE_m_cleanup(struct sparse_m_counter *list);

/* From downrpt.c */
void DOWNRPT_printout_downtime(FILE *rptfile, int *downtime);

/* From delold.c */
void DELOLD_delete_files();
extern int DELOLD_loadfiles, DELOLD_reports;
