/*
 *  NovStat V1.1
 *
 *  Copyright (C) 1993 by Carnegie Mellon University
 *
 *  This software is freely available for any purpose other than commercial
 *  gain.  You may distribute this code provided this copyright remains
 *  intact.  Any modifications made to this code must be noted as not part
 *  of the original NovStat V1.1 code.
 *
 */

static char rcsid[] = "$Header: /afs/andrew.cmu.edu/system/src/local/novstat/003/src/RCS/main.c,v 1.7 1994/02/15 21:21:04 ms5u Exp $";
#include <stdio.h>
#include "prototyp.h"

/* Main routine for NovStat, the Novell NetWare statistics NLM.  All that
 * for which this module is responsible is starting the appropriate threads
 * which will control the rest of the module.
 *
 * With the exception of starting the load computations, everything is done
 * through the scheduler.
 *
 * Revision History:
 *   $Log: main.c,v $
 * Revision 1.7  1994/02/15  21:21:04  ms5u
 * Add the ability to delete old LOADFILE.* and ?REPORT.* files.
 *
 * Revision 1.6  1994/02/15  18:24:12  ms5u
 * Change version to V1.1.
 *
 * Revision 1.5  1993/10/05  15:34:57  ms5u
 * Add copyright header.
 *
 * Revision 1.4  1993/10/05  15:28:47  ms5u
 * Add Carnegie Mellon to startup banner.
 *
 * Revision 1.3  1993/10/05  15:25:46  ms5u
 * Moved startup message to very beginning.
 *
 * Revision 1.2  1993/09/27  17:07:15  ms5u
 * Add startup banner.
 *
 * Revision 1.1  1993/09/13  19:36:03  ms5u
 * Initial revision
 *
 */

void main(int argc, char *argv[])
{
	printf("NovStat V1.1 has been started!\n");

	REPORT_init();
	LOAD_init();
	SCHED_init();
	/* One possibility for the main routine would be to sit and wait
	 * for some "important" keystroke to terminate the NLM, but I
	 * believe that the UNLOAD command is just as easy.
	 */

	if (argc > 1)
		if (sscanf(argv[1], "%d", &DELOLD_loadfiles) != 1)
			DELOLD_loadfiles = 0;

	if (argc > 2)
		if (sscanf(argv[2], "%d", &DELOLD_reports) != 1)
			DELOLD_reports = 0;

	printf("\t(NovStat is a Carnegie Mellon - Special Projects production.)\n\n");

	DELOLD_delete_files();

	/* We "exit" since the NLM won't exit until all threads have
	 * terminated.
	 */
}
