/*
 *  NovStat V1.1
 *
 *  Copyright (C) 1993 by Carnegie Mellon University
 *
 *  This software is freely available for any purpose other than commercial
 *  gain.  You may distribute this code provided this copyright remains
 *  intact.  Any modifications made to this code must be noted as not part
 *  of the original NovStat V1.1 code.
 *
 */

static char rcsid[] = "$Header: /afs/andrew.cmu.edu/system/src/local/novstat/003/src/RCS/downrpt.c,v 1.4 1994/02/15 18:27:41 ms5u Exp $";
/* downrpt.c
 *
 * All we do here is to summarize to the output report file the list of
 * downtimes discovered.
 *
 * Revision History:
 *   $Log: downrpt.c,v $
 * Revision 1.4  1994/02/15  18:27:41  ms5u
 * Change version to V1.1.
 *
 * Revision 1.3  1993/10/07  19:14:55  ms5u
 * Correct downmins calculations to handle multiple days.
 *
 * Revision 1.2  1993/10/05  15:34:54  ms5u
 * Add copyright header.
 *
 * Revision 1.1  1993/09/13  19:35:57  ms5u
 * Initial revision
 *
 */
#include <stdio.h>

static char *DOWNRPT_full_days[7] = { "Sunday", "Monday", "Tuesday",
				     "Wednesday", "Thursday", "Friday",
				     "Saturday" };

void DOWNRPT_printout_downtime(FILE *rptfile, int *downlist)
{
	int *tmp;
	int downfrom, downto, fromwday, towday, curwday;
	int done;
	int downmins;

	fprintf(rptfile, "Downtime detail listing:");

	tmp = downlist;
	curwday = -1;
	downmins = 0;
	while (*tmp != -1)
	{
		downfrom = *tmp++;
		downto = *tmp++;
		fromwday = downfrom / 1440;
		towday = downto / 1440;
		downfrom %= 1440;
		downto %= 1440;

		downmins += (downto - downfrom) + ((towday - fromwday)*1440);

		do
		{
			done = 1;
			if (curwday < fromwday)
			{
				curwday = fromwday;
				fprintf(rptfile, "\n%12s: ",
					DOWNRPT_full_days[curwday]);
			}
			if (curwday == fromwday)
				fprintf(rptfile, "%02d:%02d-",
					downfrom / 60, downfrom % 60);
			else
				fprintf(rptfile, "00:00-");

			if (curwday > towday)
				fprintf(rptfile, "??:?? ");
			else if (curwday == towday)
				fprintf(rptfile, "%02d:%02d ",
					downto / 60, downto % 60);
			else
			{
				fprintf(rptfile, "23:59 ");
				curwday++;
				fprintf(rptfile, "\n%12s: ",
					DOWNRPT_full_days[curwday]);
				done = 0;
			}
		} while (done != 1);
	}
	
	if (curwday == -1)
		fprintf(rptfile, "   No downtimes to report for this week.");

	fprintf(rptfile, "\n\n   System uptime is %d.%02d%% for this week.\n\n",
		(10080 - downmins) * 100 / 10080,
		((10080 - downmins) * 10000 / 10080) % 100);
}

