/*
 *  NovStat V1.1
 *
 *  Copyright (C) 1993 by Carnegie Mellon University
 *
 *  This software is freely available for any purpose other than commercial
 *  gain.  You may distribute this code provided this copyright remains
 *  intact.  Any modifications made to this code must be noted as not part
 *  of the original NovStat V1.1 code.
 *
 */

static char rcsid[] = "$Header: /afs/andrew.cmu.edu/system/src/local/novstat/004/src/RCS/delold.c,v 1.2 1994/02/22 20:05:49 ms5u Exp ms5u $";

/* delold.c
 *
 * This module contains one routine which is called during startup and
 * once per week (via SCHED) to go through and delete the old LOADFILE.nnn
 * and ?REPORT.nn files.
 *
 * Revision History:
 *   $Log: delold.c,v $
 * Revision 1.2  1994/02/22  20:05:49  ms5u
 * Added closedir() calls.
 *
 * Revision 1.1  1994/02/15  21:17:46  ms5u
 * Initial revision
 *
 */

#include <stdio.h>
#include <time.h>
#include <dos.h>
#include <sys\stat.h>
#include <nwdir.h>
#include <direct.h>
#include "prototyp.h"

int DELOLD_loadfiles = 0, DELOLD_reports = 0;

void DELOLD_delete_files()
{
	DIR *dirStructPtr;
	time_t currenttime, delloadtime, delreporttime;
	time_t filetime;
	int loadsdeleted, reportsdeleted;
	char deletename[32];
	
	if (DELOLD_loadfiles > 0)
		printf("Deleting %d-day old LOADFILE.* files and ",
			DELOLD_loadfiles);
	else
		printf("NOT deleting old LOADFILE.* files and ");
	if (DELOLD_reports > 0)
		printf("deleting %d-day old ?REPORT.* files\n",
			DELOLD_reports);
	else
		printf("NOT deleting old ?REPORT.* files\n");

	currenttime = time(NULL);

	if (DELOLD_loadfiles <= 0)
		delloadtime = 0;
	else
		delloadtime = currenttime - (DELOLD_loadfiles * 86400);
	
	if (DELOLD_reports <= 0)
		delreporttime = 0;
	else
		delreporttime = currenttime - (DELOLD_reports * 86400);

	loadsdeleted = 0;

	dirStructPtr = opendir("SYS:\\NOVSTAT\\LOADFILE.*");
	if (dirStructPtr == NULL)
	{
		perror("Cannot open NovStat directory for purging");
		return;
	}

	while (readdir(dirStructPtr) != NULL)
	{
		filetime = _ConvertDOSTimeToCalendar(
			(LONG)(dirStructPtr->d_date * 65536) +
			(LONG)dirStructPtr->d_time);

		if (filetime < delloadtime)
		{
			sprintf(deletename, "SYS:\\NOVSTAT\\%s",
				dirStructPtr->d_name);
			unlink(deletename);
			loadsdeleted++;
		}
	}

	closedir(dirStructPtr);

	reportsdeleted = 0;
	dirStructPtr = opendir("SYS:\\NOVSTAT\\?REPORT.*");
	if (dirStructPtr == NULL)
	{
		perror("Cannot open NovStat directory for purging");
		return;
	}

	while (readdir(dirStructPtr) != NULL)
	{
		filetime = _ConvertDOSTimeToCalendar(
			(LONG)(dirStructPtr->d_date * 65536) +
			(LONG)dirStructPtr->d_time);

		if (filetime < delreporttime)
		{
			sprintf(deletename, "SYS:\\NOVSTAT\\%s",
				dirStructPtr->d_name);
			unlink(deletename);
			reportsdeleted++;
		}
	}
	
	closedir(dirStructPtr);

	if (DELOLD_loadfiles > 0)
	{
		printf("[%d old LOADFILE.* files deleted", loadsdeleted);
		if (DELOLD_reports > 0)
			printf(" and ");
		else
			printf("]\n");
	}
	if (DELOLD_reports > 0)
	{
		if (DELOLD_loadfiles <= 0)
			printf("[");
		printf("%d old ?REPORT.* files deleted]\n", reportsdeleted);
	}
}
