/*
 *  NovStat V1.1
 *
 *  Copyright (C) 1993 by Carnegie Mellon University
 *
 *  This software is freely available for any purpose other than commercial
 *  gain.  You may distribute this code provided this copyright remains
 *  intact.  Any modifications made to this code must be noted as not part
 *  of the original NovStat V1.1 code.
 *
 */

/* static char rcsid[] = "$Header: /afs/andrew.cmu.edu/system/src/local/novstat/003/src/RCS/acctrec.h,v 1.4 1994/02/15 18:22:42 ms5u Exp $"; */
/*
 * acctrec.h
 *
 * Created 4/18/93 by Marc Shannon
 *
 * This header file defines the accounting record structures used by the
 * Novell accounting system.  It is referenced by readrec.c and ...
 *
 * Revision History:
 *   $Log: acctrec.h,v $
 * Revision 1.4  1994/02/15  18:22:42  ms5u
 * Change version to V1.1.
 *
 * Revision 1.3  1993/10/05  15:39:45  ms5u
 * Comment out rcsid for header files.
 *
 * Revision 1.2  1993/10/05  15:32:24  ms5u
 * Add copyright header.
 *
 * Revision 1.1  1993/09/13  19:35:22  ms5u
 * Initial revision
 *
 */

#include <nwtypes.h>

#ifndef ACCTREC_H
#define ACCTREC_H

#define CHARGERECORD 1
#define CHARGEBASELEN 26

#define NOTERECORD 2
#define NOTEBASELEN 22

#define COMMONLENGTH 20

#define CONNECTTIMENOTE 1
#define DISKSTORAGENOTE 2
#define LOGINNOTE 3
#define LOGOUTNOTE 4
#define ACCOUNTLOCKEDNOTE 5
#define SERVERTIMEMODIFIEDNOTE 6

union noterecs {
	struct {
		LONG ConnectTime;
		LONG RequestCount;
		WORD BytesReadHigh, BytesRead2, BytesReadLow;
		WORD BytesWrittenHigh, BytesWritten2, BytesWrittenLow;
	} ConnectTimeNote;
	struct {
		LONG BlocksOwned;
		LONG NumberOfHalfHours;
	} DiskStorageNote;
	struct {
		LONG Net;
		LONG NodeHigh;
		WORD NodeLow;
	} LoginNote;
	struct {
		LONG Net;
		LONG NodeHigh;
		WORD NodeLow;
	} LogoutNote;
	struct {
		LONG Net;
		LONG NodeHigh;
		WORD NodeLow;
	} AccountLockedNote;
	struct {
		BYTE Year, Month, Day, Hour, Minute, Second;
	} ServerTimeModifiedNote;
};

struct ACCT_rec {
	WORD Length;
	LONG ServerID;
	BYTE TimeStamp[6];
	BYTE RecordType;
	BYTE CompletionCode;
	WORD ServiceType;
	LONG ClientID;
	union {
		struct {
			LONG Amount;
			WORD CommentType;
			union noterecs *Comment;
		} ChargeInfo;
		struct {
			WORD CommentType;
			union noterecs *Comment;
		} NoteInfo;
	} variant;
};

#endif /* ACCTREC_H */
