################################################################################
#
#  Copyright 1996 Novell, Inc.  All rights reserved.
#
# ----------------------------------------------------------------------------
#
#             This is the makefile for a sample CGI Extension Nlm
#                   NetWare Web Server CGI Interface Module
#
#           ---- The VCS Floating Label For xxx.Nlm is xxx_1.0 ----
#
# ----------------------------------------------------------------------------
#   Revisions
# ----------------------------------------------------------------------------
#
#   $Logfile:   J:/WEBSERV/PRODTREE/DISK1/WEB/SAMPLES/CGIPARSE/SRC/VCS/MAKEFILE.MAV  $
#  $Revision:   1.1  $
#      $Date:   30 Apr 1996 10:42:54  $
#    $Author:   PTANG  $
#
################################################################################
#
#  The following macros may be specified on the command line or in the DOS
#  environment to request optional processing or specify target version
#  information.
#
#       Make options:
#
#               MOPTS="fpdRes Keep NoLink NoLog NoOpt d x o s r c p"
#
#
#      fpdRes - Specifies not to delete the $(FPD_NAME).out file that's built
#               as a secondary file of the LINT process used to build the
#               Function Prototype Definition file.  The ".OUT" file contains
#               useful analysis information about the set of files used in the
#               process of building the ".FPD" file.  This option should be
#               used occasionally to determine which include files are no
#               longer used in the ".C" file, and which variables are no
#               longer referenced in the source module.
#
#        Keep - Tells Make not to delete the intermediate files that are
#               checked out as a result of the make.  This option must be
#               specified when using this make file to create a new source
#               source environment
#
#      NoLink - Specifies to perform compilations only and NOT link the module
#               into a final NLM
#
#       NoLog - Specifies not to echo the make output to the log file.  When
#               logging is OFF, and an error is detected in the compiled
#               source, the WCC compiler will create an .ERR file containing
#               the errors.  By default, the error information is sent to
#               "all.log".
#
#               The command line macro, "LOG_FIILE", may be used to specify
#               the name of an alternate LOG file other than "all.log".
#               Also, even when the "noLog" option is specified, Make's
#               environment information will be logged to either the default
#               or specified log file.
#
#       NoOpt - Specifies "No Optimization" for the WCC compiler.  This option
#               may be specified at any time, including PRODVER builds.
#
#           d - Enable debugging flags for compile(s) and link.  Debug is ON
#               by default except for production builds, in this case, it
#               must be set as one of the "MOPTS=..." options.
#           x - Skip compile, link and lint steps, i.e., perform only the
#               requested listing operations.
#           o - Generate object module listing files for all changed sources.
#           s - Generate source module listing files for all changed sources.
#           r - Generate cross reference listing.
#           c - Clean-up all .obj, .err and .lst files before starting compile
#           p - Generates a preprocessor file only and puts it in the "OBJ"
#               diectory with a file extension of ".i".
#
#       All MOPTS flags are case insensitive.  If more than one flag is
#       specified all flags must be enclosed in double quotes and separated
#       by one or more SPACES.
#
#
#       Command Line Options:
#
#           LOG_FILE="logfile"
#
#               This command line option may be used to specify an output
#               log file with a name other than "all.log".  By default, the
#               the file will be written to the same directory as the one
#               where Make was started.  Note that even if the MOPTS=NoLog
#               is specified, the environment information for the SDK paths
#               and WCC Compiler variables will be written to the log file
#               as a record of the setttings for the current build.
#
#           PRODVER="version"
#
#               Specifies a PVCS Label associated with the indicated NLM
#               version.  NOTE:  When PRODVER is specified as a make option,
#               the entire build will be done in the directory where MAKE
#               was envoked.  This option is typically specified when when a
#               final production build of the module is being produced.
#               This option also has precedence over the PVCSVER option.
#
#                  1.  xxx.Nlm
#                  2.  xxx.Mdb
#                  3.  xxx.Msg
#                  4.  xxx.Map
#                  5.  All.log
#
#           PVCSVER="version"
#
#               Specifies a PVCS Label associated with the indicated NLM
#               version.  NOTE:  When PVCSVER is specified as a make option,
#               the build will be done using the default directory structure
#               of the following form:
#
#               [bat] [doc] [etc] [inc] [obj] [prod] [src] [vcs]
#
#               With this option specified, source files will be checked out
#               into their respective sub directories.  However, you must
#               specify the MOPTS=keep option if you're using the make file
#               to create the environment with the specified sources.
#
#           NLMVER="version"
#
#               Specifies a the Major, Minor, and Revision values the NLM
#               Linker will encode into the NLM header.  This is the version
#               information that's displayed when the NLM is loaded in the
#               NetWare environment via the "load" command.
#
#
#           NWVER="NetWare OS Version"
#
#               Specifies whether the target OS is either 3.1x or 4.xx.
#               The default is 4.xx.  Depending on the version selected,
#               the target object directory for the compiler and linker
#               will be set to either "obj3", or "obj4".
#
#           MEM=<KB>
#
#               Specifies the amount of memory for compilation
#               default is ??
#
################################################################################
#                                                                              #
#                           Global Macro Definitions                           #
#                                                                              #
################################################################################

NLM_NAME    =  CgiParse                            # Root name of NLM.
FPD_NAME    =  $(NLM_NAME).Fpd                     # Target function prototype definition file.
HLP_NAME    = #$(NLM_NAME).Hlp                     # NLM's NWSNUT Help File Name.
MDB_NAME    =  $(NLM_NAME).Mdb                     # Target NLS Message Database File.
MSG_NAME    =  $(NLM_NAME).Msg                     # Target NLS Linked Message File.

GLB_DRV     =  i:                                  # Global PVCS source drive
SRC_DRV     =  i:                                  # Source drive of NLM code
CC_DRV      =  j:                                  # compiler/tools drive
SDK_DRV     =  k:                                  # NetWare SDK Include and Import files.
SEARCH_DRV  =  l:                                  # appended to the DOS Path for the NovBin directory

            #----------------------- NOTE ---------------------
            #
            #  Due to the line length limitiations imposed by DOS, the ..._MAP
            #  macros had to be defined so that the expanded macro consumed
            #  less command line space.
            #--------------------------------------------------

SRC_MAP     = Sjf-Engr8/vol2:\WebServ\WebSrc       # Source server/volume where source NLM code resides
SDK_MAP     = Sjf-Engr8/vol2:\WebServ\Tools        # Path to SDK includes, etc.
GLB_MAP     = Sjf-Engr8/vol2:\WebServ\WebSrc       # Global PVCS server/volume
CC_MAP      = Sjf-Engr8/vol2:\WebServ\Tools        # Tools server/volume

CC_PATH     =  $(CC_DRV)386Watc9.5                 # path to Watcom NLM compilers
BC45_PATH   =  #$(CC_DRV)\APPS\DOS\BC45            # path to Borland compilers
SDK_PATH    =  $(SDK_DRV)sdk40.30                  # path to root of NetWare SDK
SNMP_PATH   =  #$(SDK_DRV)\snmpsdk\v2.1            # path to SNMP SDK directory  
BTRV_EXE    =  $(SDK_PATH)\btrv                    # path to Btrieve Exe's
NLS_EXE     =  $(SDK_PATH)\novbin                  # path to NLS Message Tools

SRC_PATH    =  $(SRC_DRV)prodtree\disk1\web\samples\cgiParse # path to NLM source 
MDB_PATH    =  $(SRC_PATH)\Etc                     # path to NLM global MDB file 
SRC_VCS     =  $(SRC_PATH)\Vcs                     # path to NLM source PVCS directory.

GLB_VCS     = #$(GLB_DRV)\CsGlbl\Vcs               # path to global PVCS directory 

#-----------------------------------------------------------------------------
#  Kill use of built-ins
#-----------------------------------------------------------------------------

%if %member (keep, $[u, $(MOPTS)]) 
.PRECIOUS                        # Keep around intermediate files.
%endif

.SUFFIXES                        # Don't use the Builtins.Mak macros.
.SILENT                          # Don't echo any junk to STDOUT.
.NOREMAKE                        # Don't constantly check to see if we need to make it again.

################################################################################
#                                                                              #
#                               Version Macros                                 #
#                                                                              #
################################################################################
#
#  Unless otherwise directed by the NLMVER parameter, we must parse the NLM 
#  version string out of the PVCS version label, the PVCS version label MUST 
#  be of the form "CGIPARSE_dddd..." where dddd represents the major version, 
#  minor version, and revsion level.  The parsed value in NLMVERSION is used 
#  by the linker, NLMLinkR, to set the version string encoded in the NLM.
#
#  By default, we assume the NLM Link version will be the same as the PRODVER
#  or PVCSVER.  However, if the user has specified the NLMVER on the command
#  line, the specified version will be used with the Linker as the NLM version
#  label.  The NLM version label is the version displayed when the NLM is 
#  loaded via the "load" command.
#-------------------------------------------------------------------------------

%if %defined (PRODVER) && !%defined (PVCSVER)
   PVCSVER     =  $(PRODVER)              # Define the PVCS Label to check sources against.
   NLMVERSION  =  $[c, $(PRODVER), 8, ]   # Parse out the "x.x.x" form of the NLM version. 
                                          # "8" is the position of the first character we want to read.

%elseif !%defined (PRODVER) && %defined (PVCSVER)

.PRECIOUS                                 # Keep around intermediate files.

%if !%defined (NLMVER)
   NLMVERSION  =  $[c, $(PVCSVER), 8, ]   # Parse out the "x.x.x" form of the NLM version. 
%endif
%endif

   #---------------------------------------------------------------------------
   #                       ------- NOTE --------
   #
   #  If the user has specified the PVCSVER command line parameter without 
   #  also specifying the NLMVER macro, the NLMVERSION macro will be parsed 
   #  from the standard form of the PVCSVER label.  When the user doesn't 
   #  specify either PRODVER, PVCSVER, or NLMVER, the NLMVERSION which will 
   #  be displayed when the NLM is loaded, will be set to the default value 
   #  of "1.0.0".
   #---------------------------------------------------------------------------

%if %defined (NLMVER)                     # Command line parameter present
   NLMVERSION  =  $(NLMVER)               # User has defined the "x.x.x" form of the NLM version.
%endif

%if !%defined (NLMVERSION)                # this is the engineering build
   NLMVERSION  =  1.0.0                   # set the default NLM Link version for development builds.
%endif

%if !%defined (NWVER)                     # Set target OS Version (def = 4.xx).
   NW_VER = 4.xx
%elseif "$[c,_$(NWVER),1,2]" == "_3"      # The NW_VER macro will be used to
   NW_VER = 3.1x                          # set the target OBJ directory to
%else                                     # either "obj3" or "obj4".
   NW_VER = 4.xx
%endif

################################################################################
#                                                                              #
#     Configuration Management/Engineering Directory Environment Macros        #
#                                                                              #
################################################################################

%if %defined (PRODVER)

   #-----------------------------------------------------------------------
   #  If we are doing a production version make, define the directory 
   #  organization for the production environment.  
   #-----------------------------------------------------------------------

   BAT   =  .
   DOC   =  .
   ETC   =  .
   INC   =  .
   MDB   =  .

%if "$(NW_VER)" == "3.1x"
   OBJ   =  obj
%else
   OBJ   =  obj
%endif

   FPD   =  $(OBJ)
   PROD  =  .
   SRC   =  .
   VCS   =  $(SRC_VCS)

   NLM   =  .
   IMP   =  .
   LOB   =  .
   ERR   =  .
   LIB   =  .

   #-----------------------------------------------------------------------
   #  If we're doing an engineering build, define the directory structure 
   #  for the local engineering environment.  
   #-----------------------------------------------------------------------

%else

   BAT   =  ..\bat
   DOC   =  ..\doc
   ETC   =  ..\etc
   INC   =  ..\inc
   MDB   =  $(MDB_PATH)

%if "$(NW_VER)" == "3.1x"
   OBJ   =  ..\obj
%else
   OBJ   =  ..\obj
%endif

   FPD   =  $(OBJ)
   PROD  =  ..\prod
   SRC   =  ..\src
   VCS   =  ..\vcs

   NLM   =  ..\etc
   IMP   =  $(ETC)
   LOB   =  $(OBJ)
   ERR   =  ..\src
   LIB   =  $(OBJ)

%endif

################################################################################
#                                                                              #
#                               Log File Macro                                 #
#                                                                              #
################################################################################

%if !%defined (LOG_FILE)
   LOG_FILE =  $(SRC)\all.log
%endif

ENV_LOG  =  >> $(LOG_FILE) 

%if %member (noLog, $[u, $(MOPTS)]) 
   ECHO_LOG =  >> $(LOG_FILE)
   MAKE_LOG =  
   LINK_LOG =  
%else
   ECHO_LOG =  >> $(LOG_FILE)
   MAKE_LOG =  >> $(LOG_FILE)
   LINK_LOG =  >> $(LOG_FILE)
%endif

################################################################################
#                                                                              #
#                    NetWare Compiler "Include" Directories                    #
#                                                                              #
################################################################################

WCC_INC  =  $(CC_PATH)\h
NOVI     =  $(SDK_PATH)\novi
NOVH     =  $(SDK_PATH)\novh
SNMPI    =  $(SNMP_PATH)\imp
SNMPH    =  $(SNMP_PATH)\h

################################################################################
#                                                                              #
#                            File Extension Directives                         #
#                                                                              #
################################################################################
#
#  Specify the source paths for the non-archived files.
#-------------------------------------------------------------------------------

.SOURCE.386    : $(SRC)
.SOURCE.asm    : $(SRC)
.SOURCE.c      : $(SRC)
.SOURCE.fpd    : $(FPD)
.SOURCE.h      : $(INC) $(NOVH) $(SNMPH) $(WCC_INC)
.SOURCE.hlh    : $(INC)
.SOURCE.hlp    : $(ETC)
.SOURCE.imp    : $(IMP) 
.SOURCE.mdb    : $(MDB)
.SOURCE.mlc    : $(SRC)
.SOURCE.mlh    : $(INC)
.SOURCE.msg    : $(ETC)
.SOURCE.obj    : $(OBJ)
.SOURCE.obk    : $(OBJ)
.SOURCE.lib    : $(LIB)
.SOURCE.lob    : $(LOB)
.SOURCE.Nlm    : $(NLM)

#-------------------------------------------------------------------------------
#  Specify the source path and file extensions for any PVCS archived files.
#-------------------------------------------------------------------------------

%if %defined (PVCSVER)

   #-------------------------------------------------------------------------
   #  By default, PVCS is disabled for a typical engineering build.  This 
   #  allows the developer to NOT have to worry about changes that may have 
   #  been made in one of the global PVCS environments while they're working
   #  on development changes of their own.  Occasionally however, the 
   #  developer should run this make file with the PVCSVER macro set to the 
   #  floating PVCS label for this module, which will enbale PVCS for the 
   #  current build and bring in any new files that have been archived.  Note
   #  that MOPTS=Keep must be specified so that the refreshed files are not
   #  deleted at the end of the make process.

.SOURCE.3v6    : $(SRC_VCS) $(GLB_VCS)
.SOURCE.asv    : $(SRC_VCS) $(GLB_VCS)
.SOURCE.c_v    : $(SRC_VCS) $(GLB_VCS)
.SOURCE.hvh    : $(SRC_VCS) $(GLB_VCS)
.SOURCE.hvp    : $(SRC_VCS) $(GLB_VCS)
.SOURCE.h_h    : $(SRC_VCS) $(GLB_VCS)
.SOURCE.h_p    : $(SRC_VCS) $(GLB_VCS)
.SOURCE.h_v    : $(SRC_VCS) $(GLB_VCS)
.SOURCE.imv    : $(SRC_VCS) $(GLB_VCS)
.SOURCE.mdv    : $(SRC_VCS)
.SOURCE.mvc    : $(SRC_VCS) $(GLB_VCS)
.SOURCE.mvh    : $(SRC_VCS) $(GLB_VCS)
.SOURCE.m_c    : $(SRC_VCS) $(GLB_VCS)
.SOURCE.m_h    : $(SRC_VCS) $(GLB_VCS)
.SOURCE.obv    : $(SRC_VCS) $(GLB_VCS)

.LOGFILE .3v6  (.386 -v"$(PVCSVER)")
.LOGFILE .asv  (.asm -v"$(PVCSVER)")
.LOGFILE .c_v  (.c   -v"$(PVCSVER)")
.LOGFILE .evc  (.elc -v"$(PVCSVER)")
.LOGFILE .evh  (.elh -v"$(PVCSVER)")
.LOGFILE .e_c  (.elc -v"$(PVCSVER)")
.LOGFILE .e_h  (.elh -v"$(PVCSVER)")
.LOGFILE .h_v  (.h   -v"$(PVCSVER)")
.LOGFILE .hvh  (.hlh -v"$(PVCSVER)")
.LOGFILE .hvp  (.hlp -v"$(PVCSVER)")
.LOGFILE .h_h  (.hlh -v"$(PVCSVER)")
.LOGFILE .h_p  (.hlp -v"$(PVCSVER)")
.LOGFILE .imv  (.imp -v"$(PVCSVER)")
.LOGFILE .mdv  (.mdb -v"$(PVCSVER)")
.LOGFILE .mvc  (.mlc -v"$(PVCSVER)")
.LOGFILE .m_c  (.mlc -v"$(PVCSVER)")
.LOGFILE .mvh  (.mlh -v"$(PVCSVER)")
.LOGFILE .m_h  (.mlh -v"$(PVCSVER)")
.LOGFILE .obv  (.obk -v"$(PVCSVER)")

%endif

################################################################################
#                                                                              #
#                               File List Macros                               #
#                                                                              #
################################################################################
#
#  Explicitly define the list of source and include files containing strings
#  to be extracted for the NLS message database, $(MDB_NAME).  
#
#  NOTE:  Due to the way in which the extracted strings are used in the 
#  compiled source, two macros are defined for the different string files.  
#  The definition of the macros and the command line syntax for the extraction
#  utility is given below.
#
#     #define NumMSG(string, id)  id   
#     msgextr -m$(MDB)\$(MDB_NAME) -r -w -tNumMSG -s<dir>\<file name>
#
#     BYTE ** msgTable;
#     #define MSG(string, id)  xx_MsgTable [id]
#     msgextr -m$(MDB)\$(MDB_NAME) -r -w -tMSG    -s<dir>\<file name>
#
#-------------------------------------------------------------------------------

NUMMSG_LST  =  $(SRC)\xxMsgTbl.c 
MSG_LST     =  #$(INC)\xxText.h 
MDB_LST     =  $(NUMMSG_LST) $(MSG_LST)

#-------------------------------------------------------------------------------
#  Explicitly define a list of all source modules.  If you stick with a sorted
#  order, it's easier to tell how far along your make is when its running.
#  
#                           ------- N O T E --------
#  
#  The list of files that are specified by "SRC_LST", "INC_LST", and "GINC_LST"
#  will be used by Make and PVCS to determine whether the files reside in a
#  PVCS environment, and will be checked out as needed before the Lint for 
#  the Function Prototype Header file or the start of the compile(s).  The 
#  WCC_INC "\h" and the SDK "\NOVH" files do not need to be defined in any 
#  of these lists.
#-------------------------------------------------------------------------------

ASM_LST  =  

#				                          12345678.123
CPP_LST  =	cgiMain.c    xxDebug.c	  xxMsgTbl.c   

SRC_LST  =  $(ASM_LST) $(CPP_LST)

#-------------------------------------------------------------------------------
#  Specify the set of include files that are owned (local PVCS files) by this 
#  module.  This file set is used to insure that all necessary include files
#  are obtained from PVCS when generating function prototype include files.
#-------------------------------------------------------------------------------

#			                             12345678.123
INC_LST  =  cgiApi.h     csSysMsg.h	  xxDecl.h     

#-------------------------------------------------------------------------------
#  Specify the set of global header files that are not owned by this module, 
#  but ARE archived in PVCS.  This file set is used to indicate to lint that
#  these are library header files as well as being used to insure all files
#  are obtained from PVCS when generating function prototype include files.
#-------------------------------------------------------------------------------

GINC_LST =  

#-------------------------------------------------------------------------------
#  Specify a list of all linker export files.  This list will be used as a
#  dependency for the target NLM, therefore you may wish to omit import files
#  shipped with the compiler.
#-------------------------------------------------------------------------------

IMP_LST     =  csSysMsg.imp cgiApi.imp
NOV_IMP_LST =  cLib.imp     
EXP_LST     =  

#-------------------------------------------------------------------------------
#  Generate a list of all object modules from the list of all source modules.
#-------------------------------------------------------------------------------

OBJ_LST  =  $[f,"$()",$(SRC_LST),obj]

#-------------------------------------------------------------------------------
#  Generate a list of all lint object modules from the list of all source
#  modules.
#-------------------------------------------------------------------------------

#LOB_LST  =  $[f,"$()",$(SRC_LST),lob]

################################################################################
#                                                                              #
#                               Command Macros                                 #
#                                                                              #
################################################################################
#
#  Macro to set the compiler flags.  If the MOPTS "d" flag is set, generate
#  line number and symbol table info.  If the MOPTS "p" flag is set, generate
#  a preprocessor output file only.  Otherwise standard (unoptimized) compile.  
#  Note that the debug and preprocessor options can be enabled for either type
#  of build.
#-------------------------------------------------------------------------------

# -fw    == fullwarn
# -twoc  == twocase

BC45  =  1

%if %defined (BC45)
   #  original =  /q /mx /m /w+ 
   ASM_FLAGS   =  /mx /m /w+ /w2
%else
   ASM_FLAGS   =  -twoc -fw
%endif

# -3s    == generates 386 instructions 
# -ei		==	allocate "enum" storage as "int"
# -ez    == does phar lap OMF instead of microsoft OMF format
# -od    == no optimization is done
# -s     == stack overflow checking is omitted from the code
# -w4    == generates warning level 4 messages
# -zq    == quiet mode, informational messages suppressed
# -zp1   == structures are BYTE alligned

%if !%defined (PRODVER) || %member (noOpt, $[u, $(MOPTS)])
   WCC_FLAGS   =  -od -ei -ez -3s -s -w4 -zq -zp1 -fo=$(OBJ)\$()
%else
   WCC_FLAGS   =  -oaxt -ei -ez -3s -s -w4 -zq -zp1 -fo=$(OBJ)\$()
%endif

%if !%defined (PRODVER) || %member (d, $[u, $(MOPTS)])
   LNK_DBG  =  debug
   CFLAGS  += -d1
%endif

%if %member (p, $[u, $(MOPTS)])
   CFLAGS  += -pcl 
%endif

%if "$(NW_VER)" == "3.1x"
   OSVER    =  NW3x
%else
   OSVER    =  NW4x
%endif

DFLAGS      =  -d$(OSVER) -dNWNLM
					# -dBUFIOSTR_DEBUG

#-------------------------------------------------------------------------------
#  Define command lines for compiling source files
#-------------------------------------------------------------------------------

CC_MSG      =  Beginning compile of
CC          =  $(CC_PATH)\bin\wcc386p $(DFLAGS) $(CFLAGS)
CC_VER      =  v9.5

ASM_MSG     =  Beginning assembly of

%if %defined (BC45)
   ASM_CMD  =  $(BC45_PATH)\bin\tasm
   ASM_INC  =  /i$(INC)
%else
   #ASM_CMD =  *$(CC_DRV)\assemble\386\386asmp
   ASM_CMD  =  *$(SRC_DRV)\pa0526\tools\pharlap2.2d\386asmp
   ASM_INC  =  -i $(INC)\
%endif

#-------------------------------------------------------------------------------
#
#  Common local imput script for NLM linker (NlmLinkR)
#
#-------------------------------------------------------------------------------

#OPTION   SYNCHRONIZE                                                       ^!\

%if %defined (BC45)

LINK_LIS= \
FORMAT   NOVELL NLM 'NetWare HTTP CGI Extension Module:  CgiSdk Nlm'       ^!\
OPTION   COPYRIGHT  '(c) Copyright 1996 Novell, Inc.  All rights reserved.'^!\
NAME     $(NLM)\$(NLM_NAME).nlm                                            ^!\
SORT                                                                       ^!\
OPTION   VERBOSE                                                           ^!\
OPTION   MAP      = $(NLM)\$(NLM_NAME).Map                                 ^!\
OPTION   SYMFILE  = $(NLM)\$(NLM_NAME).Sym                                 ^!\
OPTION   STACK    = 0x400                                                  ^!\
OPTION   VERSION  = $(NLMVERSION)                                          ^!\
OPTION   MESSAGES = $(ETC)\$(MSG_NAME)                                     ^!\
DEBUG    NOVELL                                                            ^!\
OPTION   SCREENNAME 'None'                                                 ^!\
OPTION   THREADNAME '$(NLM_NAME)'                                          ^!\
FILE     $(NOVI)\prelude.obj                                               ^!\
FILE     $[s,",\n\t\t",$[f,$(OBJ),$(OBJ_LST),$()]]                         ^!\
MODULE	Http.Nlm                                                          ^!\
MODULE	CsSysMsg.Nlm                                                      ^!\
IMPORT   @$[s,",\n\t@",$[f,$(NOVI),$(NOV_IMP_LST),$()]]                    ^!\
IMPORT   OutputToScreen                                                    ^!\
IMPORT   Tonto                                                             ^!\
IMPORT   ImportPublicSymbol                                                ^!\
IMPORT   UnImportPublicSymbol                                              ^!\
IMPORT   @$[s,",\n\t@",$[f,$(IMP),$(IMP_LST),$()]]                         ^!\

#EXPORT   @$[s,",\n\t@",$[f,$(IMP),$(EXP_LST),$()]]                         ^!\
#EXPORT   DebugFindNearestSymbol                                           ^!\
#EXPORT   DebugUnassemble                                                  ^!\

%else

LINK_LIS= \
description    "Nios 32-Bit Extended Debug Facility (EDF)"                   ^!\
version        $[t, ., ",", $(NLMVERSION)]                                   ^!\
copyright      "Copyright 1995 Novell, Inc.  All rights reserved."           ^!\
output         $(NLM)\$(NLM_NAME).Nlm                                        ^!\
start          Nios_EatMem_Main                                              ^!\
exit           Nios_EatMem_Exit                                              ^!\
%if 0
input          $(NOVI)\prelude.obj                                           ^!\
%endif
input          $[s,"\n\t\t",$[f,$(OBJ),$(OBJ_LST),$()]]                      ^!\
map            $(NLM)\$(NLM_NAME).map                                        ^!\
%if 0
synchronize                                                                  ^!\
%endif
stack          0x4000                                                        ^!\
$(LNK_DBG)                                                                   ^!\
screenname     "None"                                                        ^!\
threadname     "$(NLM_NAME)"                                                 ^!\
messages       $(ETC)\$(MSG_NAME)                                            ^!\
import         @$[s,"\n\t\t@",$[f,$(IMP),$(IMP_LST),$()]]                    ^!\
%if 0
rls
help           $(ETC)\$(HLP_NAME)                                            ^!\
module         NwsNut.Nlm                                                    ^!\
               Btrieve.Nlm                                                   ^!\
import         Abend                                                         ^!\
               btrvID                                                        ^!\
               CloseFile                                                     ^!\
               StartSleepNotAllowed                                          ^!\
               DisableInputCursor                                            ^!\
               EndSleepNotAllowed                                            ^!\
               CValidateMappedAddress                                        ^!\
               CValidatePointer                                              ^!\
               EnableInputCursor                                             ^!\
               GetFileSize                                                   ^!\
               GetKey                                                        ^!\
               GetNLMNames                                                   ^!\
               GetNLMVersionInfo                                             ^!\
               GetPublicAddress                                              ^!\
               InputFromKeyboard                                             ^!\
               InputFromScreen                                               ^!\
               INWDOSClose                                                   ^!\
               INWDOSCreate                                                  ^!\
               INWDOSCreateDirectory                                         ^!\
               INWDOSDiskReset                                               ^!\
               INWDOSGetCurrentDirectory                                     ^!\
               INWDOSGetDefaultDrive                                         ^!\
               INWDOSIsNetwork                                               ^!\
               INWDOSOpen                                                    ^!\
               INWDOSRead                                                    ^!\
               INWDOSShutOffFloppyDrive                                      ^!\
               INWDOSWrite                                                   ^!\
               OpenFileUsingSearchPath                                       ^!\
               OutputToScreen                                                ^!\
               OutputToScreenWithPointer                                     ^!\
               PauseWithEscape                                               ^!\
               ReadFile                                                      ^!\
               ReturnResourceTag                                             ^!\
               SetInputToOutputCursorPosition                                ^!\
               SizeOfAllocBlock                                              ^!\
               UnformattedOutputToScreen                                     ^!\
import         @$[s,"\n\t\t@",$[f,$(NOVI),$(NOV_IMP_LST),$()]]               ^!\
rls
%endif
export	CeAlloc                                                             ^!\
export	CeFreeA                                                             ^!\
export         nDebugFindNearestSymbol                                       ^!\
export         nDebugUnassemble                                              ^!\

#export         CSSM_DisplayCsErrorMsg                                        ^!\
#               CeGetServerVer                                                ^!\
#export         @$[s,"\n\t\t@",$[f,$(IMP),$(EXP_LST),$()]]                    ^!\
#              @$[s,"\n\t\t@",$[f,$(IMP),$(IMP_LST),$()]]                    ^!\

%endif

#-------------------------------------------------------------------------------
#  Define command lines for generating lint files.
#-------------------------------------------------------------------------------

LINT_MSG    =  Beginning lint of
LINT_CMD    =  :*$(CC_DRV)\langtool\pclint.386\v5.00\lint

#-------------------------------------------------------------------------------
#  Define common portion of lint local input script
#-------------------------------------------------------------------------------

LINT_LIS = \
-cwc -si4 -sl4 -sp4 -t3 -Width(132,3) -$$ -v                                 ^!\
$(DFLAGS)                                                                    ^!\
-idlen(31,cp) -idlen(40,x)                                                   ^!\
-i$(INC)\$()                                                                 ^!\
-i$(NOVH)\$()                                                                ^!\
-i$(WCC_INC)\$()                                                             ^!\
+libclass(angle,ansi)                                                        ^!\
+libdir($(NOVH)\$())                                                         ^!\
+libdir($(WCC_INC)\$())                                                      ^!\
+libh($[s,")\n+libh(",$(INC_LST)])                                           ^!\
+libh($[s,")\n+libh(",$(GINC_LST)])                                          ^!\

#-------------------------------------------------------------------------------
#  Define command lines for PVCS
#-------------------------------------------------------------------------------

VCSF        =  -w                             #  PVCS flag macro 
V           =  -v"$(PVCSVER)"
GET_CMD     =  =&:get -q -w $(V)
GET_MSG     =  Getting

#-------------------------------------------------------------------------------
#  Define command line for generating object listings.
#-------------------------------------------------------------------------------

OLST_MSG    =  %echo Beginning object listing of
OLST_CMD    =  -*$(CC_PATH)\binb\wdisasm /l /s

#-------------------------------------------------------------------------------
#  Define command line for the link command.
#-------------------------------------------------------------------------------

LINK_MSG    =  Beginning Link of $(NLM_NAME).Nlm.

%if %defined (BC45)
LINK_CMD    =  $(CC_PATH)\bin\wlink
%else
LINK_CMD    =  $(NLS_EXE)\NlmLinkX
%endif

#-------------------------------------------------------------------------------
#  Define command line for NLM packing command
#-------------------------------------------------------------------------------

PACK_MSG    =  Beginning Pack of $(NLM_NAME).Nlm for NetWare $(OS_VER)
PACK_CMD    =  :$(NLS_EXE)\nlmPack

#-------------------------------------------------------------------------------
#  Define command line for generating source listings
#-------------------------------------------------------------------------------

SLST_MSG    =  %echo Beginning source listing of
SLST_CMD    =  -*clist /t3 /o

#-------------------------------------------------------------------------------
#  Define command lines for generating xref files.
#-------------------------------------------------------------------------------

XREF_MSG    =  %echo Beginning cross reference generation of
XREF        =  -*xrefc -I
XMRG_MSG    =  %echo Merging cross reference files
XMRG        =  -*xmrg -M $(ETC)\$(NLM_NAME) -I
XLIST_MSG   =  %echo Listing cross reference
XLIST       =  -*xlist -PL 55 -PW 132 -L $(ETC)\$(NLM_NAME) -T "XREF Listing for $(NLM_NAME)" -I $(ETC)\$(NLM_NAME)

#-------------------------------------------------------------------------------
#  If the MOPTS "c" flag is set, define the C macro to create the clean 
#  dependency.
#-------------------------------------------------------------------------------

%if %member (c, $[u, $(MOPTS)])
   C  =  clean
%endif

#-------------------------------------------------------------------------------
#  Define single character macros for expanding the MOPTS "o", "s", and "r" flags.
#-------------------------------------------------------------------------------

O     =  objlst
OLST  =  objlst

S     =  srclst
SLST  =  srclst

R     =  xref
XLST  =  xref

#-------------------------------------------------------------------------------
#  Step completion without error macro
#-------------------------------------------------------------------------------

DONE_MSG  =  Complete

################################################################################
#                                                                              #
#                      Target/Depencency Line Definitions                      #
#                                                                              #
################################################################################
#
#  If the NLS messages database is missing, generate a new one.
#-------------------------------------------------------------------------------

%if !%exists ($(MDB)\$(MDB_NAME)) || %defined (PRODVER)
   MDB_DEP  =  #make_mdb
%endif

#-------------------------------------------------------------------------------
#  If the function prototype definitions include file is missing, generate a
#  new one.
#-------------------------------------------------------------------------------

%if !%exists ($(FPD)\$(FPD_NAME))
   PROTODEP =  makeprot
%endif

#-------------------------------------------------------------------------------
#  Define the target dependencies for the current build.  Note that the targets
#  defined in HEADDEP will be built in the same order they are defined in, 
#  regardless of the order in which the target/operation lines appear following 
#  the "head : HEADDEP" primary target definition.
#-------------------------------------------------------------------------------

HEADDEP  =  $(C) $(MDB_DEP) $(MSG_NAME) $(PROTODEP) $(NLM_NAME).Nlm $(HLP_NAME)

################################################################################
#                                                                              #
#                              GENERALIZED RULES                               #
#                                                                              #
################################################################################
#
#  Create a .obj file from a .c file by executing the C compiler.  If the MOPTS
#  'x' flag is set, skip the actual compile.
#-------------------------------------------------------------------------------

.c.obj:
%if !%member (x, $[u, $(MOPTS)])
   @echo --- $(ECHO_LOG)
   @echo $(CC_MSG) $[f,"$()",$<,"$()"] $(ECHO_LOG)
   %echo $(CC_MSG) $[f,"$()",$<,"$()"]
   @echo $(CC) $< $(ECHO_LOG)
   $(CC) $< $(MAKE_LOG)
   %if %exists ($[f,"$()",$<,err])
      @echo del $[f,"$()",$<,err]  $(ECHO_LOG) 
      @del $[f,"$()",$<,err]  $(MAKE_LOG) 
   %endif
   @echo $(DONE_MSG) $(ECHO_LOG)
   %echo $(DONE_MSG)
%endif

#-------------------------------------------------------------------------------
# rule to make an .obj file from a .mlc (Cworthy message lib) source file
#-------------------------------------------------------------------------------

.mlc.obj:
%if !%member (x, $[u, $(MOPTS)])
   @echo --- $(ECHO_LOG)
   @echo $(CC_MSG) $[f,"$()",$<,"$()"] $(ECHO_LOG)
   %echo $(CC_MSG) $[f,"$()",$<,"$()"]
   @echo $(CC) $< $(ECHO_LOG)
   $(CC) $< $(MAKE_LOG)
   %if %exists($[f,"$()",$<,err])
      @echo del $[f,"$()",$<,err]  $(ECHO_LOG) 
      @del $[f,"$()",$<,err]  $(MAKE_LOG) 
   %endif
   @echo $(DONE_MSG) $(ECHO_LOG)
   %echo $(DONE_MSG)
%endif

#-------------------------------------------------------------------------------
#  Create a .obj file from a .asm file by executing the assembler.  If the 
#  MOPTS 'x' flag is set, skip the actual compile.
#-------------------------------------------------------------------------------

.PATH.obj = ..\obj

%if %defined (BC45)

.asm.obj:
   @echo Assembling $[r,$@].asm
   >$(ASM_CMD) /i$(INC) /q /mx /m /w+ $[d,$<]\$[r,$<].asm,$*.obj; >$[r,$@].err
#  >tasmx $(ADEBUG) /i$(INC) /q /mx /m /w+ $[d,$<]\$[r,$<].asm,$*.obj; >$[r,$@].err
   %if %status != 0
      @%echo *** ERRORS DURING COMPILE ***
      @type $[r,$@].err
      @%abort
   %end
   @type $[r,$@].err
   @del $[r,$@].err

%else

.asm.obj:
%if !%member (x, $[u, $(MOPTS)])
   @echo --- $(ECHO_LOG)
   @echo $(ASM_MSG) $[f,"$()",$<,"$()"] $(ECHO_LOG)
   %echo $(ASM_MSG) $[f,"$()",$<,"$()"]
#   @echo $(ASM_CMD) $< -o $*.obj $(ASM_INC) $(ASM_FLAGS) $(ECHO_LOG)
#   $(ASM_CMD) $< -o $*.obj $(ASM_INC) $(ASM_FLAGS) 
   @echo $(ASM_CMD) $< $(ASM_INC) $(ASM_FLAGS) $(ECHO_LOG)
   $(ASM_CMD) $< $(ASM_INC) $(ASM_FLAGS) 
   %if %exists($[f,"$()",$<,err])
      @echo del $[f,"$()",$<,err] $(ECHO_LOG) 
      @del $[f,"$()",$<,err] $(MAKE_LOG) 
   %endif
   @echo $(DONE_MSG) $(ECHO_LOG) 
   %echo $(DONE_MSG)
%endif

%endif

#-------------------------------------------------------------------------------
#-------------------------- Beginning of PVCS Checking -------------------------

%if %defined (PVCSVER)

#-------------------------------------------------------------------------------
#  Create a .c file from a .c_v file by doing a PVCS get.
#-------------------------------------------------------------------------------

.c_v.c:
   @echo $(GET_MSG) $@     $(ECHO_LOG)
   %echo $(GET_MSG) $@
   $(GET_CMD) $<($@)       $(MAKE_LOG)

#-------------------------------------------------------------------------------
#  Create a .h file from a .h_v file by doing a PVCS get.
#-------------------------------------------------------------------------------

.h_v.h:
   @echo $(GET_MSG) $@     $(ECHO_LOG)
   %echo $(GET_MSG) $@
   $(GET_CMD) $<($@)       $(MAKE_LOG)

#-------------------------------------------------------------------------------
#  Create a .mlh file from a .mvh file by doing a PVCS get.
#-------------------------------------------------------------------------------

.mvh.mlh:
   @echo $(GET_MSG) $@     $(ECHO_LOG)
   %echo $(GET_MSG) $@
   $(GET_CMD) $<($@)       $(MAKE_LOG)

#-------------------------------------------------------------------------------
#  Create a .mlh file from a .m_h file by doing a PVCS get.
#-------------------------------------------------------------------------------

.m_h.mlh:
   @echo $(GET_MSG) $@     $(ECHO_LOG)
   %echo $(GET_MSG) $@
   $(GET_CMD) $<($@)       $(MAKE_LOG)

#-------------------------------------------------------------------------------
#  Create a .mdb file from a .mdv file by doing a PVCS get.
#-------------------------------------------------------------------------------

.mdv.mdb:
   @echo $(GET_MSG) $@     $(ECHO_LOG)
   %echo $(GET_MSG) $@
   $(GET_CMD) $<($@)       $(MAKE_LOG)

#-------------------------------------------------------------------------------
#  Create a .mlc file from a .mvc file by doing a PVCS get.
#-------------------------------------------------------------------------------

.mvc.mlc:
   @echo $(GET_MSG) $@     $(ECHO_LOG)
   %echo $(GET_MSG) $@
   $(GET_CMD) $<($@)       $(MAKE_LOG)

#-------------------------------------------------------------------------------
#  Create a .mlc file from a .m_c file by doing a PVCS get.
#-------------------------------------------------------------------------------

.m_c.mlc:
   @echo $(GET_MSG) $@     $(ECHO_LOG)
   %echo $(GET_MSG) $@
   $(GET_CMD) $<($@)       $(MAKE_LOG)

#-------------------------------------------------------------------------------
#  Create a .hlh file from a .hvh file by doing a PVCS get.
#-------------------------------------------------------------------------------

.hvh.hlh:
   @echo $(GET_MSG) $@     $(ECHO_LOG)
   %echo $(GET_MSG) $@
   $(GET_CMD) $<($@)       $(MAKE_LOG)

#-------------------------------------------------------------------------------
#  Create a .hlh file from a .h_h file by doing a PVCS get.
#-------------------------------------------------------------------------------

.h_h.hlh:
   @echo $(GET_MSG) $@     $(ECHO_LOG)
   %echo $(GET_MSG) $@
   $(GET_CMD) $<($@)       $(MAKE_LOG)

#-------------------------------------------------------------------------------
#  Create a .hlp file from a .hvp file by doing a PVCS get.
#-------------------------------------------------------------------------------

.hvp.hlp:
   @echo $(GET_MSG) $@     $(ECHO_LOG)
   %echo $(GET_MSG) $@
   $(GET_CMD) $<($@)       $(MAKE_LOG)

#-------------------------------------------------------------------------------
#  Create a .hlp file from a .h_p file by doing a PVCS get.
#-------------------------------------------------------------------------------

.h_p.hlp:
   @echo $(GET_MSG) $@     $(ECHO_LOG)
   %echo $(GET_MSG) $@
   $(GET_CMD) $<($@)       $(MAKE_LOG)

#-------------------------------------------------------------------------------
#  Create a .imp file from a .imv file by doing a PVCS get.
#-------------------------------------------------------------------------------

.imv.imp:
   @echo $(GET_MSG) $@     $(ECHO_LOG)
   %echo $(GET_MSG) $@
   $(GET_CMD) $<($@)       $(MAKE_LOG)

#-------------------------------------------------------------------------------
# rule to get a .asm file from .asv file
#-------------------------------------------------------------------------------

.asv.asm:
   @echo $(GET_MSG) $@     $(ECHO_LOG)
   %echo $(GET_MSG) $@
   $(GET_CMD) $<($@)       $(MAKE_LOG)

#-------------------------------------------------------------------------------
# rule to get a .obj file from .obv file
#-------------------------------------------------------------------------------

.obv.obj:
   @echo $(GET_MSG) $@     $(ECHO_LOG)
   %echo $(GET_MSG) $@
   $(GET_CMD) $<($@)       $(MAKE_LOG)

#-------------------------------------------------------------------------------
# rule to get a .obk file from .obv file
#-------------------------------------------------------------------------------

.obv.obk:
   @echo $(GET_MSG) $@     $(ECHO_LOG)
   %echo $(GET_MSG) $@
   $(GET_CMD) $<($@)       $(MAKE_LOG)

%endif
#-------------------------- End of PVCS Checking -------------------------------
#-------------------------------------------------------------------------------
#  Create a .lob file from a .c file by executing PC-lint.  In addition to the
#  common lint input script we set the unit checkout flag and instruct lint to
#  generate a lint object module.  If the MOPTS 'x' flag is set, skip the 
#  actual lint.
#-------------------------------------------------------------------------------

.c.lob:
%if !%member (x, $[u, $(MOPTS)])
   @echo --- $(ECHO_LOG)
   .LIS_FILE $(NLM_NAME).lnt
   @echo $(LINT_MSG) $[f,"$()",$<,"$()"] $(ECHO_LOG)
   %echo $(LINT_MSG) $[f,"$()",$<,"$()"]
   $(LINT_CMD) < <
$[t,!,"\n",$(LINT_LIS)]
-u
-os($[f,$(LOB),$<,out])
-oo($[f,$(LOB),$<,lob])
$[f,$(SRC),$<,c]
< $(MAKE_LOG)
        del $[f,$(LOB),$<,out]
        %echo $(DONE_MSG)
        .LIS_FILE LIS_QQQ.TMP
%endif

#-------------------------------------------------------------------------------
#  Create a .lob file from a .mlc file by executing PC-lint.  In addition to 
#  the common lint input script we set the unit checkout flag and instruct lint
#  to generate a lint object module.  If the MOPTS 'x' flag is set, skip the
#  actual lint.
#-------------------------------------------------------------------------------

.mlc.lob:
%if !%member (x, $[u, $(MOPTS)])
   @echo --- $(ECHO_LOG)
        .LIS_FILE $(NLM_NAME).lnt
        %echo $(LINT_MSG) $[f,"$()",$<,"$()"]
        $(LINT_CMD) < <
$[t,!,"\n",$(LINT_LIS)]
-u
-os($[f,$(LOB),$<,out])
-oo($[f,$(LOB),$<,lob])
$[f,$(SRC),$<,mlc]
<
        del $[f,$(LOB),$<,out]
        %echo $(DONE_MSG)
        .LIS_FILE LIS_QQQ.TMP
%endif

################################################################################
#                                                                              #
#                              PRIMARY TARGETS                                 #
#                                                                              #
################################################################################
#
#  Generate the primary dependency.  This is a dummy dependency to execute IN
#  ORDER: a clean-up (if specified), an .Mdb file, a function prototype build 
#  (if $(FPD_NAME) is missing), an NLM build, and a project (or global) lint.
#-------------------------------------------------------------------------------

head : $(HEADDEP)

############################## NLM Dependencies ################################
#
#  NLM dependency.  Specifies $(NLM_NAME).Nlm depends on the list of all object
#  modules and the list of all import files.  NOTE THE USE OF []: this prevents
#  make from checking the file out from version control if it doesn't exist
#  just to get its timestamp.  It also causes the file to be deleted when the
#  make completes (if and only if make checked the file out).
#
################################################################################

$(MSG_NAME) : [$(MDB_LST)]
   %do make_msg

#$(MDB_NAME) :
#   %do make_mdb

$(NLM_NAME).Nlm : $(MSG_NAME) $(OBJ_LST) $(HLP_NAME) [$(IMP_LST) $(EXP_LST)]

#-------------------------------------------------------------------------------
#  If the MOPTS 'noLink' flag was specified, skip the actual link.
#-------------------------------------------------------------------------------

%if !%member (NoLink, $[u, $(MOPTS)])
   .KEEP_LIS
   @del $(OBJ)\$(NLM_NAME).lnk
   .LIS_FILE $(OBJ)\$(NLM_NAME).lnk
   @echo ---         $(ECHO_LOG)
   @echo $(LINK_MSG) $(ECHO_LOG)
   %echo $(LINK_MSG)
%if %defined (BC45)
   $(LINK_CMD) <@<
%else
   $(LINK_CMD) < <
%endif
$[t,!,"\n",$(LINK_LIS)]
< $(LINK_LOG)
   .NOKEEP_LIS
   %echo $(DONE_MSG)

   %if %defined (PRODVER)
      %echo $(PACK_MSG)
      @echo ---                                    $(ECHO_LOG)
      @echo $(PACK_MSG)                            $(ECHO_LOG)

      $(PACK_CMD) $(NLM)\$(NLM_NAME).Nlm $(NLM)\$(NLM_NAME).Nlm  $(ECHO_LOG)
   %endif
%endif

#-------------------------------------------------------------------------------
#  If any of the O, S, or R flags were specified, do the appropriate step 
#  (object list, source list, or cross ref).
#-------------------------------------------------------------------------------

%foreach CMDOPT in $[u, $(MOPTS)]
        %do $($(CMDOPT))
%endfor

#-------------------------------------------------------------------------------
#  Global lint dependency.  Specifies $(NLM_NAME).Nlm depends on the list of 
#  all lint object modules.
#-------------------------------------------------------------------------------

$(NLM_NAME).lob : $(LOB_LST)

%if !%member (x, $[u, $(MOPTS)])       #  If the MOPTS 'x' flag was specified, skip the actual lint.
      @echo --- $(ECHO_LOG)
      .LIS_FILE $(NLM_NAME).lnt
      @echo $(LINT_MSG) entire project $(ECHO_LOG)
      %echo $(LINT_MSG) entire project
      $(LINT_CMD) < <
$[t, !, "\n", $(LINT_LIS)]
-os($(LOB)\$(NLM_NAME).out)
-oo($(LOB)\$(NLM_NAME).lob)
$[s, "\n", $[f,$(LOB),$(LOB_LST),$()]]
<
      del $(LOB)\$(NLM_NAME).out
      @echo $(DONE_MSG)  $(ECHO_LOG)
      %echo $(DONE_MSG)
      .LIS_FILE LIS_QQQ.TMP
%endif

################################################################################
#                                                                              #
#                                 DUMMY TARGETS                                #
#                                                                              #
################################################################################
#
#  Dummy target to generate a single include file $(FPD_NAME) containing all
#  function prototypes and external data declarations.  $(FPD_NAME) is created
#  by executing lint against all sources and specifying the -od flag.
#
#  The dummy target depends on the list of all sources and includes to insure
#  all files are checked out from version control before beginning the lint.
#  NOTE:  Do NOT make $(FPD_NAME) the target for this dependency since that 
#  would cause this step to be executed EVERY time a source file is modified.
#  By using a dummy dependency, this step is only executed when $(FPD_NAME) is
#  missing.  NOTE THE USE OF []: this prevents make from checking the file
#  out from version control if it doesn't exist just to get its timestamp.  
#  It also causes the file to be deleted when the make completes (if and only
#  if make checked the file out).
#
#-------------------------------------------------------------------------------

makeprot : [$(CPP_LST) $(INC_LST) $(GINC_LST)]
   .KEEP_LIS
   .LIS_FILE $(OBJ)\$(NLM_NAME).lnt
   @echo --- $(ECHO_LOG)
   @echo $(LINT_MSG) all sources for function prototypes $(ECHO_LOG)
   %echo $(LINT_MSG) all sources for function prototypes
   $(LINT_CMD) < <
$[t,!,"\n",$(LINT_LIS)]
-zero
-os($(FPD)\$(NLM_NAME).out)
-od($(FPD)\$(FPD_NAME))
$[s, "\n", $[f,$(SRC),$(CPP_LST),]]
< 
   %if %exists ($(FPD)\$(FPD_NAME))
      %if !%member (fpdRes, $[u, $(MOPTS)])
         del $(FPD)\$(NLM_NAME).out
      %endif
   %endif
   %echo $(DONE_MSG)
   .LIS_FILE LIS_QQQ.TMP

#-------------------------------------------------------------------------------
#  Dummy target for generating the NLS ".MDB" message database file.  
#-------------------------------------------------------------------------------

make_mdb : $(MDB_NAME)

   -*$(BTRV_EXE)\btrieve /p:1536 /e

   %if !%exists ($(MDB)\$(MDB_NAME))
      @echo --- $(ENV_LOG)
      @echo Beginning build of message database, $(MDB_NAME). $(ENV_LOG)
      %echo Beginning build of message database, $(MDB_NAME).

      $(NLS_EXE)\msgmake $(MDB)\$(MDB_NAME) $(NLM_NAME).Nlm $(NLMVERSION) 4 1.0 $(ECHO_LOG)

   %elseif !%writable ($(MDB)\$(MDB_NAME))
         ~attrib -R $(MDB)\$(MDB_NAME)

   %endif

   %if %exists ($(ETC)\$(MSG_NAME))             
      %if !%writable ($(ETC)\$(MSG_NAME))
         ~attrib -R $(ETC)\$(MSG_NAME)
      %endif

      #-------------------------------------------------------------------------
      #  Anytime the ".MDB" file is rebuilt, we force a complete rebuild of 
      #  the ".MSG" file by deleting it.  This forces Make to extract the NLS 
      #  strings from the files in $(MDB_LST) before generating the MSG file.
      #-------------------------------------------------------------------------

      ~@del $(ETC)\$(MSG_NAME) >nul:
   %endif

   #----------------------------------------------------------------------------
   #  Anytime the .MDB file is rebuilt or a production build is underway, we 
   #  run msgLabel on the file to set the NLS encoded version string (the 
   #  string that will be placed in the header of the .MSG file) to reflect 
   #  the NLM version encoded in the header of the NLM.  
   #----------------------------------------------------------------------------

   $(NLS_EXE)\msgLabel $(MDB)\$(MDB_NAME) $(NLM_NAME).Nlm $(NLMVERSION) 4 1.0 $(ECHO_LOG)
 
   -*$(BTRV_EXE)\butil -stop

#-------------------------------------------------------------------------------
#  Dummy target for generating the NLS ".MSG" message database file.  
#-------------------------------------------------------------------------------

make_msg : [$(MDB_LST)]

   -*$(BTRV_EXE)\btrieve /p:1536 /e
   {
      %if %member ($?, $(MDB_LST))

         @echo --- $(ENV_LOG)
         
         %if !%writable ($?)
            ~attrib -R $?

            %if !%writable ($?)
               -*$(BTRV_EXE)\butil -stop
               @echo Unable to write to source message file, $?  $(ENV_LOG)
               %echo Unable to write to source message file, $?
               %exit 20
            %endif
         %endif

         @echo Extracting messages from source file, $? $(ENV_LOG)
         %echo Extracting messages from source file, $?

         #----------------------------------------------------------------------
         #  After extracting the NLS strings from the specified message file,
         #  we delete the associated ".OBJ" file, if any, to force Make to 
         #  recompile the OBJ file.  This is a necessary step since Make 
         #  appears to read the timestamp of the file only at the beginning of
         #  the Make process.  By deleting the OBJ file, Make will later 
         #  determine that the associated OBJ must be rebuilt.
         #
         #  During a production build, we don't delete the OBJ file so that 
         #  we can restart the build without having to check-out all the source
         #  and header files unecessarily.
         #----------------------------------------------------------------------
         
         %if %member ($?, $(NUMMSG_LST))
            $(NLS_EXE)\msgextr -m$(MDB)\$(MDB_NAME) -r -w -tNumMSG -s$? $(ENV_LOG)

            %if !%defined (PRODVER)
               ~@del $[f, $(OBJ), $[r,$?], obj] >nul:
            %endif

         %elseif %member ($?, $(MSG_LST))
            $(NLS_EXE)\msgextr -m$(MDB)\$(MDB_NAME) -r -w -tMSG -s$? $(ENV_LOG)

            %if !%defined (PRODVER)
               ~@del $[f, $(OBJ), $[r,$?], obj] >nul:
            %endif
         %endif
      %endif
   }

   %if %exists ($(ETC)\$(MSG_NAME))
      %if !%writable ($(ETC)\$(MSG_NAME))
         ~attrib -R $(ETC)\$(MSG_NAME)
      %endif
   %endif
 
   @echo --- $(ENV_LOG)
   @echo Exporting strings to message file, $(ETC)\$(MSG_NAME). $(ENV_LOG)
   %echo Exporting strings to message file, $(ETC)\$(MSG_NAME).

   -$(NLS_EXE)\msgexp $(MDB)\$(MDB_NAME) cstring nlm $(ETC)\$(MSG_NAME) $(ENV_LOG)

   -*$(BTRV_EXE)\butil -stop

#-------------------------------------------------------------------------------
#  Dummy dependency for cleaning up development directories.  All listing 
#  files, object files, map files and the primary executable file are deleted.
#-------------------------------------------------------------------------------

clean:
   del $(OBJ)\*.i
   del $(LOB)\*.lob
   del $(OBJ)\*.lst
   del $(SRC)\*.lst
   del $(INC)\*.lst
   del $(OBJ)\*.obj
   del $(LOB)\*.out
   del $(FPD)\$(FPD_NAME)
   del $(NLM)\$(NLM_NAME).Map
   del $(NLM)\$(NLM_NAME).Nlm
   del $(LIB)\$(NLM_NAME).Lib

#-------------------------------------------------------------------------------
#  Dummy target for generating object list files.  Insure that the current file
#  being processed (in the list of all files newer than the current NLM) is an
#  object file
#-------------------------------------------------------------------------------

objlst:
   {
      %if %member ($[f,"$()",$?,$()], $(OBJ_LST))
         $(OLST_MSG) $[f,"$()",$?,"$()"]
         $(OLST_CMD) /s=$[f,$(SRC),$?,c] /l=$[f,$(OBJ),$?,lst] $[f,$(OBJ),$?,obj]
         %echo $(DONE_MSG)
      %endif
   }

#-------------------------------------------------------------------------------
#  Dummy target for generating source list files.  Insure that the current file
#  being processed (in the list of all files newer than the current NLM) is an
#  object file
#-------------------------------------------------------------------------------

srclst:
   {
      %if %member ($[f,"$()",$?,$()], $(OBJ_LST))
         $(SLST_MSG) $[f,"$()",$?,"$()"]
         $(SLST_CMD) $[f,$(SRC),$?,c]
         %echo $(DONE_MSG)
      %endif
   }

#-------------------------------------------------------------------------------
#  Dummy target for generating cross reference files.  Insure that the current 
#  file being processed (in the list of all files newer than the current NLM) 
#  is an object file
#-------------------------------------------------------------------------------

xref:
   {
      %if %member($[f,"$()",$?,$()],$(OBJ_LST))
         $(XREF_MSG) $[f,"$()",$?,"$()"]
         $(XREF) $[f,$(SRC),$?,c]
         %echo $(DONE_MSG)
      %endif
   }
   $(XMRG_MSG)
   $(XMRG) $(SRC)\*.c_x
   %echo $(DONE_MSG)
   $(XLIST_MSG)
   $(XLIST)
   %echo $(DONE_MSG)

################################################################################
#                                                                              #
#                          OBJECT MODULE DEPENDENCIES                          #
#                                                                              #
################################################################################
#
#  Object module (and lint object module) dependencies.  Only header files
#  depencencies are specified, source file dependencies are covered by the
#  generalized rules.  NOTE THE USE OF []: this prevents MAKE from checking
#  the file out from version control if it doesn't exist just to get its
#  timestamp.  It also causes the file to be deleted when the make completes
#  (if and only if MAKE checked the file out).
#
#  This rules says ALL objects depend on the following list of header files.
#  Note that ALL the header files listed in $(INC_LST) and $(GINC_LST) will be
#  automatically included in the list of dependent header files "[]" in all
#  obj's listed below.  Therefore, it is ONLY necessary to keep the $(INC_LST)
#  and $(GINC_LST) lists up to date.  Note also that unless PRODVER has been 
#  specified on the command line, the objects specified in OBJ_LST will NOT be
#  dependent on changes made to ANY of the INC_LST, GINC_LST, or FPD_NAME 
#  files.
#
#-------------------------------------------------------------------------------

%if %defined (PVCSVER)

$(OBJ_LST) $(LOB_LST)   :  [$(INC_LST) $(GINC_LST) $(FPD_NAME)]

%endif

$(HLP_NAME)             :  []

################################################################################
#
#  If we get here, the lint to generate the function prototypes file failed.  
#  Abort the make, but execute the .DEINIT and .EPILOG macros.

$(FPD_NAME) :
   %echo Error: Unable to generate function prototypes file
   %exit 1

################################################################################
#                                                                              #
#                             RESERVED TARGETS                                 #
#                                                                              #
################################################################################
#
#  Here's the things that get done whether we need to make or not.
#-------------------------------------------------------------------------------

.PROLOG:
   castoff all

   %setenv VCSDIR    =           # Kill the user's macro so that PVCS uses only 
                                 # the paths that we define.  Make will restore
                                 # their VCSDIR macro when it exits.

   %if !%defined (PRODVER)

      @del $(LOG_FILE) >nul:     # When we're doing a CM_BLD build, the log 
                                 # files for all modules will be sent to a 
   %endif                        # single log file in the SRC directory.

   @echo . $(ENV_LOG)
   @echo .     ====================================== $(ENV_LOG)
   @echo .     ============     $(NLM_NAME)   ============ $(ENV_LOG)
   @echo .     ============              ============ $(ENV_LOG)
   @echo .     ============     start    ============ $(ENV_LOG)
   @echo .     ============              ============ $(ENV_LOG)
   @echo .     ====================================== $(ENV_LOG)
   @echo . $(ENV_LOG)

   #----------------------------------------------------------------------------
   #  If we're doing a production make, map a drive to the source volume and 
   #  create subdir's for objects, includes, and global includes.  NOTE: we 
   #  need to separate global includes from local includes to insure lint 
   #  correctly identifies global include files as library include files.
   #  
   #  Note that since you cannot invoke Make from one of the drives used in
   #  this makefile, we need to check $(CWD) to determine whether or not we
   #  can continue.
   #----------------------------------------------------------------------------

   %if "$[v,$(CWD)]:" != $[u,"c:"]           && \
       ("$[v,$(CWD)]:" == $[u,"$(GLB_DRV)"]  || \
        "$[v,$(CWD)]:" == $[u,"$(SRC_DRV)"]  || \
        "$[v,$(CWD)]:" == $[u,"$(CC_DRV)"]   || \
        "$[v,$(CWD)]:" == $[u,"$(SDK_DRV)"]  || \
        "$[v,$(CWD)]:" == $[u,"$(SEARCH_DRV)"])

      @echo $(NLM_NAME)-MAKE Error: Make cannot be invoked from the same drive as one                 $(ENV_LOG)
      @echo .                    used in this makefile.  Which means you can't use                 $(ENV_LOG)
      @echo .                    $(SRC_DRV), $(CC_DRV), $(SDK_DRV), $(GLB_DRV), or $(SEARCH_DRV).  $(ENV_LOG)
 
      %echo .
      %echo $(NLM_NAME)-MAKE Error: Make cannot be invoked from the same drive as one 
      %echo .                    used in this makefile.  Which means you can't use 
      %echo .                    $(SRC_DRV), $(CC_DRV), $(SDK_DRV), $(GLB_DRV), or $(SEARCH_DRV).

      %exit 20
 
   %else

      %if "$(SRC_DRV)" != "c:" && "$(SRC_DRV)" != "d:"
         :@map $(SRC_DRV) = $(SRC_MAP)
         :@map $(SRC_DRV) = $(SRC_MAP) $(ENV_LOG)
      %endif

      %if "$(CC_DRV)" != "c:" && "$(CC_DRV)" != "d:"
         :@map $(CC_DRV) = $(CC_MAP)
         :@map $(CC_DRV) = $(CC_MAP) $(ENV_LOG)
      %endif

      %if "$(SDK_DRV)" != "c:" && "$(SDK_DRV)" != "d:"
         :@map $(SDK_DRV) = $(SDK_MAP)
         :@map $(SDK_DRV) = $(SDK_MAP) $(ENV_LOG)
      %endif

      %if "$(GLB_DRV)" != "c:" && "$(GLB_DRV)" != "d:"
         :@map $(GLB_DRV) = $(GLB_MAP)
         :@map $(GLB_DRV) = $(GLB_MAP) $(ENV_LOG)
      %endif

      %if "$(SEARCH_DRV)" != "c:" && "$(SEARCH_DRV)" != "d:"
         :@map root $(SEARCH_DRV) = $(NLS_EXE)
         :@map root $(SEARCH_DRV) = $(NLS_EXE) $(ENV_LOG)
      %else
         cd $(SDK_PATH)\novbin
      %endif
   %endif

#-------------------------------------------------------------------------------
#  Initialization macro - print banner, change the current directory to the
#  miscellaneous files directory and delete any leftover compiler error files.
#-------------------------------------------------------------------------------

.INIT:
   @echo --- $(ENV_LOG)

   #------------------------------------------------------------------------
   #  Save the current DOS Path so that is can be restored on exit.  We need
   #  to append the NovBin directory to the current path.
   #------------------------------------------------------------------------

   %set savePath  =  $(PATH)
   %setenv PATH   =  $(SEARCH_DRV);$(CC_PATH)\bin;$(CC_PATH)\binb;$(PATH);

   %if %defined (PRODVER)
      @echo Starting production make of $(NLM_NAME).Nlm, VCS label $(PVCSVER) $(ENV_LOG)
      @echo Encoded NLM Link Version $(NLMVERSION) $(ENV_LOG)

      %echo Starting production make of $(NLM_NAME).Nlm, VCS label $(PVCSVER)
      %echo Encoded NLM Link Version $(NLMVERSION)

   %else
      @echo Starting engineering make of $(NLM_NAME).Nlm, VCS label $(PVCSVER) $(ENV_LOG)
      @echo Encoded NLM Link Version $(NLMVERSION) $(ENV_LOG)

      %echo Starting engineering make of $(NLM_NAME).Nlm, VCS label $(PVCSVER)
      %echo Encoded NLM Link Version $(NLMVERSION)
   %endif

   @echo Target NetWare OS is $(NW_VER) $(ENV_LOG)
   %echo Target NetWare OS is $(NW_VER)

   @echo --- $(ENV_LOG)

   %setenv INC386 =  $(INC); $(NOVH); $(WCC_INC); $(FPD);
   %setenv WCG386 =  $(CC_PATH)\bin\386wcgl.exe
   %setenv WCC386 =  $(WCC_FLAGS)

   @printenv PATH       $(ENV_LOG)
   @printenv INC386     $(ENV_LOG)
   @printenv WCG386     $(ENV_LOG)
   @printenv WCC386     $(ENV_LOG)

   @echo --- $(ENV_LOG)

   @echo SRC_VCS     =  $(SRC_VCS)     $(ENV_LOG)
   @echo GLB_VCS     =  $(GLB_VCS)     $(ENV_LOG)

   @echo --- $(ENV_LOG)

   @echo PVCSVER     =  $(PVCSVER)     $(ENV_LOG)
   @echo NLMVERSION  =  $(NLMVERSION)  $(ENV_LOG)
   @echo M_ARGS      =  $(M_ARGS)      $(ENV_LOG)
   @echo CC          =  $(CC_PATH)\bin\wcc386p $(DFLAGS) $(CFLAGS) $(ENV_LOG)
   @echo CC_VER      =  $(CC_VER)      $(ENV_LOG)
   @echo CFLAGS      =  $(CFLAGS)      $(ENV_LOG)
   @echo DFLAGS      =  $(DFLAGS)      $(ENV_LOG)
   @echo ASM_FLAGS   =  $(ASM_FLAGS)   $(ENV_LOG)
   @echo NIOS_INC    =  $(NIOS_INC)    $(ENV_LOG)
   @echo NOVI        =  $(NOVI)        $(ENV_LOG)
   @echo NOVH        =  $(NOVH)        $(ENV_LOG)   
   @echo OS_INC      =  $(OS_INC)      $(ENV_LOG)   
   @echo NW_VER      =  $(NW_VER)      $(ENV_LOG)

   @echo SDK_PATH    =  $(SDK_PATH)    $(ENV_LOG)
   @echo NLS_EXE     =  $(NLS_EXE)     $(ENV_LOG)

   @echo --- $(ENV_LOG)

   @echo CWD         =  $(CWD)         $(ENV_LOG)
   @echo LOG_DIR     =  $(LOG_DIR)     $(ENV_LOG)

   @echo --- $(ENV_LOG)

   %if %defined (MEM)
      %setenv WCGMEMORY = $(MEM)
      @printenv WCGMEMORY $(ENV_LOG)
   %else
      %setenv WCGMEMORY = ?
   %endif

   #----------------------------------------------------------------------------
   # Create directories if necessary.  This is necessary when creating a new 
   # environment from the VCS subdirectory.
   #----------------------------------------------------------------------------

   %if !%defined (PRODVER)

      %if ("$(BAT)" != ".")
         %if (!%dir ($(BAT)))
            @md $(BAT)
         %endif
      %endif

      %if ("$(DOC)" != ".")
         %if (!%dir ($(DOC)))
            @md $(DOC)
         %endif
      %endif

      %if ("$(ETC)" != ".")
         %if (!%dir ($(ETC)))
            @md $(ETC)
         %endif
      %endif

      %if ("$(INC)" != ".")
         %if (!%dir ($(INC)))
            @md $(INC)
         %endif
      %endif

      %if ("$(OBJ)" != ".")
         %if (!%dir ($(OBJ)))
            @md $(OBJ)
         %endif
      %endif

      %if ("$(PROD)" != ".")
         %if (!%dir ($(PROD)))
            @md $(PROD)
         %endif
      %endif

      %if ("$(SRC)" != ".")
         %if (!%dir ($(SRC)))
            @md $(SRC)
         %endif
      %endif

      %if ("$(VCS)" != ".")
         %if (!%dir ($(VCS)))
            @md $(VCS)
         %endif
      %endif

   %else
      %if ("$(OBJ)" != ".")                     # we'll need the object 
         %if (!%dir ($(OBJ)))                   # subdirectory for production 
            @md $(OBJ)                          # builds
         %endif
      %endif
   %endif                                       #  %if !defined (PRODVER)

   #----------------------------------------------------------------------------
   # Do some preliminary cleanup.
   #----------------------------------------------------------------------------

   cd $(LOB)
   %if "$[w, *.out]" != "$()"
      del *.out
   %endif

   cd $(ERR)
   %if !%member (x, $[u, $(MOPTS)]) && "$[w,*.err]" != "$()"
      del *.err
   %endif

   cd $(CWD)         # move back to the directory where "make" was started from.

#-------------------------------------------------------------------------------
#  De-initialization macro - executed only if we did something.
#-------------------------------------------------------------------------------

.DEINIT:

   %setenv PATH   =  $(savePath)

   %if !%defined (MAKE_ABORT)
      @echo . $(ENV_LOG)
      @echo .     =================================================== $(ENV_LOG)
      @echo .     ============          $(NLM_NAME)           ============ $(ENV_LOG)
      @echo .     ============                           ============ $(ENV_LOG)
      @echo .     ============   successful completion   ============ $(ENV_LOG)
      @echo .     ============                           ============ $(ENV_LOG)
      @echo .     =================================================== $(ENV_LOG)
      @echo . $(ENV_LOG)
   %endif

   %if %defined (PRODVER)
#     del $(OBJ)\*.obj
#     del $(LOB)\*.lob
#     del $(FPD)\$(FPD_NAME)
#     map del $(SRC_DRV)
#     map del $(SDK_DRV)
#     map del $(CC_DRV)
#     map del $(GLB_DRV)
   %endif
   cd $(CWD)

#-------------------------------------------------------------------------------
#  Default Error/Exit Rule for when PVCS doesn't know how to "make" a file.
#-------------------------------------------------------------------------------

.DEFAULT:

   #----------------------------------------------------------------------------
   #  Whenever Make can't find either an explicit or a generalized rule as to
   #  how it should make a "target", Make checks the generalized rule specified
   #  by the .DEFAULT reserved target.  However, since this make file uses 
   #  dummy targets to build things like the .MDB file, and the .FPD file, and
   #  even the .Nlm, we need to be able to distinguish between dummy targets
   #  and real targets, that way we can determine when we really have an error 
   #  and need to abort the make process.   Fortunately, all real targets being
   #  produced by this make process all have file extensions and we'll use that
   #  fact here to determine whether we need to abort the make process.
   #----------------------------------------------------------------------------

   %if "_$[e,$@]" != "_"            # When "_" == "_" --> it was a dummy target

      @echo Aborting the build process for $(NLM_NAME).Nlm. $(ENV_LOG)
      @echo "Make" doesn't know how to create/find "$@".    $(ENV_LOG)

      %echo Aborting the build process for $(NLM_NAME).Nlm.
      %echo "Make" doesn't know how to create/find "$@".

      @echo . $(ENV_LOG)
      @echo .     =================================================== $(ENV_LOG)
      @echo .     ============          $(NLM_NAME)           ============ $(ENV_LOG)
      @echo .     ============                           ============ $(ENV_LOG)
      @echo .     ============     *** Error Exit ***    ============ $(ENV_LOG)
      @echo .     ============                           ============ $(ENV_LOG)
      @echo .     =================================================== $(ENV_LOG)
      @echo . $(ENV_LOG)

      %set  MAKE_ABORT  =  1
      %exit 20

   %endif

#-------------------------------------------------------------------------------
#  Error/Exit macro - executed on error.
#-------------------------------------------------------------------------------

.ERROR:

   @echo Aborting the build process for $(NLM_NAME).Nlm. $(ENV_LOG)
   %echo Aborting the build process for $(NLM_NAME).Nlm.

   @echo . $(ENV_LOG)
   @echo .     =================================================== $(ENV_LOG)
   @echo .     ============          $(NLM_NAME)           ============ $(ENV_LOG)
   @echo .     ============                           ============ $(ENV_LOG)
   @echo .     ============     *** Error Exit ***    ============ $(ENV_LOG)
   @echo .     ============                           ============ $(ENV_LOG)
   @echo .     =================================================== $(ENV_LOG)
   @echo . $(ENV_LOG)

   %set  MAKE_ABORT  =  1
   %exit 20

#-------------------------------------------------------------------------------
