/*******************************************************************************
**
** (c) Copyright 1996 Novell, Inc.  All rights reserved.
**
**      File:  xxDecl.h : NetWare HTTP CGI Private Definition File.
**
**  $Logfile:   J:/webserv/prodtree/disk1/web/samples/cgiparse/inc/vcs/xxdecl.h_v  $
** $Revision:   1.0  $
**     $Date:   10 Apr 1996 11:57:22  $
**   $Author:   PTANG  $
**
**  Comments:  This file contains the internal definitions for use by this
**             module only.  It SHOULD NOT contain any information that may 
**             be required by a client module in order to interface with 
**             this one.
**                
*******************************************************************************/
#ifndef _xxDecl_Included             // Make sure this file has not already 
#define _xxDecl_Included             // been included.  If not, define it.
/******************************************************************************/

#include "NwTypes.h"

/******************************************************************************/
/****************************** API Return Codes ******************************/
/******************************************************************************/
// Note that the message base address of 0x00830000 is already assigned to the
// NetWare Web Server, and therefore, you will need to contact the Web Server
// team in order to have your own number assigned.  Otherwise, the CsSysMsg
// NLM will reject the registration request since 0x00830000 is already being
// used by the Web Server.

#define  xxC_SysMsgBase                   0x00870000  // base API return code number for this module

#define  xxE_ThisIsATestMessage           0x00870001  // "This is a test message."


/******************************************************************************/
/******************* Private System Message Definitions ***********************/
//
// The following system messages are intended to be output only by this module
// of the CGI Extension.  They are considered private messages because they may
// contain embedded format characters that must be translated during output.
//
// In order not to conflict with the publicly exported API return codes,
// "xxE_...", as new definitions are added, they should start will 0xFF
// and be decremented towards zero.
/******************************************************************************/

#define xxP_ThisIsAPrivateTestMessage     0x008700FF  // "This is a Private message of the %s module."

/******************************************************************************/
/********************* Extension Module Status Flags **************************/
// The global status flag (xx_Status) is currently used only to indicate when
// an unload request has been received from the HTTP Server.  The extension
// processor NLM may want to check this flag at various points of execution to
// determine whether a premature exit could or should be taken.  Other than
// that, the remaining bits are open for your definition.

#define  xxC_UnloadRequested              0x00000001  // Set when UnloadHandler is called

/******************************************************************************/
#endif                                                // _xxDecl_Included
/******************************************************************************/
