/*******************************************************************************
**
**  (c) Copyright 1993 - 1996 Novell, Inc.  All rights reserved.
**
**       File:   csSysMsg.h -- CeLib: Communications Executive Library.
**
**   $Logfile:   J:/WEBSERV/PRODTREE/DISK1/WEB/SAMPLES/CGIPARSE/INC/VCS/CSSYSMSG.H_V  $
**  $Revision:   1.1  $
**      $Date:   30 Apr 1996 10:44:26  $
**    $Author:   PTANG  $
**
**   Comments:   This file contains the structure definitions and API
**               prototypes necessary to interface with the Communications
**               Executive Library Facility. 
** 
**     Exported API Functions Contained in this File:
**                   
**       CeBtrvCheckDir          // Creates and Validates the file path
**       CeBtrvClose             // Closes the specified file
**       CeBtrvClientIdFree      // Deinitialize the Btrieve Client ID Structure & perform a Btrieve Reset
**       CeBtrvClientIdInit      // Allocates and initializes a unique client ID structure
**       CeBtrvCreate            // Creates the specified file
**       CeBtrvDelete            // Deletes the current record
**       CeBtrvGetDirect         // Get record based on physical position
**       CeBtrvGetEqual          // Get record based on a key value
**       CeBtrvGetFirst          // Get the first record in the specified key index
**       CeBtrvGetGrtrOrEqual    // Get record based on a key value
**       CeBtrvGetNext           // Get the next record based on the current key index
**       CeBtrvGetPosition       // Return the current position information
**       CeBtrvID                // Simple interface to Btrieve w/SysMsg return values
**       CeBtrvInsert            // Insert a record 
**       CeBtrvOpen              // Open the specified file
**       CeBtrvRead              // Read first/next record from the specified file
**       CeBtrvStat              // Returns number of records and the characteristics of the file
**       CeBtrvStepFirst         // Retrieve the phyical first record in the file (no index path used)
**       CeBtrvStepNext          // Retrieves the record pointed to by the physical next position (no index path used)
**       CeBtrvTransAbort        // Abort transaction processing on a set of files
**       CeBtrvTransBegin        // Begin transaction processing on a set of files
**       CeBtrvTransBeginCC      // Begin concurrent transaction processing on a set of files
**       CeBtrvTransEnd          // End transaction processing on a set of files
**       CeBtrvUpdate            // Update the specified record
** 
**       CeDbgDeInit             // Deinitialize the current debug session.
**       CeDbgFile               // Format and output format string/variable parms to wrap file.
**       CeDbgFileVA             // Format and output the client string to the log file w/va_args ptr
**       CeDbgFlush              // Refresh the associated debug session wrap file
**       CeDbgFmtHex             // Format and output binary data with Hex/ASCII representation.
**       CeDbgFmtMBlk            // Format and output a Streams mblk_t structure. 
**       CeDbgFmtStrBuf          // Format and output a Streams strbuf structure.
**       CeDbgInit               // Initialize a debug session for the client.
**       CeDbgLevel              // Returns the client's current setting of the debug level variable.
**       CeDbgOptions            // Sets/Returns the user "options" specified at start of session
**       CeDbgScrn               // Format and output format string/variable parms to screen.
**       CeDbgScrnVA             // Format and output the client string to the debug screen w/va_args ptr
**       CeDbgWrite              // Output the contents of a specified buffer.
**
**       Older CeQue_t Routines (not SMP semaphore aware)
**
**          CeQueGetFirst        // Returns the queue element at the front of the queue
**          CeQueInfo            // Returns the number of elements on the queue
**          CeQueInit            // Initializes the queue head structure
**          CeQueInsertAfter     // Insert a queue element in the queue
**          CeQueInsertBefore    // Insert a queue element in the queue
**          CeQueJoin            // Appends queTwo to the end of queOne
**          CeQuePutFirst        // Inserts a queue element at the front of the queue
**          CeQuePutLast         // Inserts a queue element at the end of the queue
**          CeQueRemove          // Removes a specified element from the queue
**          CeQueSearch          // Searches for a specific queue element
**          CeQueSeparate        // Splits a linked list into two lists.
**               
**       Newer CmQue_t Routines (are SMP semaphore aware)
**  
**          CmQueDeInit          // Deallocates the SMP semaphore 
**          CmQueGetFirst        // Removes and returns the first queue element
**          CmQueInit            // Allocates the SMP semaphore and initializes the queue head structure as empty
**          CmQueInsertAfter     // Inserts an element after the specified element
**          CmQueInsertBefore    // Inserts an element before the specified element
**          CmQueJoin            // Appends queTwo to the end of queOne.  Only queOne is locked.
**          CmQueLock            // Lock the specified queue head
**          CmQueLockTry         // Try to lock the specified queue head
**          CmQuePutFirst        // Inserts an element at the front of the queue
**          CmQuePutLast         // Inserts an element at the end of the queue
**          CmQueRemove          // Removes the specified element from the queue
**          CmQueSearch          // Provides general queue search functionality
**          CmQueSeparate        // Splits a linked list into two lists.  Only the first queue is locked.
**          CmQueUnlock          // Unlock the specified queue head
**
**       CeMutexAlloc            // Allocate & initialize the specified semaphore
**       CeMutexDestroy          // Free & deinitialize the specified semaphore
**       CeMutexLock             // Lock the specified semaphore
**       CeMutexTryLock          // Lock the specified semaphore, or return immediately
**       CeMutexUnlock           // Unlock the specified semaphore
**  
**       CeWrapClose             // Closes the specified wrap file
**       CeWrapFlush             // Refresh the specified wrap file
**       CeWrapFlushAll          // Refresh all managed wrapped files
**       CeWrapOpen              // Opens the specified wrap file
**       CeWrapWrite             // Outputs data to the pseudo wrap file (sub-files)
**
**       CSSM_DisplayNlsMsg      // Displays unregistered messages in standard format
**       CSSM_DisplayNlsMsgVA    // Displays unregistered messages in standard format w/ Var Arg Ptr
**       CSSM_DisplaySysMsg      // Displays registered messages in standard format
**       CSSM_DisplaySysMsgVA    // Displays registered messages in standard format w/ Var Arg Ptr
**       CSSM_DisplayUserMsg     // Displays user defined messages in standard format (user specifies all input)
**       CSSM_DisplayUserMsgVA   // Displays user defined messages in standard format w/ Var Arg Ptr
**       CSSM_GetSysMsg          // Returns text and info for a registered message
**       CSSM_Register           // Registers a client's System Messages
**       CSSM_ReturnAuxMessageInformation // Returns enabled NLS Message Table and Help File.
**       
**    Miscellaneous Functions contained in this file:
**               
**       CeDelimiter             // Check character against a list of delimiting characters 
**       CeFileBackup            // Creates a backup file with a file extension of ".BAK"
**       CeFileClose             // Closes the specified file
**       CeFileOpen              // Opens the file specified 
**       CeFmtByteArray          // Formats a byte array into its ASCII representation
**       CeFmtDate               // Formats the current date and time, i.e., "05/01/94  23:25:43"
**       CeFree                  // Free dynamic memory and clear caller's pointer
**       CeGetServerVer          // Returns the current version level of the running Server
**       CeLibVers               // Returns the current revision level of the CsSysMsg Library
**       CeMalloc                // Allocate & clear dynamic memory (non-blocking)
**       CeMallocB               // Allocate & clear dynamic memory (may block)
**       CeMemFill               // Back fills memory with a specified string
**       CeRealloc               // Reallocate dynamic memory (non-blocking)
**       CeReallocB              // Reallocate dynamic memory (may block)
**       CeSetFileName           // Set cononical form of path & file name
**       CeSetNlmID              // set the current OS NLM context as specified
**       CeSetThreadGroupID      // sets the current OS thread group ID as specified
**       CeSetThreadName         // Append a mnemonic to the thread name
**       CeSkipToken             // Advance input ptr to the next white space character
**       CeSkipWhite             // Advance input ptr to the next non-white space character
**       CeStrBufMalloc          // Alloc the streams strbuf & strbuf->buf structs (non-blocking)
**       CeStrBufMallocB         // Alloc the streams strbuf & strbuf->buf structs (may block)
**       CeStrBufFree            // Free the streams strbuf & strbuf->buf structs
**       CeValidatePtr           // Verify the pointer is not NULL and does address valid memory
**
*******************************************************************************/
#ifndef _CSSYSMSG_INCLUDED             // Make sure this file has not already 
#define _CSSYSMSG_INCLUDED             // been included.  If not, define it.
/******************************************************************************/

#include <nwTypes.h>
#include <stdArg.h>
#include <stdDef.h>

#define  SUCCESS     0
#define  NULL        0

/******************************************************************************/
/************************* CeBtrv Structure Definitions ***********************/
/******************************************************************************/

typedef BYTE bPosBlk_t [128];

/*******************************************************************************
 **  Structure   : Btrieve File specification.
 **  Description : Used to define the file being created.
 ******************************************************************************/

typedef struct bFileSpec_t {
   WORD     recordLen;              // File record length
   WORD     pageSize;               // File page size
   WORD     keyCount;               // Number of keys per record
   LONG     reserved1;     
   WORD     flags;                  // File flags
   WORD     reserved2;        
   WORD     allocation;             // File allocation

} bFileSpec_t;

/*******************************************************************************
 ** Structure   : Btrieve Key specification.
 ** Description : Used with bFileSpec_t to define a file being created.
 ******************************************************************************/

typedef struct bKeySpec_t {
   WORD     position;               // Key position in record (one-based)
   WORD     len;                    // Key length
   WORD     flags;                  // Key flags
   LONG     reserved1;  
   BYTE     extType;                // Extended key type
   BYTE     nullValue;              // Reserved
   LONG     reserved2;
} bKeySpec_t;

/*******************************************************************************
 ** Structure   : Btrieve Create Specification.
 ** Description : passed to btrvCreate() Api.
 ******************************************************************************/ 

typedef struct bCreateSpec_t {
   bFileSpec_t    fileSpec;      // Defines new file information
   bKeySpec_t     keySpec  [1];  // Defines each key of the new file.
} bCreateSpec_t;

typedef struct bClientId_t {
   LONG     networkNumber;
   BYTE     networkNode    [6];
   BYTE     socketNumber   [2];
   BYTE     uniqueId1      [2];
   BYTE     uniqueId2      [2];
} bClientId_t;

/******************************************************************************/
/************************** CeBtrv Constant Definitions  **********************/
/******************************************************************************/

#define  CeBtrv_AccessNormal        1        // CeBtrvOpen() access definition
#define  CeBtrv_AccessReadonly      2        // CeBtrvOpen() access definition
#define  CeBtrv_AccessExclusive     3        // CeBtrvOpen() access definition

#define  CeBtrv_MaxKeyLen           512

/******************************************************************************/
/******************** CeBtrv API SysMsg Return Error Codes ********************/
/******************************************************************************/

#define  CeBtrv_SysMsgBase          0x00020000  // base number for Btrieve System Messages

#define  CeBtrvE_InvalidOperation   0x00020001  // The operation parameter is invalid.
#define  CeBtrvE_IOError            0x00020002  // Btrieve encountered an error while reading from or writing to the disk.  One of the following has occurred:  1) The file is damaged and must be recreated, 2) there is not enough sace to append a new page to the datafile, or 3) Client-based Btrieve attempted to write to a Btrieve file flagged sharable while Server-based Btrieve had the file open.
#define  CeBtrvE_FileNotOpen        0x00020003  // The file is not open.
#define  CeBtrvE_KeyValueNotFound   0x00020004  // Btrieve cannot find the key value.
#define  CeBtrvE_DupKeyValue        0x00020005  // The record has a key field containing a duplicate key value.
#define  CeBtrvE_InvalidKeyNumber   0x00020006  // The key number parameter is invalid.
#define  CeBtrvE_DiffKeyNumber      0x00020007  // The key number has changed.
#define  CeBtrvE_InvalidPosition    0x00020008  // The current positioning is invalid.
#define  CeBtrvE_EOF                0x00020009  // The operation encountered an end-of-file condition.
#define  CeBtrvE_ModifiableKeyErr   0x0002000a  // The key field is not modifiable.
#define  CeBtrvE_InvalidFileName    0x0002000b  // The specified file name is invalid.
#define  CeBtrvE_FileNotFound       0x0002000c  // Btrieve cannot find the specified file.
#define  CeBtrvE_ExtFileError       0x0002000d  // Extended file error.
#define  CeBtrvE_PreImageOpenError  0x0002000e  // Btrieve cannot create or open the pre-image file.
#define  CeBtrvE_PreImageIOError    0x0002000f  // Btrieve encountered an I/O error during pre-imaging.
#define  CeBtrvE_ExpansionError     0x00020010  // Btrieve encountered an expansion error.
#define  CeBtrvE_CloseError         0x00020011  // Btrieve encountered a close error.
#define  CeBtrvE_DiskFull           0x00020012  // The disk is full.
#define  CeBtrvE_Unrecoverable      0x00020013  // The application encountered an unrecoverable error.
#define  CeBtrvE_Inactive           0x00020014  // The Record Manager or Requester is inactive.
#define  CeBtrvE_KeyBufShort        0x00020015  // The key buffer parameter is too short.
#define  CeBtrvE_DataBufferLen      0x00020016  // The data buffer parameter is too short.
#define  CeBtrvE_PosBlkLen          0x00020017  // The position block parameter is not 128 bytes long.
#define  CeBtrvE_PageSize           0x00020018  // The page size or data buffer size is invalid.
#define  CeBtrvE_CreateIOError      0x00020019  // Btrieve cannot create the specified file.
#define  CeBtrvE_KeyCount           0x0002001a  // The number of keys specified is invalid.
#define  CeBtrvE_KeyPosition        0x0002001b  // The key position is invalid.
#define  CeBtrvE_RecordLength       0x0002001c  // The record length is invalid.
#define  CeBtrvE_InvalidKeyLength   0x0002001d  // The key length is invalid.
#define  CeBtrvE_NotBtrvFile        0x0002001e  // The file specified is not a Btrieve file.
#define  CeBtrvE_AlreadyExtended    0x0002001f  // The file is already extended.
#define  CeBtrvE_ExtendIOError      0x00020020  // The file cannot be extended.
#define  CeBtrvE_Unused_33          0x00020021  // Unused.
#define  CeBtrvE_InvalidExtName     0x00020022  // The specified extension name is invalid.
#define  CeBtrvE_DirectoryError     0x00020023  // Btrieve encountered a directory error.
#define  CeBtrvE_TransactionError   0x00020024  // Btrieve encountered a transaction error.
#define  CeBtrvE_TransIsActive      0x00020025  // Another transaction is active.
#define  CeBtrvE_TransControlError  0x00020026  // Btrieve encountered a transaction control file I/O error.
#define  CeBtrvE_TransEndError      0x00020027  // A Begin Transaction operation must precede an End/Abort Transaction operation.
#define  CeBtrvE_TransMax           0x00020028  // The file access request exceeds the maximum number of files allowed.
#define  CeBtrvE_OpNotAllowed       0x00020029  // Btrieve does not allow the attempted operation.
#define  CeBtrvE_AcceleratedAccess  0x0002002a  // A file previously open in Accelerated mode was not closed.
#define  CeBtrvE_InvalidRecordAddr  0x0002002b  // The specified record address is invalid.
#define  CeBtrvE_NullKey            0x0002002c  // The specified key path is invalid.
#define  CeBtrvE_KeyFlags           0x0002002d  // The specified key flags are invalid.
#define  CeBtrvE_AccessDenied       0x0002002e  // Access to the requested file is denied.
#define  CeBtrvE_MaxOpen            0x0002002f  // The number of files opened exceeds the maximum allowed.
#define  CeBtrvE_AlternateSeq       0x00020030  // The alternate collating sequence definition is invalid.
#define  CeBtrvE_KeyType            0x00020031  // The extended key type is invalid.
#define  CeBtrvE_OwnerSet           0x00020032  // The file owner is already set.
#define  CeBtrvE_InvalidOwner       0x00020033  // The owner name is invalid.
#define  CeBtrvE_CacheError         0x00020034  // Btrieve encountered an error writing to cache.
#define  CeBtrvE_Interface          0x00020035  // The language interface version is invalid.
#define  CeBtrvE_VariablePage       0x00020036  // The Variable-length portion of the record is corrupt.  Use BUTIL -RECOVER to recover as much data as posible.
#define  CeBtrvE_AutoIncrement      0x00020037  // The application specified an invalid attribute for an autoincrement key.
#define  CeBtrvE_IncompleteIndex    0x00020038  // An index is incomplete.
#define  CeBtrvE_Unused_57          0x00020039  // Unused.
#define  CeBtrvE_CompressShort      0x0002003a  // The compression buffer length is too short.
#define  CeBtrvE_FileExists         0x0002003b  // The specified file already exists.
#define  CeBtrvE_RejectCntHit       0x0002003c  // The specified reject count has been reached.
#define  CeBtrvE_WorkSpace          0x0002003d  // The work space is too small.
#define  CeBtrvE_Descriptor         0x0002003e  // The descriptor is incorrect.
#define  CeBtrvE_ExtendedInsert     0x0002003f  // The data buffer parameter specified on an Insert Extended operation is invalid.
#define  CeBtrvE_FilterLimitHit     0x00020040  // The filter limit has been reached.
#define  CeBtrvE_FieldOffset        0x00020041  // The field offset is incorrect.
#define  CeBtrvE_OpenDatabaseMax    0x00020042  // The maximum number of open databases has been exceeded.
#define  CeBtrvE_SqlOpenError       0x00020043  // Btrieve cannot open the SQL Data dictionaries.
#define  CeBtrvE_RiDelCascadeErr    0x00020044  // Btrieve cannot perform the RI Delete Cascade operation.
#define  CeBtrvE_DelCascadeCorrupt  0x00020045  // The Delete operation cascades to a record in a file that is damaged.
#define  CeBtrvE_Unused_70          0x00020046  // Unused.
#define  CeBtrvE_RiDefViolation     0x00020047  // There is a voilation of the RI definitions.
#define  CeBtrvE_RiRefFileErr       0x00020048  // Btrieve cannot open the RI referenced file.
#define  CeBtrvE_RiDefOutOfSync     0x00020049  // The RI definition is out of sync.
#define  CeBtrvE_AutoTransAbort     0x0002004a  // Btrieve aborted the transaction.
#define  CeBtrvE_RouteListShort     0x0002004b  // Server routing list is too small.
#define  CeBtrvE_RefFileConflict    0x0002004c  // There is a conflict on the referenced file.
#define  CeBtrvE_Wait               0x0002004d  // The application encountered a wait error.
#define  CeBtrvE_DeadLockDetected   0x0002004e  // Btrieve detected a deadlock condition.
#define  CeBtrvE_Programming        0x0002004f  // A programming error occurred.
#define  CeBtrvE_Conflict           0x00020050  // The application encountered a record-level conflict.
#define  CeBtrvE_Lock               0x00020051  // The application encountered a lock error.
#define  CeBtrvE_LostPosition       0x00020052  // The application lost positioning.
#define  CeBtrvE_OutsideTrans       0x00020053  // The application attempted to change a record that was read outside a transaction.
#define  CeBtrvE_RecordLocked       0x00020054  // The record is locked.
#define  CeBtrvE_FileLocked         0x00020055  // The file is locked.
#define  CeBtrvE_FileTableFull      0x00020056  // The file table is full.
#define  CeBtrvE_HandleTableFull    0x00020057  // The handle table is full.
#define  CeBtrvE_ModeError          0x00020058  // The application encountered an incompatible mode error.
#define  CeBtrvE_Unused_89          0x00020059  // Unused.
#define  CeBtrvE_RedirTblFull       0x0002005a  // The redirected device table is full.
#define  CeBtrvE_ServerError        0x0002005b  // The application encountered a Server error.
#define  CeBtrvE_TransTblFull       0x0002005c  // The transaction table is full.
#define  CeBtrvE_LockType           0x0002005d  // The record lock types are incompatible.
#define  CeBtrvE_Permission         0x0002005e  // The application encountered a permission error.
#define  CeBtrvE_SessionInvalid     0x0002005f  // The session no longer valid.
#define  CeBtrvE_Communications     0x00020060  // A communications environment error occurred.
#define  CeBtrvE_DatamsgLen         0x00020061  // The communications buffer is too small.
#define  CeBtrvE_InternalTrans      0x00020062  // Btrieve detected and internal transaction error.
#define  CeBtrvE_RunTimeSrvAccess   0x00020063  // The requester cannot access the NetWare Runtime server.
#define  CeBtrvE_NoCacheMem         0x00020064  // No cache buffers are available.
#define  CeBtrvE_NoOSMemory         0x00020065  // Insufficient operating system memory is available.
#define  CeBtrvE_NoStackMem         0x00020066  // Insufficient stack space is available. 
#define  CeBtrvE_ChunkOffset        0x00020067  // The chunk offset is too big.
#define  CeBtrvE_LocaleInfo         0x00020068  // The locale information could not be found.
#define  CeBtrvE_CreateVAT          0x00020069  // The file cannot be created with Variable-tail Allocation Table (VATs).
#define  CeBtrvE_ChunkNextErr       0x0002006a  // The operation cannot get the next chunk.
#define  CeBtrvE_ChunkGetErr        0x0002006b  // Chunk updates/retrievals cannot be performed on the file.

//-------------------------------  N O T E -------------------------------------
// There are a number of Btrieve error codes in the range 1000 - 1099 and
// 2000 - 2099 for the Btrieve versions running under OS/2, DOS, Windows,
// the Btrieve Requesters that are not listed here.  If we/they ever implement
// a workstation interface to the SysMsg Library, we'll need to add/define
// all the Btrieve errors here.
//------------------------------------------------------------------------------

#define  CeBtrvE_InvalidPath        0x000200c8  // Invalid directory.
#define  CeBtrvE_CannotMkDir        0x000200c9  // mkdir for dir returned -1.
#define  CeBtrvE_InvalidHandle      0x000200ca  // Invalid handle.
#define  CeBtrvE_InvalidParm        0x000200cb  // Invalid parmameter.
#define  CeBtrvE_MaxClientId        0x000200cc  // Unable to initialize another Btreive Client ID structure.

/******************************************************************************/
/******************** Exported CeBtrv Function Prototypes *********************/
/******************************************************************************/

LONG CeBtrvCheckDir        (char * PathToCheck);            // i     may include server name, volume, and full path

LONG CeBtrvClientIdFree    (bClientId_t ** clientID);       // i     release ID value and free the structure & perform a Btrieve Reset

LONG CeBtrvClientIdInit    (bClientId_t ** btrvClientID);   // o     allocates a unique client ID structure

LONG CeBtrvClose           (bPosBlk_t   ** posBlk,          // i/o   associated file information/freed on return
                            bClientId_t *  clientID);       // i     unique client ID structure
        
LONG CeBtrvCreate          (char          *  fileName,      // i     path and name of file to be created
                            bCreateSpec_t *  createSpec,    // i     file and key spec structures
                            LONG             createSpecLen, // i     byte length of structure
                            LONG             createMode,    // i     create normal, warn, etc.
                            bClientId_t   *  clientID);     // i     unique client ID structure

LONG CeBtrvDelete          (bPosBlk_t     *  posBlk,        // i/o   current file position information
                            bClientId_t   *  clientID);     // i     unique client ID structure

LONG CeBtrvGetDirect       (bPosBlk_t     *  posBlk,        // i/o   file information structure
                            BYTE          *  dataBuf,       // i/o   4-byte position value (& chunk descriptors)/returned data record
                            LONG          *  dataLen,       // i/o   buffer length/returned data length
                            LONG             keyNum,        // i     n == key num iff establish poistion, -1 == no positioning established, -2 == chunk operation
                            bClientId_t   *  clientID);     // i     unique client ID

LONG CeBtrvGetEqual        (bPosBlk_t      *  posBlk,       // i/o   file information structure
                            BYTE           *  dataBuf,      // i/o   returned data buffer
                            LONG           *  dataLen,      // i/o   max length/returned record length
                            BYTE           *  keyBuf,       // i     search key value
                            LONG              keyLen,       // i     key value length (includes null byte for strings)
                            LONG              keyNum,       // i     key index number
                            bClientId_t    *  clientID);    // i     unique client ID structure

LONG CeBtrvGetFirst        (bPosBlk_t   *  posBlk,          // o     establishes file position information
                            BYTE        *  dataBuf,         // i/o   returned data record
                            LONG        *  dataLen,         // i/o   data buffer/returned record length
                            BYTE        *  keyBuf,          // i     key value (may be "")
                            LONG           keyLen,          // i     key value length (includes null byte for strings)
                            LONG           keyNum,          // i     key index number
                            bClientId_t *  clientID);       // i     unique client ID structure
                           
LONG CeBtrvGetGrtrOrEqual  (bPosBlk_t   *  posBlk,          // i/o   file position information
                            BYTE        *  dataBuf,         // i/o   output data buffer
                            LONG        *  dataLen,         // i/o   data buffer/returned record length
                            BYTE        *  keyBuf,          // i     search key value
                            LONG           keyLen,          // i     key value length (includes null byte for strings)
                            LONG           keyNum,          // i     search key index number
                            bClientId_t *  clientID);       // i     unique client ID structure

LONG CeBtrvGetNext         (bPosBlk_t    *  posBlk,         // i/o   current file position information
                            BYTE         *  dataBuf,        // i/o   returned data record
                            LONG         *  dataLen,        // i/o   data buffer/returned record length
                            BYTE         *  keyBuf,         // i     key value (may be "")
                            LONG            keyLen,         // i     key value length (includes null byte for strings)
                            LONG            keyNum,         // i     key index number
                            bClientId_t  *  clientID);      // i     unique client ID structure

LONG CeBtrvGetPosition     (bPosBlk_t   *  posBlk,          // i     current position information
                            LONG        *  pos,             // i/o   returned physical 4-byte position of the current record
                            bClientId_t *  clientID);       // i     unique client ID structure

LONG CeBtrvID              (LONG             opCode,        // i     Btrieve Operation Code
                            bPosBlk_t     *  posBlk,        // i/o   Btrieve Position Information Block
                            BYTE          *  dataBuf,       // i/o   data buffer
                            LONG          *  dataLen,       // i/o   data buffer length
                            BYTE          *  keyBuf,        // i/o   key buffer
                            LONG             keyNum,        // i     key number/index path
                            bClientId_t   *  clientID);     // i/o   Btrieve client ID structure

LONG CeBtrvInsert          (bPosBlk_t     *  posBlk,        // i/o   current file position information
                            BYTE          *  dataBuf,       // i     insert data record
                            LONG          *  dataLen,       // i     insert data record length
                            BYTE          *  keyBuf,        // i     not used (may be NULL or "")
                            LONG             keyNum,        // o     key index number
                            bClientId_t   *  clientID);     // i     unique client ID structure

LONG CeBtrvOpen            (bPosBlk_t    ** posBlk,         // i/o   returns initialized structure for opened file
                            BYTE         *  fileName,       // i     full path and file name
                            LONG            openMode,       // i     1 == normal, 2 == read only, 3 == exclusive
                            bClientId_t  *  clientID);      // i/o   unique client ID structure

LONG CeBtrvRead            (bPosBlk_t    *  posBlk,         // i     current file information structure
                            BYTE         *  readBuf,        // o     caller's read buffer
                            LONG         *  readBufLen,     // i/o   returned with bytes read
                            BYTE         *  keyBuf,         // i     key value
                            LONG            keyLen,         // i     key length (includes null byte for strings)
                            LONG            keyNum,         // i     key number/Btrieve index path
                            LONG            readFirst,      // i     1 ==> readFirst, 0 ==> read next
                            bClientId_t  *  clientID);      // i/o   unique client ID structure

LONG CeBtrvStat            (bPosBlk_t      *  posBlk,       // i     associated file information block
                            BYTE           *  dataBuf,      // i/o   returned file and key spec structures
                            LONG           *  dataLen,      // i/o   output data buffer length
                            BYTE           *  keyBuf,       // i/o   64-byte buffer minimum length
                            LONG              keyNum,       // i     0 == standard info, -1 == info plus file version information
                            bClientId_t    *  clientID);    // i     unique client ID structure

LONG CeBtrvStepFirst       (bPosBlk_t     *  posBlk,        // i/o   current file position information
                            BYTE          *  dataBuf,       // i/o   returned data record
                            LONG          *  dataLen,       // i/o   buffer length/returned data length
                            bClientId_t   *  clientID);     // i     unique client ID structure

LONG CeBtrvStepNext        (bPosBlk_t      *  posBlk,       // i/o   current file position information
                            BYTE           *  dataBuf,      // i/o   returned data record
                            LONG           *  dataLen,      // i/o   buffer length/returned data length
                            bClientId_t    *  clientID);    // i     unique client ID structure

LONG CeBtrvTransAbort      (bClientId_t * clientID);        // i/o   unique client ID structure

LONG CeBtrvTransBegin      (bClientId_t * clientID);        // i/o   unique client ID structure

LONG CeBtrvTransBeginCC    (bClientId_t * clientID);        // i/o   unique client ID structure

LONG CeBtrvTransEnd        (bClientId_t * clientID);        // i/o   unique client ID structure

LONG CeBtrvUpdate          (bPosBlk_t     *  posBlk,        // i/o   current file position information
                            BYTE          *  dataBuf,       // i/o   data record for update
                            LONG          *  dataLen,       // i     data record length
                            BYTE          *  keyBuf,        // i     not used (may be NULL or "")
                            LONG             keyNum,        // i     key index number
                            bClientId_t   *  clientID);     // i/o   unique client ID structure

/******************************************************************************/
/******************************************************************************/
/******************************* CeDbg Defines ********************************/
/******************************************************************************/

/***************** Client's Global "ceDbgLevel" Bit Definitions ****************
**
** The following bits are defined for the client's "ceDbgLevel" variable used 
** in controlling output through any of the "CeDbg..." output APIs.  When a
** debug session is initialized, the Debug Session Manager records the address
** of the client's "ceDbgLevel" global variable, later when the various debug 
** output routines are called, the session manager checks the current bit 
** settings of the client's debug level variable to determine whether the level
** of formatting and the target of the formatted output.
** 
** There are three basic debug output APIs, CeDbgScrn(), CeDbgFile(), and
** CeDbgWrite().  At the time when these APIs are called, the screen and file
** bits are checked, and if the corresponding bit is set, depending on the API
** called, the output will be directed to these targets.  The CeDbgScrn() API
** accepts an "sprintf()" style control string for formatting and will direct
** its output to both the screen and file according to the setting of the
** controlling debug level variable.  The CeDbgFile() API also accepts an
** "sprintf()" style format string but will only direct its output to the
** associated file when the file bit is set.  The CeDbgWrite() API is similar
** to the CeDbgScrn() API except that no "sprinf()" style formatting is done 
** on the input string, but the output will still be directed to the screen 
** and/or file according to the current setting of the client's debug level
** variable.  The initiator of the debug session is free to change the bit
** settings of the debug level variable at any time to direct the amount and
** type of information that's sent to the target screen and/or file.
**
** The CeDbg_Fmt bit of the debug level variable is generally used only by the
** CeDbgFmt... APIs to determine whether the caller wants formatting performed
** for the current call.  For example, if the user creates his or her own
** interface to the debug manager APIs using the "CeDbg...VA()" entry points,
** the caller can restrict the amount of data being formatted and sent to the
** debug session screen and still allow the fully formatted data to be sent to
** debug file. 
**
*******************************************************************************/

#define  CeDbg_Screen               0x00000001  // bit 0 enables output to screen
#define  CeDbg_File                 0x00000002  // bit 1 enables output to file
#define  CeDbg_Fmt                  0x00000004  // bit 2 enables formatting routines

/******************** CeDbgInit() ceDbgOption Bit Definitions ******************
**
** The following bits are defined for the "ceDbgOptions" of the CeDbgInit()
** API.  The first two bits are mutually exclusive;  requesting non-blocking 
** execution will cause all output requests to be queued to a background 
** process, in which case the CeDbg_WriteThroughCache bit will be ignored.  
** The CeDbg_NonBlocking bit has precedence over the CeDbg_WriteThroughCache
** bit.
**
** The CeDbg_MemoryFile option has precedence over the other two bits.  In 
** which case the data is maintained in a circular memory queue until the
** debug session is closed or the memory queue is flushed.  When this option 
** is specified, the CeDbg_AppendFile option may also be specified to allow
** the target disk file act as an accumulator file while the data maintained
** in memory (the logical wrap file) is restricted by the file size parameter.  
** This allows the user to get occasional snapshots of the memory file without
** losing the previous snapshot.
**
*******************************************************************************/

#define  CeDbg_BlockMode            0           // provided just for the label.

#define  CeDbg_WriteThroughCache    0x00000001  // Client is blocked as data is committed to disk
#define  CeDbg_NonBlocking          0x00000002  // All output is performed in the background
#define  CeDbg_MemoryFile           0x00000004  // All output is maintain on a circular queue until closed
#define  CeDbg_AppendFile           0x00000008  // (used w/MemoryFile opt) Data is appended to existing disk file
#define  CeDbg_SnapShotHeader       0x00000010  // Output a time-stamp when the file is flushed
#define  CeDbg_BinaryFile           0x00000020  // Output file is opened in binary mode
#define  CeDbg_FmtHexWithTime       0x00000040  // A time stamp is output with Hex formatted data

/******************************************************************************/
/************************ CeDbg SysMsg API Return Codes ***********************/
/******************************************************************************/

#define  CeLib_SysMsgBase        0x00030000  // CeLib System Messages API Base Value

#define  CEE_WrapFileCloseFail   0x00030001  // Unable to close the requested Wrap File.
#define  CEE_BadNlmID            0x00030002  // The client process passed an invalid Nlm ID to the CeLib.
#define  CEE_CantOpenScreen      0x00030003  // Unable to create the requested screen.
#define  CEE_BadFileName         0x00030004  // The file name specified does not conform to standard naming conventions.
#define  CEE_NoMemory            0x00030005  // Unable to allocate requested dynamic memory.
#define  CEE_WrapFileOpenFail    0x00030006  // Unable to open the requested Wrap File.
#define  CEE_WrapFileWriteFail   0x00030007  // An I/O error was encountered while attempting to write to the specified wrap file.
#define  CEE_InvalidPathSyntax   0x00030008  // Invalid path specified.
#define  CEE_CreateDirectoryErr  0x00030009  // Unable to create the specified directory.
#define  CEE_BtrvClientID        0x0003000A  // Unable to assign a unique Btrieve Client ID value.
#define  CEE_InvalidMemFree      0x0003000B  // The calling process has attempted to release memory that was not allocated through the corresponding CeAlloc() function.
#define  CEE_SmpNotAvailable     0x0003000C  // NetWare SMP services has not been installed on the running Server.
#define  CEE_ThreadGroupID       0x0003000D  // The calling process has passed an invalid Thread Group ID.
#define  CEE_MemManHandle        0x0003000E  // The calling process has passed an invalid CeLib Memory Manager Handle.

// NOTE: CeSmpE_xxx API return codes begin at 0x00030020.

/******************************************************************************/
/************************ CeDbg Prototype Definitions *************************/
/******************************************************************************/

LONG  CeDbgDeInit    (struct CeDbg_t   ** dbgInfoStruct);   // debug info struct pointer

LONG  CeDbgInit      (int                 clientNlmID,      // client's Nlm ID
                      LONG                ceDbgOption,      // see "ceDbgOption" definitions above 
                      char             *  sessionTag,       // client's mnemonic thread name
                      LONG             *  ceDbgLevel,       // client's global debug level variable
                      char             *  dbgFileName,      // requested (possibly shared) file name
                      LONG                dbgFileSize,      // requested file size in Kb (10 Kb to 2 Mb)
                      char             *  dbgScrnName,      // requested (possibly shared) screen name
                      struct CeDbg_t   ** dbgInfoStruct);   // returns initialized debug info structure

LONG  CeDbgFile      (struct CeDbg_t   *  dbgInfoStruct,    // client's info struct pointer
                      char             *  dbgFormatStr,     // client's format string
                      ...);                                 // variable parameters for format string

LONG  CeDbgFileVA    (struct CeDbg_t   *  dbgInfoStruct,    // client's info struct pointer
                      char             *  dbgStr,           // client's format string
                      va_list             vaArgs);          // variable arguments list (stack) pointer.

LONG  CeDbgFlush     (struct CeDbg_t   *  dbgInfoStruct);   // Refresh the associated debug session wrap file

LONG  CeDbgFmtHex    (struct CeDbg_t   *  dbgInfoStruct,    // client's info struct pointer
                      BYTE             *  data,             // data to be formatted 
                      LONG                dataLen,          // length of data to format
                      LONG                offset);          // formatted beginning offset

LONG  CeDbgFmtMBlk   (struct CeDbg_t   *  dbgInfoStruct,    // client's info struct pointer
                      struct msgb      *  mBlkPtr,          // mblk_t struct to be formatted
                      int                 dispMblkDetail);  // ~0 --> display mblk_t details
                          
LONG  CeDbgFmtStrBuf (struct CeDbg_t   *  dbgInfoStruct,    // client's info struct pointer
                      struct strbuf    *  strBufPtr);       // strbuf buffer(s) to be formatted

LONG  CeDbgLevel     (struct CeDbg_t   *  dbgInfoStruct);   // client's info struct pointer

LONG  CeDbgOptions   (struct CeDbg_t   *  dbgPtr,           // client's info struct pointer
                      LONG             *  newOpts,          // new options value, or NULL
                      LONG             *  oldOpts);         // old options value, or NULL

LONG  CeDbgScrn      (struct CeDbg_t   *  dbgInfoStruct,    // client's info struct pointer
                      char             *  dbgFormatStr,     // client's format string
                      ...);                                 // variable parameters for format string

LONG CeDbgScrnVA     (struct CeDbg_t   *  dbgInfoStruct,    // client's info struct pointer
                      char             *  dbgStr,           // client's format string
                      va_list             vaArgs);          // variable arguments list (stack) pointer.

LONG  CeDbgWrite     (struct CeDbg_t   *  dbgInfoStruct,    // client's info struct pointer
                      char             *  printBuf);        // null terminated string to be output to the screen and/or file

/******************************************************************************/
/******************** CeMutex/CmQue Routine API Return Codes ******************/
/******************************************************************************/

#define  CeSmpE_BadSemaphore        0x00030020  // The caller has attempted an operation on an invalid semaphore.
#define  CeSmpE_MutexAllocFailed    0x00030021  // The OS was unable to allocate/intialize the requested semaphore.
#define  CeSmpE_MutexSubTypeInvalid 0x00030022  // The caller has passed an invalid Mutex subType to a CeMutex/CmQue routine.
#define  CeSmpE_MutexTypeInvalid    0x00030023  // The caller has passed an invalid Mutex Type to a CeMutex/CmQue routine.

/******************************************************************************/
/******************* CeMutex: NetWare SMP Mutex interface APIs ****************/
/******************************************************************************/

LONG  CeMutexAlloc   (LONG    *  mutex,      // ptr to caller's mutex struct
                      BYTE    *  mutexName,  // caller defined name string.
                      LONG       mutexType); // CeSmpC_Mutex, CeSmpC_Spin, etc.

LONG  CeMutexDestroy (LONG    *  mutex,      // ptr to caller's mutex struct
                      LONG       mutexType); // CeSmpC_Mutex, CeSmpC_Spin, etc.

LONG  CeMutexLock    (LONG       mutex,      // ptr to caller's mutex struct
                      LONG       mutexType,  // CeSmpC_Mutex, CeSmpC_Spin, etc.
                      ...);                  // subType: for Read/Write Mutex

LONG  CeMutexTryLock (LONG       mutex,      // ptr to caller's mutex struct
                      LONG       mutexType,  // CeSmpC_Mutex, CeSmpC_Spin, etc.
                      ...);                  // subType: for Read/Write Mutex

LONG  CeMutexUnlock  (LONG       mutex,      // ptr to caller's mutex struct
                      LONG       mutexType); // CeSmpC_Mutex, CeSmpC_Spin, etc.

/******************************************************************************/
/******************************************************************************/
/***************** CeQue_t & CmQue_t Structures and Definitions ***************/
/******************************************************************************/
/*************** Mutex Semaphore Types for CeMutex/CmQue Routines *************/
/******************************************************************************/

#define EOK                      0x0000
#define EBUSY                    0x0001
#define EINVL                    0xFFFF

#define CeSmpC_LocalSem          1
#define CeSmpC_Mutex             2
#define CeSmpC_ReadWrite         3
#define CeSmpC_RMutex            4
#define CeSmpC_Spin              5

   //************** MutexType Read\Write Sub-Types

#define CeSmpC_ReadLock          1
#define CeSmpC_WriteLock         2

/******************************************************************************/

typedef struct CeQue_t
{
   struct CeQel_t *  first;         // 0  first item on the queue
   struct CeQel_t *  last;          // 4  last item on the queue
   unsigned long     count;         // 8  number of CeQel_t items on the queue
} CeQue_t;

typedef struct CmQue_t
{
   struct CeQel_t *  first;         // 0  first item on the queue
   struct CeQel_t *  last;          // 4  last item on the queue
   unsigned long     count;         // 8  number of CeQel_t items on the queue
   LONG              mutex;         // C  allocated SMP semaphore
   LONG              mutexType;     // 10 SMP semaphore type, i.e., mutex_t, spin_t, etc.
} CmQue_t;

typedef struct CeQel_t
{
   struct CeQel_t *  next;          // Next item in the queue (or NULL)
   struct CeQel_t *  prev;          // Previous item in the queue (or NULL)
   void           *  info;          // info being put on the queue
   LONG              type;          // User defined queue element type.  
                                    // NOTE: The "type" field is not referenced 
                                    // by the CeQue.. or CmQue.. routines.
} CeQel_t;

/******************************************************************************/
/***************** CeQue Macro & Function Prototype Definitions ***************/
/******************************************************************************/

#define  CeQueEmpty(q)        ((q)->first == NULL)
#define  CeQueLength(q)       ((q)->count)
#define  CeQueFirst(q)        ((q)->first)
#define  CeQueLast(q)         ((q)->last)
#define  CeQueNext(e)         ((e)->next)
#define  CeQuePrev(e)         ((e)->prev)

         // ************ Non SMP Aware Queue Routines ***********

CeQel_t *  CeQueGetFirst      (CeQue_t *  queHead);         // head of queue to get an element from 

void    *  CeQueInfo          (CeQel_t *  queElem);         // queue element to return info field from

LONG       CeQueInit          (CeQue_t *  queHead);         // queue head to initialize

LONG       CeQueInsertAfter   (CeQue_t *  queHead,          // queue head to insert into
                               CeQel_t *  queElem_1,        // element to insert 
                               CeQel_t *  queElem_2,        // insert new element after this one
                               void    *  infoNode);        // infoNode to associate with queElem_1

LONG       CeQueInsertBefore  (CeQue_t *  queHead,          // queue head to insert into
                               CeQel_t *  queElem_1,        // element to insert 
                               CeQel_t *  queElem_2,        // insert new element before this one
                               void    *  infoNode);        // infoNode to associate with queElem_1

LONG       CeQueJoin          (CeQue_t *  queOne,           // first queue
                               CeQue_t *  queTwo);          // second queue, will be appended to queOne

LONG       CeQuePutFirst      (CeQue_t *  queHead,          // queue head to insert into
                               CeQel_t *  queElem,          // element to insert at front of queue
                               void    *  infoNode);        // data associated with queue element

LONG       CeQuePutLast       (CeQue_t *  queHead,          // queue head to insert into
                               CeQel_t *  queElem,          // element to insert at end of queue
                               void    *  infoNode);        // data associated with queue element

LONG       CeQueRemove        (CeQue_t *  queHead,          // queue head to remove from
                               CeQel_t *  queElem);         // element to remove from queue

CeQel_t *  CeQueSearch        (CeQue_t *  queHead,          // queue head 
                               int  (*func) (CeQel_t  *  queElem,    // user specified search func that takes
                                             void     *  funcArg),   // two args; 1) elem containing compare 
                               void    *  funcArg);                  // data, and 2) the data to compare.

LONG  CeQueSeparate           (CeQue_t *  queOne,           // queue head to unlink from
                               CeQel_t *  queElem,          // first node of unlink chain
                               CeQue_t *  queTwo);          // que head to return the unlinked list

         // ************ SMP/Mutex Aware Queue Routines ***********

LONG       CmQueDeInit        (CmQue_t *  queHead);         // head of queue to free Mutex semaphore

CeQel_t *  CmQueGetFirst      (CmQue_t *  queHead);         // head of queue to get an element from 

LONG       CmQueInit          (CmQue_t *  queHead,          // CmQue_t struct containing Mutex semaphore to initialize
                               BYTE    *  mutexName,        // Caller defined name string.
                               LONG       mutexType);       // CeSmpC_Mutex, CeSmpC_Spin, etc.

LONG       CmQueInsertAfter   (CmQue_t *  queHead,          // CmQue_t struct containing Mutex semaphore
                               CeQel_t *  queElem_1,        // element to insert 
                               CeQel_t *  queElem_2,        // insert new element after this one
                               void    *  infoNode);        // infoNode to associate with queElem_1

LONG       CmQueInsertBefore  (CmQue_t *  queHead,          // CmQue_t struct containing Mutex semaphore
                               CeQel_t *  queElem_1,        // element to insert 
                               CeQel_t *  queElem_2,        // insert new element before this one
                               void    *  infoNode);        // infoNode to associate with queElem_1

LONG       CmQueJoin          (CmQue_t *  queOne,           // first queue
                               CeQue_t *  queTwo);          // second queue, will be appended to queOne

LONG       CmQueLock          (CmQue_t *  queHead);         // CmQue_t struct containing Mutex semaphore to lock

LONG       CmQueLockTry       (CmQue_t *  queHead);         // CmQue_t struct containing Mutex semaphore to try to lock

LONG       CmQueUnlock        (CmQue_t *  queHead);         // CmQue_t struct containing Mutex semaphore to unlock

LONG       CmQuePutFirst      (CmQue_t *  queHead,          // queue head to insert into
                               CeQel_t *  queElem,          // element to insert at front of queue
                               void    *  infoNode);        // data to associate with queue element

LONG       CmQuePutLast       (CmQue_t *  queHead,          // queue head to insert into
                               CeQel_t *  queElem,          // element to append at end of queue
                               void    *  infoNode);        // data to associate with queue element

LONG       CmQueRemove        (CmQue_t *  queHead,          // queue head to remove from
                               CeQel_t *  queElem);         // element to remove from queue

CeQel_t *  CmQueSearch        (CmQue_t *  queHead,          // search queue head
                               int  (*func) (CeQel_t  *  queElem,    // user specified search func that takes
                                             void     *  funcArg),   // two args; 1) elem containing compare 
                               void    *  funcArg);                  // data, and 2) the data to compare.

LONG       CmQueSeparate      (CmQue_t *  queOne,           // queue head to unlink from
                               CeQel_t *  queElem,          // first node of unlink chain
                               CeQue_t *  queTwo);          // que head to return the unlinked list

LONG       CmQueUnlock        (CmQue_t *  queHead);         // CmQue_t struct containing SMP semaphore to unlock

/******************************************************************************/
/******************************************************************************/
/**************************** CeWrap Structures *******************************/
/******************************************************************************/

typedef struct CeWrapList_t
{
   // This structure is used by the CeWrapListInit() API to return a
   // linked list of files currently being managed by the Wrap File Manager.
   // The linked list may be freed by calling CeWrapListFree().

   struct CeWrapList_t  *  selfRef;          // struct validation field
   struct CeWrapList_t  *  next;             // next node in the linked list
   char                 *  fileName;         // full path and file name
   LONG                    fileSize;         // max file size of open wrap file (in bytes)
   LONG                    subFileSize;      // current size of memory file
   LONG                    ceWrapOption;     // see ceWrapOption variable
} CeWrapList_t;

/******************************************************************************/
/****************************** CeWrap Defines ********************************/
/******************************************************************************/

/****************** CeWrapOpen() ceWrapOption Bit Definitions ******************
**
** The following bit is defined for the "ceWrapOptions" of the CeWrapOpen()
** API.  Requesting the write through cache option will cause the client to
** block until the data has been committed to disk.
**
*******************************************************************************/

#define  CeWrap_WriteThroughCache   0x00000001  // Client is blocked as data is committed to disk
#define  CeWrap_MemoryFile          0x00000004  // Data is maintained on a circular queue
#define  CeWrap_AppendFile          0x00000008  // (used w/MemoryFile opt) Data is appended to existing disk file
#define  CeWrap_SnapShotHeader      0x00000010  // Output a time-stamp when flushed
#define  CeWrap_BinaryFile          0x00000020  // Output file is opened in binary mode
   
/******************************************************************************/
/************************ CeWrap API Prototype Definitins *********************/
/******************************************************************************/

LONG  CeWrapClose       // Close and release resources for the previously opened wrap file.

   (struct CeWrap_t  ** wrapInfoStruct);     // Allocated Wrap structure pointer


LONG  CeWrapFlush       // Flushes the associated sub-files to the target file

   (struct CeWrap_t  *  wrapInfo);           // client's wrap info pointer


LONG  CeWrapFlushAll (void);  // Flushes the all sub-files to their respective target files


LONG  CeWrapOpen              // Allocates resources and opens specified wrap file.

   (int                 clientNlmID,         // i     client's Nlm ID
    LONG                ceWrapOption,        // i     CeWrap_WriteThroughCache..., etc
    char             *  reqFileName,         // i     full path & file name
    LONG             *  reqFileSize,         // i/o   size in K-bytes
    struct CeWrap_t  ** retWrapInfo);        // i/o   allocated wrap info struct

LONG  CeWrapWrite    // output data to the specified wrap file.

   (struct CeWrap_t  *  wrapInfoStruct,      // wrap manager info struct
    BYTE             *  data,                // data to output to wrap file
    LONG                dataLen);            // when text, does not include null terminator

/******************************************************************************/
/******************************************************************************/
/********************* CSSM System Messages API Return Codes ******************/
/******************************************************************************/

#define CSSM_SysMsgBase             0x00250000  // CSSME_xxx base error number  

#define CSSME_MsgUndefined          0x00250001  // The specified system message is undefined in the database.
#define CSSME_MsgAlreadyDefined     0x00250002  // CSSM_Register() was called with a previously defined System Message base error number.
#define CSSME_Malloc                0x00250003  // Unable to allocate requested memory.
#define CSSME_TextNotTranslated     0x00250004  // CSSM_GetSysMsg() returned the default text instead of the requested translated text.
#define CSSME_LibraryUnusable       0x00250005  // The CSLIB could not be initailized and is unusable.
#define CSSME_SysMsgInfoInvalid     0x00250006  // The CS_SysMsgInfo_t structure is invalid.
#define CSSME_FileNotFound          0x00250007  // The requested NLS language file could not be found.
#define CSSME_ReqLangNotFound       0x00250008  // The requested NLS language file could not be found, but the language file for the default OS language ID was returned.
#define CSSME_NotAnNlsMsgFile       0x00250009  // The requested file is not a standard NLS message file.
#define CSSME_UnableToRegSysMsg     0x0025000a  // Unable to register the module's system messages with the System Messages Library.
#define CSSME_UnableToReadNlsMsg    0x0025000b  // Unable to read the requested NLS message information.
#define CSSME_BadNlmID              0x0025000c  // The input value of the caller's NLM ID was invalid.
#define CSSME_NlmHdrMisMatch        0x0025000d  // The NLS Message File does not match the version required by the associated NLM.
#define CSSME_NoCurrentScreen       0x0025000e  // The calling process has requested output to an alternate screen.  However, there are no alternate screens active.
#define CSSME_TextPtrInvalid        0x0025000f  // The calling process has specified a text pointer that does not point to valid memory.
#define CSSME_DupMsgNumInSet        0x00250010  // The calling process has attempted to register a set of System Messages that contain duplicate message numbers.

/*******************************************************************************
********************** CSSM System Messages Language IDs ***********************
*******************************************************************************/

#define CSSMC_DefaultLanguage       -1          // Requests the language currently running on the Server.
#define CSSMC_CanadianFrench        0
#define CSSMC_Chinese               1
#define CSSMC_Danish                2
#define CSSMC_Dutch                 3
#define CSSMC_English               4
#define CSSMC_Finnish               5
#define CSSMC_French                6
#define CSSMC_German                7
#define CSSMC_Italian               8
#define CSSMC_Japanese              9
#define CSSMC_Korean                10
#define CSSMC_Norwegian             11
#define CSSMC_Portuguese            12
#define CSSMC_Russian               13
#define CSSMC_Spanish               14
#define CSSMC_Swedish               15

/*******************************************************************************
******************** CSSM System Message Structure Definitions *****************
*******************************************************************************/

#define CS_SysMsg_INFO        0        // Informational message           
#define CS_SysMsg_WARN        1        // Warning message                 
#define CS_SysMsg_MINOR       2        // Recoverable error detected      
#define CS_SysMsg_MAJOR       3        // Non-recoverable error deteccted 
#define CS_SysMsg_CRITICAL    4        // ABEND condition detected        
#define CS_SysMsg_UNKNOWN     5        // Unknown serverity level         
#define CS_SysMsg_NoSeverity  5        // --> Don't display a severity level  

typedef struct CS_SysMsgInfo_t
{
   LONG     msgNum;                    // Global message number
   LONG     msgIndex;                  // MsgTools database (MDB) index # 
   WORD     msgType;                   // Message severity, CS_SysMsg_... (see above)
   char  *  msgText;                   // Pointer to (translated) text    
} CS_SysMsgInfo_t;

/*******************************************************************************
********************** System Messages API "options" #defines ******************
********************************************************************************
**
** The following #defines represent bit-masks that may be ORed together to
** define the "options" parameter for the various System Message output 
** routines.
**
*******************************************************************************/

#define CSSMC_NoWaitOnOutput  0x00000000    // Thread is not blocked on output.
#define CSSMC_WaitOnOutput    0x00000001    // Thread waits for output.
#define CSSMC_LogOutput       0x00000002    // Send output to log file.
#define CSSMC_CurrentScreen   0x00000004    // Send output to current screen instead of console.
#define CSSMC_NoHeader        0x00000008    // Don't print the standard header with the string.
#define CSSMC_NoNewLineAtEnd  0x00000010    // Don't append a new-line sequence to the output.

/******************************************************************************* 
******************* System Messages API Return Value Bit Masks *****************
********************************************************************************
** 
** The CSSMC_Api64BitReturn bit mask is reserved for use as future 64-bit 
** software is developed.  When this bit is set, it indicates the return  
** value is 64 bit value.                                                 
**
*******************************************************************************/

#define CSSMC_Api64BitReturn  0x80000000  // return value is 64 bits in length

/*******************************************************************************
*********************** CSSM System Messaging API Prototypes *******************
********************************************************************************
**                           -- N O T E --
** The formatted message text may contain embedded new-line characters ("\n"),
** to force a line break in the output text.  Embedded carriage-returns ("\r"), 
** however, will be ignored.
**
*******************************************************************************/

LONG  CSSM_DisplayNlsMsg (
            LONG     NlmID,         // Caller's NLM ID
            LONG     options,       // See API "options" above.
            LONG     msgIndex,      // Message index of associated message text.
            BYTE  *  msgText,       // Caller's text string pointer.
            ...);                   // Variable arguments list.

LONG  CSSM_DisplayNlsMsgVA (
            LONG     NlmID,         // Caller's NLM ID
            LONG     options,       // See API "options" above.
            LONG     msgIndex,      // Message index of associated message text.
            BYTE  *  msgText,       // Caller's text string pointer.
            va_list  varArgList);   // variable arguments list (stack) pointer.

LONG  CSSM_DisplaySysMsg (
            LONG     options,       // See API "options" above.
            LONG     msgNum,        // Error number of associated message text.
            char  *  compID2,       // Component ID of calling sub-process.
            ...);                   // Variable argumaent list.
                             
LONG  CSSM_DisplaySysMsgVA (
            LONG     options,       // See API "options" above.
            LONG     msgNum,        // Error number of associated message text.
            char  *  compID2,       // Component ID of calling sub-process.
            va_list  varArgList);   // variable arguments list (stack) pointer.
                             
LONG  CSSM_DisplayUserMsg (
            LONG     NlmID,         // Caller's NLM ID
            LONG     options,       // See API "options" above.
            LONG     msgNum,        // Error number of associated message text.
            char  *  severity,      // Major, Minor, etc. text.
            char  *  modName,       // NLM name of calling module.
            char  *  version,       // Version string of calling NLM.
            char  *  compID,        // Component ID of registered sub-process.
            char  *  compID2,       // Component ID of calling sub-process.
            char  *  msgText,       // Message text associated w/error number.
            ...);                   // variable arguments list.

LONG  CSSM_DisplayUserMsgVA (
            LONG     NlmID,         // Caller's NLM ID
            LONG     options,       // See API "options" above.
            LONG     msgNum,        // Error number of associated message text.
            char  *  severity,      // Major, Minor, etc. text.
            char  *  modName,       // NLM name of calling module.
            char  *  version,       // Version string of calling NLM.
            char  *  compID,        // Component ID of registered sub-process.
            char  *  compID2,       // Component ID of calling sub-process.
            char  *  msgText,       // Message text associated w/error number.
            va_list  varArgList);   // variable arguments list (stack) pointer.

LONG  CSSM_GetSysMsg (
            LONG     NlmID,         // Caller's NLM ID
            LONG     msgNum,        // error number of associated text
            LONG     langID,        // requested language of returned text
            char  ** severity,      // return severity level of error
            char  ** modName,       // return name of defining module
            char  ** version,       // revision level of defining module
            char  ** compID,        // component ID of defining sub-process
            char  ** msgText);      // message text associated with error number
                              
LONG  CSSM_Register (
            CS_SysMsgInfo_t * msgArray,   // (in) system message array to register 
            char            * prodDir,    // (in) NLM product directory
            char            * msgFile,    // (in) message file name 
            char            * modName,    // (in) NLM name 
            char            * version,    // (in) NLM version level
            char            * compID,     // (in) sub-process name 
            LONG              langID,     // (in) registered language ID
            LONG              msgBase,    // (in) global msg base number
            LONG              NlmID);     // (in) Caller's NLM ID

LONG CSSM_ReturnAuxMessageInformation (
            LONG            NlmID,           // (in) Caller's NLN ID
            const BYTE  *   searchPath,      // (in) NLM load path
            const BYTE  *   fileName,        // (in) NULL --> default file name
            BYTE        *** messageTable,    // (out) return message structure
            LONG        *   messageCount,    // (out) return message count
            LONG        *   languageID,      // (in\out) -1 --> default OS language
            BYTE        **  version,         // (out) Version String of the NetWare Message File
            BYTE        **  helpFile);       // (out) return help structure

/******************************************************************************/
/******************************************************************************/
/************************* CeSubs API Prototype Defintions ********************/
/******************************************************************************/

/******************************************************************************/
/********************** Defines for CeFileOpen() "options" ********************/
/*******************************************************************************
 **
 **   The following defines are used by the CeFileOpen() routine to specify 
 **   the "accessMode" for the "sopen()" call.  Once the file is created and/or
 **   opened, the file is closed to ensure that the file is accessable and 
 **   potenially truncated on the disk image (recorded in the FAT table).
 **   Afterwards, if the CEC_LeaveOpen option has been specified, the file is
 **   reopened before returning to the caller.
 **
 ******************************************************************************/

#define  CEC_Create        0x00000001     // opens the file with the O_CREAT bit set
#define  CEC_Truncate      0x00000002     // opens the file with the O_CREAT bit set
#define  CEC_LeaveOpen     0x00000004     // Leaves the file open on return

/******************************************************************************/

char     CeDelimiter       (char    inputChar,           // char to check against delimiter list, returns matched char
                            char *  delimiters);         // null terminated list of delimiting chars
LONG     CeFileBackup      (char *  fileName,            // full path and file name
                            int     accessMode);         // original access mode of file
LONG     CeFileClose       (int  *  fileHandle);         // pointer to the open file handle
LONG     CeFileOpen        (char *  fileName,            // target file name
                            char *  fmtPath,             // optional path with %s for file name
                            int     options,             // Trunc/Close/LeaveOpen ...etc
                            int     reqAccessMode,       // callers access options
                            int  *  fileHandle);         // returned open file handle or "-1"
BYTE  *  CeFmtByteArray    (BYTE *  outBuf,              // output buffer
                            BYTE *  byteArray,           // network order byte array
                            LONG    arraySz,             // array size in bytes
                            LONG    leadZero);           // print all leading zeros
LONG     CeFmtDate         (BYTE *  dateBuf);            // Formats date and time, i.e., "05/01/94  23:25:43"
LONG     CeFree            (void ** memPtr);             // caller's ptr is cleared on return
LONG     CeLibVers         (LONG *  majorVer,            // returned major version level 
                            LONG *  minorVer,            // returned minor version level
                            LONG *  revision);           // returned revision level
LONG     CeMalloc          (void ** memPtr,              // ptr to allocated memory, or NULL
                            size_t  memSize);            // operation is non-blocking
LONG     CeMallocB         (void ** memPtr,              // ptr to allocated memory, or NULL
                            size_t  memSize);            // operation may thread switch w/retry
LONG     CeMemFill         (BYTE *  dataElem,            // ptr to fill buffer 
                            LONG    dataElemSize,        // byte length of fill buffer
                            BYTE *  fillString);         // optional string used as fill background
LONG     CeRealloc         (void ** memPtr,              // ptr to reallocated memory, or NULL
                            size_t  memSize);            // operation is non-blocking
LONG     CeReallocB        (void ** memPtr,              // ptr to reallocated memory, or NULL
                            size_t  memSize);            // operation may thread switch w/retry)
char  *  CeSkipToken       (char *  input,               // pointer to token to be skipped, returns ptr to white or delimiter char
                            char *  delimiters);         // optional null terminated list of delimiters (pass NULL if ommitted)
char  *  CeSkipWhite       (char *  input);              // ptr to the beginning of a white space field, returns ptr to next token
LONG     CeSetFileName     (char *  fileNameIn,          // null terminated path & file name
                            char *  fileNameOut);        // cononical form == <vol:path\filename>
LONG     CeSetNlmID        (LONG    nlmID);              // set the current OS NLM context as specified
LONG     CeSetThreadGroupID(LONG    threadGrpID);        // sets the current OS thread group ID as specified
LONG     CeSetThreadName   (char *  appendName,          // null terminated mnemonic
                            int     overWriteBaseName);  // ~0 == overwrite base process name
LONG     CeStrBufMalloc    (struct  strbuf ** strBufPtr, // ret ptr to allocated strbuf ctl & data buffers
                            LONG    bufSize);            // size of allocated data buffer
LONG     CeStrBufMallocB   (struct  strbuf ** strBufPtr, // ret ptr to allocated strbuf ctl & data buffers
                            LONG    bufSize);            // size of allocated data buffer (operation may thread switch w/retry)
LONG     CeStrBufFree      (struct  strbuf ** strBufPtr);// free buffers & NULLs ptr for return
LONG     CeValidatePtr     (void *  memPtr);             // memory pointer to validate, returns SUCCESS if valid

/******************************************************************************/
#endif                                                // _CSSYSMSG_INCLUDED  
/******************************************************************************/
