; Preferred Systems Database Initialization File

; Copyright (C) 1993-95 Preferred Systems Inc.
; All Rights Reserved

[System]

IniVersion="1.32"
DiscoverVersion="1.48"
DatabaseVersion="2.03"
DatabaseVersionFile="DSDB.VER"

Table Suffix=.DBF
Index Suffix=.CDX

Filter Expression=.NOT.DELETED()

;
;-----------------------------------------------------------------------------
;

; The following declarations are for DS Standard tables

[TableNames]

SVALUES=
TREE=
VALUES=
DSPROJECT=
DSPV=
DSVIEW=

[EndTableNames]
; for DS Standard Tables


;
;-----------------------------------------------------------------------------
;


[SVALUES]
Object Name = SubValues
File Name = SVALUES.DBF
Bindery Object Type = SUBVALUE_OBJ
Description = The Sub Values table
Long Description = This is the PSINDNDB Sub Values Table

[SVALUES-Primary Key]
NDSID+OBJID+TYPEID+AID+ADIID+VALID=

[SVALUES-Alternate Keys]
NDSID=
NDSID+OBJID+TYPEID=

[SVALUES-Fields]
NDSID=         C,10,0,,Directory Services ID
OBJID=         C,10,0,,ID of the current node (MYID)
TYPEID=        C,3,0,,Type ID
AID=           C,3,0,,Attribute ID
ADIID=         C,3,0,,Attribute Data Item ID
VALID=         C,5,0,,Value ID
STRING=        C,254,0,,Holds Strings
MEMO=          M,10,0,,Holds memo info

;
;
;

[TREE]
Object Name = Tree
File Name = TREE.DBF
Description = H-Tree
Long Description = This table contains the hierachical structure for the PSINDSDB.

;
;
;

[TREE-Primary Key]
NDSID+PARENTID=

[TREE-Alternate Keys]
NDSID=
NDSID+MYID=
NDSID+PARENTID+SUBSTR(MYNAME,1,47)=

[TREE-Fields]
;FldName       Type, Size, Dec, Display, Function, Description
NDSID=         C,10,0,,Directory Services ID
PARENTID=      C,10,0,,ID of this node's parent object
PARTYPE=       C,4,0,,Type of the parent
MYID=          C,10,0,,ID of the current node
MYTYPE=        C,4,0,,Type of the current node
MYNAME=        C,128,0,,Name of the current node

;
;
;

[VALUES]
Object Name = Values
File Name = VALUES.DBF
Bindery Object Type = VALUE_OBJ
Description = The Values table
Long Description = This is the PSINDSDB Values Table

[VALUES-Primary Key]
NDSID+OBJID+TYPEID+AID+ADIID+VALID=

[VALUES-Alternate Keys]
NDSID=
NDSID+OBJID+TYPEID=
NDSID+STATUS+SUBSTR(STRING,1,10)=

[VALUES-Fields]
NDSID=         C,10,0,,Directory Services ID
OBJID=         C,10,0,,ID of the current node (MYID)
TYPEID=        C,3,0,,Type ID
AID=           C,3,0,,Attribute ID
ADIID=         C,3,0,,Attribute Data Item ID
VALID=         C,5,0,,Value ID
STATUS=        C,1,0,,Holds Status Flag
STRING=        C,254,0,,Holds Strings
MEMO=          M,10,0,,Holds memo info

;
;
;

[DSPROJECT]
Object Name = Project
File Name = DSPROJEC.DBF
Bindery Object Type = PROJECT_OBJ
Description = The Project table
Long Description = This table stores information about DS Standard's Projects

[DSPROJECT-Primary Key]
PROJID=

[DSPROJECT-Alternate Keys]
NAME=

[DSPROJECT-Fields]
PROJID=         C,10,0,,Project ID
NAME=           C,30,0,,Project Name
COMPANY=        C,30,0,,Project Company
AUTHOR=         C,30,0,,Project Author
COMMENT=        C,254,0,,Comments

;
;
;

[DSPV]
Object Name = Project
File Name = DSPV.DBF
Description = DS Projects-View Information
Long Description = This table describes each view in a DS Standard Project

[DSPV-Primary Key]
PROJID=

[DSPV-Alternate Keys]
VIEWID=
PROJID+VIEWID=

[DSPV-Fields]
PROJID=         C,10,0,,Project ID
VIEWID=         C,10,0,,View ID
WINOPEN=        L,1,0,,This is the view open in the project
WINNUM=         N,9,0,,The number of the window (0 is the last active, 1 the next, etc)
VIEWLEFT=       N,9,0,,Left point
VIEWTOP=        N,9,0,,Top point
VIEWRIGHT=      N,9,0,,Right point
VIEWBOTTOM=     N,9,0,,Bottom point
VIEWSORT=       N,9,0,,View sort index (natural, object name, full name, etc)
VIEWORDER=      N,9,0,,View order index (ascending, descending)
VIEWOBJ=        N,9,0,,Binary string of objects included in view

;
;
;

[DSVIEW]
Object Name = Project
File Name = DSVIEW.DBF
Description = DS View Information
Long Description = This table describes the state of a single DS View

[DSVIEW-Primary Key]
VIEWID=

[DSVIEW-Alternate Keys]
NAME=

[DSVIEW-Fields]
VIEWID=         C,10,0,,View ID
NAME=           C,30,0,,View Name
AUTHOR=         C,30,0,,View Author
DATE1=          C,10,0,,Date #1
DATE2=          C,10,0,,Date #2
CREATEDATE=     C,10,0,,View creation date
READSTAT=       N,2,0,,Read-Only or Read-Write
SOURCE=         N,2,0,,Source or Target
TYPE =          N,2,0,,NDS or Bindery
WINOPEN=        L,1,0,,This is the view open in the project
WINNUM=         N,9,0,,The number of the window (0 is the last active, 1 the next, etc)
VIEWLEFT=       N,9,0,,Left point
VIEWTOP=        N,9,0,,Top point
VIEWRIGHT=      N,9,0,,Right point
VIEWBOTTOM=     N,9,0,,Bottom point
VIEWSORT=       N,9,0,,View sort index (natural, object name, full name, etc)
VIEWORDER=      N,9,0,,View order index (ascending, descending)
VIEWOBJ=        N,9,0,,Binary string of objects included in view
APPCREATE=      N,2,0,,The application who created the view
