; Preferred Systems Database Initialization File

; Copyright (C) 1993-95 Preferred Systems Inc.
; All Rights Reserved

[System]

IniVersion="1.31"
DiscoverVersion="1.48"
DatabaseVersion="1.26"
DatabaseVersionFile="AWDB.VER"

Table Suffix=.DBF
Index Suffix=.CDX

;
;-----------------------------------------------------------------------------
;

; Table declarations for AuditWare tables

[TableNames]

BINDOBJ=
BOPROP=
BOVALUE=
DOMAIN=
DOMFSERV=
;FILEPACK=
;FSACBLOC=
;FSACRATE=
;FSACSERV=
FSCON=
;FSDIRVOL=
FSERVER=
FSVOL=
FSWGMAN=
GRP=
MANAGERS=
PDFORM=
PDFUNC=
PDMODE=
PQOPER=
PQUEUE=
PQUSER=
PRINTDEF=
PROFILE=
PROFSERV=
PROJECT=
PROJMEM=
PROMAN=
PROMEM=
PSERVER=
PSFSERV=
PSOPER=
PSP=
PSPNOTIF=
PSPQUE=
PSUSER=
TRUSTEE=
USER=
USERMEM=
USERPJOB=
USERSEC=
USERSTAT=
USERVOL=


[EndTableNames]


[BINDOBJ]
Object Name=All Other Bindery Objects
File Name=BINDOBJ.DBF
Description=Other Bindery Objects
Long Description=This table contains bindery objects that are not represented in other tables.

[BINDOBJ-Primary Key]
FID+OID=

[BINDOBJ-Alternate Keys]
FID+NAME=
OID=

[BINDOBJ-Fields]
FID=C,10,0,,File Server ID
OID=C,10,0,,Object ID
BOID=C,8,0,,Bindery Object ID
NAME=C,47,0,,Bindery Object Name
OTYPE=C,4,0,,Bindery Object Type
ISDYNAMIC=N,3,0,,Dynamic (1) or Static (0) 
HASVALUE=L,1,0,,Does this object have any values associated?
READFLAG=N,3,0,,Who can Read? (BitMask)
WRITEFLAG=N,3,0,,Who can Write? (BitMask)

;
;
;

[BOPROP]
Object Name=All Other Bindery Objects
File Name=BOPROP.DBF
Description=Other Bindery Objects Properties
Long Description=This table contains bindery object properties associated with 'Other Bindery Objects'.

[BOPROP-Primary Key]
OID=

[BOPROP-Alternate Keys]
OID=

[BOPROP-Fields]
FID=C,10,0,,File Server ID
OID=C,10,0,,Object ID    
PNAME=C,16,0,,Property Name
ISDYNAMIC=N,3,0,,Dynamic (1) or Static (0)
ISSET=N,3,0,,Set (1) or Item (0)
HASVALUE=L,1,0,,Does property have any values associated?
READFLAG=N,3,0,,Who can Read? (BitMask)
WRITEFLAG=N,3,0,,Who can Write? (BitMask)

;
;       
;

[BOVALUE]
Object Name=All Other Bindery Objects
File Name=BOVALUE.DBF
Description=Other Bindery Objects Properties Values
Long Description=This table contains actual values for bindery object properties.

[BOVALUE-Primary Key]
OID+PNAME=

[BOVALUE-Alternate Keys]
OID+PNAME=

[BOVALUE-Fields]
FID=C,10,0,,File Server ID
OID=C,10,0,,Object ID    
PNAME=C,16,0,,Property Name
ISSET=N,3,0,,Set (1) or Item (0)
STRTRAN=C,128,0,,String Translation of the Two Hex Values
HEX016=C,48,0,,Bytes 0 through 15 of data.
HEX032=C,48,0,,Bytes 16 through 31 of data.
HEX048=C,48,0,,Bytes 32 through 47 of data.
HEX064=C,48,0,,Bytes 48 through 63 of data.
HEX080=C,48,0,,Bytes 64 through 79 of data.
HEX096=C,48,0,,Bytes 80 through 95 of data.
HEX112=C,48,0,,Bytes 96 through 111 of data.
HEX128=C,48,0,,Bytes 112 through 127 of data.

;
;
;

[DOMAIN]
Object Name=Domain
File Name=DOMAIN.DBF
Description=Domain Table
Long Description=This table contains NetWare Names Service Domain information.

[DOMAIN-Primary Key]
FID+AID=

[DOMAIN-Alternate Keys]
FID+NAME=
AID=

[DOMAIN-Fields]
FID=C,10,0,,File Server ID
AID=C,10,0,,Domain ID
NAME=C,47,0,,Domain Name
SCRIPTID=M,10,0,,Domain Login Script

;
;
;

[DOMFSERV]
Object Name=Domain
File Name=DOMFSERV.DBF
Description=Domain File Servers
Long Description=This table contains a list of file servers associated with all Domains.

[DOMFSERV-Primary Key]
AID=

[DOMFSERV-Alternate Keys]
FID+FSNAME=

[DOMFSERV-Fields]
FID=C,10,0,,File Server ID
AID=C,10,0,,Domain ID
FSNAME=C,47,0,,File Server Name

;
;
;

[FILEPACK]
Object Name=Any Object
File Name=FILEPACK.DBF
Description=Compressed Header File
Long Description=This file contains information about files stored in the compressed file.

[FILEPACK-Primary Key]
FILEID=

[FILEPACK-Alternate Keys]
FID+OID=

[FILEPACK-Fields]
FID=C,10,0,,FileServerID
OTYPE=C,4,0,,Trustee Object Type
OID=C,10,0,,Trustee User or Group ID
FILEID=C,10,0,,File ID
VID=C,10,0,,Volume ID
PATH=C,254,0,,Trustee Directory or File Name
ATTRIBUTE=C,8,0,,File or Directory Attributes
FILE_TYPE=N,9,0,,Type of File (Ascii, Binary etc..)
NCOM_SIZE=N,19,0,,Non-Compressed Size
START_BYTE=N,19,0,,Starting Byte
FILE_SIZE=N,19,0,,Compressed Size
CDATE=D,8,0,,Creation Date
CTIME=N,6,0,,Creation Time

;
;
;

[FSACBLOC]
Object Name=File Server
File Name=FSACBLOC.DBF
Description=Accounting Blocks
Long Description=This table contains accounting configuration information.

[FSACBLOC-Primary Key]
FID+STR(ACTYPE)+DAY=

[FSACBLOC-Alternate Keys]
FID=


[FSACBLOC-Fields]
FID=C,10,0,,File Server ID
ACTYPE=N,9,0,,Account Type (Read, Write, Connect, Disk or Service)
DAY=C,1,0,,Day Sun-Sat (0-6)
INTERVAL=N,2,0,,Interval 1-48 (Half Hour Increments)
RATE_NUM=N,2,0,,Rate Number 1-20

;
;
;

[FSACRATE]
Object Name=File Server
File Name=FSACRATE.DBF
Description=Accounting Rates
Long Description=This table contains account rates.

[FSACRATE-Primary Key]
FID+ACTYPE+STR(RATE_NUM)=

[FSACRATE-Alternate Keys]
FID=

[FSACRATE-Fields]
FID=C,10,0,,File Server ID
ACTYPE=C,9,0,,Account Type (Read, Write, Connect, Disk or Service)
RATE_NUM=N,2,0,,Rate Number (1-20)
RATE_STR=C,20,0,,String that Represents the rate ratio
RATE_VAL=C,47,0,,Value of rate ratio

;
;
;

[FSACSERV]
Object Name=File Server
File Name=FSACSERV.DBF
Description=Accounting Servers Installed
Long Description=This table contains the list of servers that accounting is installed on.

[FSACSERV-Primary Key]
FID+SERVNAME=

[FSACSERV-Alternate Keys]
FID=

[FSACSERV-Fields]
FID=C,10,0,,File Server ID
OTYPE=C,4,0,,Server Type (File or Print Server)
SERVNAME=C,47,0,,File Server Name

;
;
;

[FSCON]
Object Name=File Server
File Name=FSCON.DBF
Description=File Server Console Operators
Long Description=This table contains the list of console operators for each file server.

[FSCON-Primary Key]
FID+OID=

[FSCON-Alternate Keys]
OID=

[FSCON-Fields]
FID=C,10,0,,File Server ID
OTYPE=C,4,0,,Operater Object Type
OID=C,10,0,,Operator Object ID
OPNAME=C,48,0,,Operator Name

;
;
;

[FSDIRVOL]
Object Name=File Server
File Name=FSDIRVOL.DBF
Description=Directory Volume Restrictions
Long Description=This table contains directory level volume restrictions.

[FSDIRVOL-Primary Key]
FID+VID+SUBSTR(PATH,1,100)=

[FSDIRVOL-Alternate Keys]
FID

[FSDIRVOL-Fields]
FID=C,10,0,,File Server ID
VID=C,10,0,,Volume ID
PATH=C,255,0,,Directory Name
LIMIT=N,19,0,,Volume Limit in KBytes(0 if Unlimited)
CURSPACE=N,19,0,,Current Space Avaiable in KBytes 

;
;
;

[FSERVER]
Object Name=File Server
File Name=FSERVER.DBF
Description=File Server Information
Long Description=This table contains general file server information.

[FSERVER-Primary Key]
FID=

[FSERVER-Alternate Keys]
NAME=

[FSERVER-Fields]
FID=C,10,0,,File Server ID
NAME=C,47,0,,File Server Name
DISDATE=D,8,0,,Date of File Server Discover
DISTIME=N,16,10,,Time of File Server Discover
OS=C,128,0,,OS Full Name
OSNUM=C,10,0,,OS Version Number
OSREVDATE=C,23,0,,OS Revision Date
SFT=N,3,0,,System Fault Tolerance Level
TTS=L,1,0,,Transaction Tracking Installed
CONSPT=N,9,0,,Number of Connections Supported
VOLSPT=N,9,0,,Number of Volume Supported
NETADD=C,21,0,,Server Network Address
SERNUM=C,10,0,,OS Seriel Number
ACCT=L,1,0,,Accounting Installed
NNS=L,1,0,,NetWare Name Services Installed
SCRIPTID=M,10,0,,System Login Script ID
NCFID=M,10,0,,System Autoexec Script ID
ACCDATE=D,8,0,,Account Expiration Date (Empty for None)
MAXCON=N,9,0,,Maximum Connections   (0 for Unlimited)
CRTHOME=L,1,0,,Create Home Directories
HOMEPATH=C,255,0,,Default Home Path
PSWREQ=L,1,0,,Password Required
PSWMINLEN=N,9,0,,Min Password Len
PSWFORCEC=L,1,0,,Force Periodic Change?
PSWCHDAYS=N,9,0,,Days Between Forced Changes
PSWGRACE=N,9,0,,Number of Grace Logins  (0 for No Limit)
PSWUNIQUE=L,1,0,,Unique Password Required?
ACCBAL=N,9,0,,Account Balance
ACCLIMIT=N,9,0,,Account Credit Lower Limit (0 for Unlimited)
TIMESUN=C,48,0,,Time Restrictions (SUN) 0-None 1-Rest
TIMEMON=C,48,0,,Time Restrictions (MON) 0-None 1-Rest
TIMETUE=C,48,0,,Time Restrictions (TUE) 0-None 1-Rest
TIMEWED=C,48,0,,Time Restrictions (WED) 0-None 1-Rest
TIMETHR=C,48,0,,Time Restrictions (THR) 0-None 1-Rest
TIMEFRI=C,48,0,,Time Restrictions (FRI) 0-None 1-Rest
TIMESAT=C,48,0,,Time Restrictions (SAT) 0-None 1-Rest
LOGATT=N,9,0,,Incorrect Login Attempts (0 for No Lockout)
LOGRETD=N,9,0,,Bad Login Retention Time Days
LOGRETH=N,9,0,,Bad Login Retention Time Hours
LOGRETM=N,9,0,,Bad Login Retention Time Minutes
LOCKLEND=N,9,0,,Length of Account Lockout Days    (0 for None)
LOCKLENH=N,9,0,,Length of Account Lockout Hours   (0 for None)
LOCKLENM=N,9,0,,Length of Account Lockout Minutes (0 for None)                                
MAXSPACE=N,19,0,,Maximimum Space (2.2 Only)
SECURED=L,1,0,,Is File Server Console Secured?

;
;
;

[FSVOL]
Object Name=File Server
File Name=FSVOL.DBF
Description=Volume Information
Long Description=This table contains information about each file server volume.

[FSVOL-Primary Key]
FID+VID=

[FSVOL-Alternate Keys]
FID+NAME=
VID=

[FSVOL-Fields]
FID=C,10,0,,File Server ID
VID=C,10,0,,Volume ID
NAME=C,47,0,,Volume Name
SECTORSIZE=N,19,0,,Number of bytes per sector
TOTBLOCKS=N,19,0,,Number of blocks on volume
SECTBLOCK=N,19,0,,Number of sectors per block
FREEBLOCKS=N,19,0,,Number of unused blocks on volume
TOTDIRENT=N,19,0,,Number of directory entries supported on volume
FREEDIRENT=N,19,0,,Number of directory entries available on volume
TOTSIZEK=N,19,0,,Total size of volume in KBytes
FREESIZEK=N,19,0,,Amount of space available in KBytes
USEDSIZEK=N,19,0,,Amount of space consumed in KBytes
REMOVABLE=L,1,0,,Is volume removable?

;
;
;

[FSWGMAN]
Object Name=File Server
File Name=FSWGMAN.DBF
Description=Work Group Operators
Long Description=This table contains workgroup managers.

[FSWGMAN-Primary Key]
FID+OID=

[FSWGMAN-Alternate Keys]
OID=

[FSWGMAN-Fields]
FID=C,10,0,,File Server ID
OTYPE=C,4,0,,Work Group Manager Object Type
OID=C,10,0,,Operator Object ID

;
;
;

[GRP]
Object Name=Group
File Name=GRP.DBF
Description=Group Information
Long Description=This table contains the list of groups for each file server.

[GRP-Primary Key]
FID+GID=

[GRP-Alternate Keys]
FID+NAME=
GID=

[GRP-Fields]
FID=C,10,0,,FileServerID
GID=C,10,0,,Group ID
BOID=C,8,0,,Bindery Object ID
NID=C,10,0,,Default Profile ID
NAME=C,47,0,,Group Name
FULLNAME=C,128,0,,Full Name of Group

;
;
;

[MANAGERS]
Object Name=User/Group
File Name=MANAGERS.DBF
Description=Object Managers
Long Description=This table contains managed users and groups.

[MANAGERS-Primary Key]
FID+MNGRID=

[MANAGERS-Alternate Keys]
FID+OID=
OID+MNGRID=
MNGRID+OID=

[MANAGERS-Fields]
FID=C,10,0,,FileServerID (generated)
MNGRTYPE=C,4,0,,Managers Type (i.e Group User etc.)
MNGRID=C,10,0,,Managers ID 
OTYPE=C,4,0,,Managed Objects Type (i.e Group User etc.)
OID=C,10,0,,Managed Objects ID

;
;
;

[PDFORM]
Object Name=File Server
File Name=PDFORM.DBF
Description=NET$PRN Printer Forms
Long Description=This table contains system print form definitions (NET$PRN.DAT).

[PDFORM-Primary Key]
FID=

[PDFORM-Alternate Keys]
FID=

[PDFORM-Fields]
FID=C,10,0,,File Server ID
RID=C,10,0,,FORM ID
NAME=C,31,0,,FORM Name
NUMBER=N,9,0,,FORM Number
LENGTH=N,9,0,,FORM Length
WIDTH=N,9,0,,FORM Width

;
;
;

[PDFUNC]
Object Name=File Server
File Name=PDFUNC.DBF
Description=NET$PRN Printer Devices Functions
Long Description=This table contains the control strings for all system printer definitions.

[PDFUNC-Primary Key]
ZID=

[PDFUNC-Alternate Keys]
ZID=

[PDFUNC-Fields]
FID=C,10,0,,File Server ID
ZID=C,10,0,,Device ID
NAME=C,31,0,,Printer Function Name
ESCSEQ=C,254,0,,Printer Function Escape Sequence

;
;
;

[PDMODE]
Object Name=File Server
File Name=PDMODE.DBF
Description=NET$PRN Printer Devices Modes
Long Description=This table contain system printer mode definitions.

[PDMODE-Primary Key]
ZID=

[PDMODE-Alternate Keys]
ZID=

[PDMODE-Fields]
FID=C,10,0,,File Server ID
ZID=C,10,0,,Device ID
MID=C,10,0,,Mode ID
NAME=C,31,0,,Printer Device Mode Name

;
;
;

[PQOPER]
Object Name=Print Queues
File Name=PQOPER.DBF
Description=Print Queue Operators
Long Description=This table contains the list of print queue operators.

[PQOPER-Primary Key]
QID+OID=

[PQOPER-Alternate Keys]
OID+QID=

[PQOPER-Fields]
FID=C,10,0,,FileServerID
QID=C,10,0,,Print Queue ID
OTYPE=C,4,0,,Print Queue Operator Object Type
OID=C,10,0,,Print Queue Operator ID

;
;
;

[PQUEUE]
Object Name=Print Queues
File Name=PQUEUE.DBF
Description=Print Que Definition File
Long Description=This table contains print queue definitions.

[PQUEUE-Primary Key]
FID+QID=


[PQUEUE-Alternate Keys]
FID+NAME=
QID=

[PQUEUE-Fields]
FID=C,10,0,,File ServerID (generated)
QID=C,10,0,,Print Queue ID
BOID=C,8,0,,Bindery Object ID
NAME=C,47,0,,Print Queue Name
FULLNAME=C,129,0,,Full Name
USERENT=L,1,0,,Can users place entries in the queue?
SERVENT=L,1,0,,Can servers service entries in the queue?
ATTACHQ=L,1,0,,Can new servers attach to the queue?

;
;
;

[PQUSER]
Object Name=Print Queues
File Name=PQUSER.DBF
Description=Print Queue Users
Long Description=This table contains a list of users and groups who can use print queues.

[PQUSER-Primary Key]
QID+OID=

[PQUSER-Alternate Keys]
OID+QID=

[PQUSER-Fields]
FID=C,10,0,,File ServerID
QID=C,10,0,,Print Queue ID
OTYPE=C,4,0,,Print Queue Member Object Type
OID=C,10,0,,Print Queue Member ID

;
;
;

[PRINTDEF]
Object Name=File Server
File Name=PRINTDEF.DBF
Description=NET$PRN Printer Devices
Long Description=This table contains system printer device definitions.

[PRINTDEF-Primary Key]
FID=

[PRINTDEF-Alternate Keys]
FID=

[PRINTDEF-Fields]
FID=C,10,0,,File Server ID
ZID=C,10,0,,Device ID
NAME=C,31,0,,Printer Device Name

;
;
;

[PROFILE]
Object Name=Profile
File Name=PROFILE.DBF
Description=Profile Table
Long Description=This table contains NNS profile information.

[PROFILE-Primary Key]
FID+NID=

[PROFILE-Alternate Keys]
NID=

[PROFILE-Fields]
FID=C,10,0,,File Server ID
NID=C,10,0,,Profile ID
BOID=C,8,0,,Bindery Object ID
NAME=C,47,0,,Profile Name
FULLNAME=C,128,0,,Full Name of Object
SCRIPTID=M,10,0,,Profile Script

;
;
;

[PROFSERV]
Object Name=Profile
File Name=PROFSERV.DBF
Description=Profile File Servers
Long Description=This table contains a list of file servers associated with each NNS profile.

[PROFSERV-Primary Key]
NID=

[PROFSERV-Alternate Keys]
NID=

[PROFSERV-Fields]
FID=C,10,0,,File Server ID
NID=C,10,0,,Domain ID
FSNAME=C,47,0,,File Server Name

;
;
;

[PROJECT]
Object Name=Project
File Name=PROJECT.DBF
Description=Project Information
Long Description=This table describes each AuditWare project.

[PROJECT-Primary Key]
PROJID=

[PROJECT-Alternate Keys]
NAME=

[PROJECT-Fields]
PROJID=C,10,0,,Project ID
NAME=C,30,0,,Project Name
COMPANY=C,30,0,,Project Company
AUTHOR=C,30,0,,Project Author
COMMENT=C,254,0,,Comment
VIEW=N,1,0,,View Number
SORTBY=N,1,0,,Sort By Parameter
ORDER=N,1,0,,Order By

;
;
;

[PROJMEM]
Object Name=Project
File Name=PROJMEM.DBF
Description=Project Members
Long Description=This table contains a list of all file server id's for each project.

[PROJMEM-Primary Key]
PROJID=

[PROJMEM-Alternate Keys]
FID=

[PROJMEM-Fields]
PROJID=C,10,0,,Project ID
FID=C,10,0,,File Server ID

;
;
;

[PROMAN]
Object Name=Profile
File Name=PROMAN.DBF
Description=Profile Managers
Long Description=This table contains the list of managers for each NNS profile.

[PROMAN-Primary Key]
NID+OID=

[PROMAN-Alternate Keys]
OID+NID=

[PROMAN-Fields]
FID=C,10,0,,File Server ID
NID=C,10,0,,Domain ID
OTYPE=C,4,0,,Profile Manager Type
OID=C,10,0,,Operator Object ID

;
;
;

[PROMEM]
Object Name=Profile
File Name=PROMEM.DBF
Description=Profile Members
Long Description=This table contains the list of users and groups in each NNS profile.

[PROMEM-Primary Key]
NID+OID=

[PROMEM-Alternate Keys]
OID+NID=

[PROMEM-Fields]
FID=C,10,0,,File Server ID
NID=C,10,0,,Domain ID
OTYPE=C,4,0,,Profile Member Type (User or Group)
OID=C,10,0,,Object ID

;
;
;

[PSERVER]
Object Name=Print Server
File Name=PSERVER.DBF
Description=Print Server Definition
Long Description=This table contains definitions for all print servers.

[PSERVER-Primary Key]
FID+PID=

[PSERVER-Alternate Keys]
FID+NAME=
PID=

[PSERVER-Fields]
FID=C,10,0,,File Server ID
PID=C,10,0,,Print Server ID
BOID=C,8,0,,Bindery Object ID
NAME=C,47,0,,Print Server Name
FULLNAME=C,128,0,,Full Name of Object

;
;
;

[PSFSERV]
Object Name=Print Servers
File Name=PSFSERV.DBF
Description=Print Server File Servers Serviced
Long Description=This table specifies which file servers service print servers.

[PSFSERV-Primary Key]
PID=

[PSFSERV-Alternate Keys]
PID=

[PSFSERV-Fields]
FID=C,10,0,,FileServerID
PID=C,10,0,,Print Server ID
FSNAME=C,47,0,,File Server Name

;
;
;

[PSOPER]
Object Name=Print Servers
File Name=PSOPER.DBF
Description=Print Server Operators
Long Description=This table contains the list of operators for all print servers.

[PSOPER-Primary Key]
PID+OID=

[PSOPER-Alternate Keys]
OID+PID=

[PSOPER-Fields]
FID=C,10,0,,FileServerID
PID=C,10,0,,Print Server ID
OTYPE=C,4,0,,Print Server Operator Object Type
OID=C,10,0,,Print Server Operator ID
OPNAME=C,48,0,,Operator Name

;
;
;

[PSP]
Object Name=Print Servers
File Name=PSP.DBF
Description=Print Server Printer Definitions
Long Description=This table contains definitions for all printers associated with print servers.

[PSP-Primary Key]
PID=

[PSP-Alternate Keys]
PID+UPPER(NAME)=

[PSP-Fields]
FID=C,10,0,,FileServerID
PID=C,10,0,,Print Server ID
DID=N,2,0,,Printer Number (0-15)
NAME=C,47,0,,Printer Name
PRTTYPE=N,3,0,,Printer Type
INT=L,1,0,,Use Interupts
IRQ=N,3,0,,IRQ Level (3-7 Inclusive)
BUFFERK=N,3,0,,Buffer in K Size (1-20 Inclusize)
STARTFORM=N,3,0,,Starting Form (0-255 Inclusive)
QMODETYPE=N,3,0,,Que Service mode type
BAUD=N,3,0,,Baud Rate
DATA=N,3,0,,Data Bits (5-8 Inclusive)
STOP=N,3,0,,Stop Bits
PARITY=N,3,0,,Pararity
XON=L,1,0,,Xon or Xoff

;
;
;

[PSPNOTIF]
Object Name=Print Servers
File Name=PSPNOTIF.DBF
Description=Print Server Printer Definition Notify List
Long Description=This table contains the notification list (user and groups) for all print servers.

[Indexes34]

[PSPNOTIF-Primary Key]
PID+LTRIM(STR(DID))=

[PSPNOTIF-Alternate Keys]
OID=

[PSPNOTIF-Fields]
FID=C,10,0,,FileServerID (generated)
PID=C,10,0,,Print Server ID
DID=N,2,0,,Printer Number (0-15)
OTYPE=C,4,0,,Print Server Operator Object Type
OID=C,10,0,,Print Server Operator ID
FIRST=N,4,0,,First Interval (Seconds)
NEXT=N,4,0,,Next Interval (Seconds)

;
;
;

[PSPQUE]
Object Name=Print Servers
File Name=PSPQUE.DBF
Description=Print Server Printer Que List
Long Description=This table contains the list of print queues associated with each print server.

[PSPQUE-Primary Key]
PID+LTRIM(STR(DID))+QID=

[PSPQUE-Alternate Keys]
QID=
QID+PID+LTRIM(STR(DID))=
PID=

[PSPQUE-Fields]
FID=C,10,0,,File ServerID
PID=C,10,0,,Print Server ID
DID=N,2,0,,Printer Number (0-15)
QID=C,10,0,,Print QueueID
PQPRIOR=N,9,0,,Print Q Priority  (1-10)

;
;
;

[PSUSER]
Object Name=Print Servers
File Name=PSUSER.DBF
Description=Print Server Users
Long Description=This table contains the list of users and groups for all print servers.

[PSUSER-Primary Key]
PID+OID=

[PSUSER-Alternate Keys]
OID+PID=

[PSUSER-Fields]
FID=C,10,0,,FileServerID
PID=C,10,0,,Print Server ID
OTYPE=C,4,0,,Print Server Member Object Type
OID=C,10,0,,Print Server Member ID

;
;
;

[TRUSTEE]
Object Name=User, Group
File Name=TRUSTEE.DBF
Description=User/Group Trustee File
Long Description=This table contains trustee assignments for all users and groups.

[TRUSTEE-Primary Key]
OID=

[TRUSTEE-Alternate Keys]
FID=

[TRUSTEE-Fields]
FID=C,10,0,,FileServerID
OTYPE=C,4,0,,Trustee Object Type
OID=C,10,0,,Trustee User or Group
VID=C,10,0,,Volume ID
DIRORFILE=C,1,0,,Directory (D) or File (F)
PATH=C,254,0,,Trustee Directory or File Name
OWNERTYPE=C,4,0,,Owner Object Type
OWNERID=C,10,0,,ID of The Owner
RIGHT_MASK=C,8,0,,Rights Mask
ATTRIBUTE=C,24,0,,File or Directory Attributes
CDATE=D,8,0,,Creation Date
CTIME=N,6,0,,Creation Time

;
;
;

[USER]
Object Name=User
File Name=USER.DBF
Description=User Definition Table
Long Description=This table contains information for all users on all file servers.

[USER-Primary Key]
FID+UID=


[USER-Alternate Keys]
FID+NAME=
UID=

[USER-Fields]
FID=C,10,0,,File Server ID
UID=C,10,0,,User ID
BOID=C,8,0,,Bindery Object ID
NID=C,10,0,,Default Profile ID
NAME=C,47,0,,User Name
FULLNAME=C,128,0,,Full Name of Object
SCRIPTID=M,10,0,,Object Login Script File
HASSCRPT=L,1,0,,Does the user have a Login Script
OS2SCRPT=M,10,0,,OS/2 Login Script
HASOS2=L,1,0,,Does the user have a Login Script for OS/2
ACCBAL=N,9,0,,Account Balance
ACCLIMIT=N,9,0,,Account Credit Lower Limit (0 for Unlimited)
ACCDIS=L,1,0,,Account Disabled User's Only
ACCDATE=D,10,0,,Account Expiration Date  (Empty for no date)
MAXCON=N,9,0,,Maximum Connections   (0 for Unlimited)
HASPSW=L,1,0,,Does user have a password?
PSWALLOW=L,1,0,,Allow User To Change Password (User Only)
PSWREQ=L,1,0,,Password Required
PSWMINLEN=N,9,0,,Min Password Len
PSWFORCEC=L,1,0,,Force Periodic Change?
PSWCHDAYS=N,9,0,,Days Between Forced Changes
PSWEXP=D,8,0,,Date Password Expires (User Only)
PSWGRACE=N,9,0,,Number of Grace Logins  (0 for No Limit)
PSWGRACER=N,9,0,,Number of Grace Logins Left (User Only)
PSWUNIQUE=L,1,0,,Unique Password Required?
ACLOCK=L,1,0,,Account Locked?
BADLOG=N,9,0,,Incorrect Logins
ACRSTTM=N,9,0,,Account reset Time
TMUNTIL=N,9,0,,Time Until Reset
INTADD=C,24,0,,Last Intruder Address
LSTLOGDATE=D,8,0,,Last Login Date
LSTLOGTIME=N,6,0,,Last Login Time
TIMESUN=C,48,0,,Time Restrictions (SUN) 0-None 1-Rest
TIMEMON=C,48,0,,Time Restrictions (MON) 0-None 1-Rest
TIMETUE=C,48,0,,Time Restrictions (TUE) 0-None 1-Rest
TIMEWED=C,48,0,,Time Restrictions (WED) 0-None 1-Rest
TIMETHR=C,48,0,,Time Restrictions (THR) 0-None 1-Rest
TIMEFRI=C,48,0,,Time Restrictions (FRI) 0-None 1-Rest
TIMESAT=C,48,0,,Time Restrictions (SAT) 0-None 1-Rest
SUPEREQ=L,1,0,,Is User Supervisor Equivalent?

;
;
;

[USERMEM]
Object Name=User
File Name=USERMEM.DBF
Description=User Group Memberships
Long Description=This table contains the list of group/user relationships.

[USERMEM-Primary Key]
UID+GID=

[USERMEM-Alternate Keys]
GID+UID=

[USERMEM-Fields]
FID=C,10,0,,File ServerID
UID=C,10,0,,User ID
GID=C,10,0,,Group ID

;
;
;

[USERPJOB]
Object Name=User
File Name=USERPJOB.DBF
Description=User Printer Job Configrations
Long Description=This table contains the list of user print job configurations.

[USERPJOB-Primary Key]
UID=

[USERPJOB-Alternate Keys]
FID+UID=

[USERPJOB-Fields]
FID=C,10,0,,File ServerID
UID=C,10,0,,User ID
JOBNAME=C,31,0,,PrintCon JOB Name
NUMCOPY=N,9,0,,Number of Copies (1-6500)
DATATYPE=N,3,0,,Byte Stream (0,1) File
TABSIZE=N,3,0,,Tab Size (1-18)
SUPRESSFF=L,1,0,,Supress Form (Yes/No)
NOTIFY=L,1,0,,Notify When Done (Yes/No)
LOCALPRN=N,3,0,,Local Prn LPT(1-3)
AUTOCAP=L,1,0,,AutoEndCap (Yes/No)
FSERVER=C,47,0,,File Server Name
QUEUE=C,47,0,,Print Queue Name
PID=C,10,0,,Print Server ID
DEVICE=C,47,0,,Device Name
MODE=C,47,0,,Mode Name
FORM=C,47,0,,Form Name
PRTBANNER=L,1,0,,Print Banner
USER_NAME=C,12,0,,User Banner Name
BANNER=C,12,0,,Banner Name (Blank For File Name)
TIMEOUT=N,9,0,,Printer Time Out (1-1000)
DEFAULT=L,1,0,,Is the the Default Print Job?

;
;
;

[USERSEC]
Object Name=User
File Name=USERSEC.DBF
Description=Security Equivalences
Long Description=This table contains the list of security equivalences for all users.

[USERSEC-Primary Key]
UID+OID=

[USERSEC-Alternate Keys]
OID+UID=

[USERSEC-Fields]
FID=C,10,0,,FileServerID
UID=C,10,0,,User ID
OTYPE=C,4,0,,Security Equivalent Object Type
OID=C,10,0,,Security Equivalent User or Group

;
;
;

[USERSTAT]
Object Name=User
File Name=USERSTAT.DBF
Description=User Station Restrictions
Long Description=This table contains the list of workstation restrictions for all users.

[USERSTAT-Primary Key]
OID=

[USERSTAT-Alternate Keys]
OID=

[USERSTAT-Fields]
FID=C,10,0,,File Server ID
OID=C,10,0,,Operator Object ID
NETADD=C,9,0,,Network Adress
NODEADD=C,13,0,,Node Adress

;
;
;

[USERVOL]
Object Name=User
File Name=USERVOL.DBF
Description=User Volume Restrictions
Long Description=This table contains the list of volume restrictions for all users having a restriction.

[USERVOL-Primary Key]
UID+VID=

[USERVOL-Alternate Keys]
VID+UID=
FID=

[USERVOL-Fields]
FID=C,10,0,,FileServerID
UID=C,10,0,,User ID
VID=C,10,0,,Volume ID
LIMIT=N,19,0,,Volume Limit  (0 If no Limit)
INUSE=N,19,0,,Amount In Use


;
;
; End of file.
