-- NLS ASN1 Schema Definitions
-- Novell Inc.
-- 122 East 1700 South
-- Provo, UT 84606-6194

-- Object ID Syntax
------------------------------------------
------------------------------------------
-- ASN1 Object ID's Defined as Follows:
--     joint-iso-ccitt(2) country(16) us(840) organization(1)
--     Novell(113719) 
------------------------------------------


NLSSchemaExtentions DEFINITIONS ::=
BEGIN


-- New Attributes
------------------------------------------
------------------------------------------

"Publisher" ATTRIBUTE ::=
{
  SyntaxID    SYN_CE_STRING,
  Flags       {DS_SINGLE_VALUED_ATTR},
  ASN1ObjID   {0 0 0 0 0 0 0 0 0 0}
}

"Product" ATTRIBUTE ::=
{
  SyntaxID    SYN_CE_STRING,
  Flags       {DS_SINGLE_VALUED_ATTR},
  ASN1ObjID   {0 0 0 0 0 0 0 0 0 0}
}

"LicenseID" ATTRIBUTE ::=
{
  SyntaxID    SYN_CE_STRING,
  Flags       {DS_SINGLE_VALUED_ATTR},
  ASN1ObjID   {0 0 0 0 0 0 0 0 0 0}
}

"CommonCertificate" ATTRIBUTE ::=
{
  SyntaxID    SYN_OCTET_STRING,
  ASN1ObjID   {0 0 0 0 0 0 0 0 0 0}
}

"License Database" ATTRIBUTE ::=
{
  SyntaxID    SYN_BOOLEAN,
  Flags       {DS_SINGLE_VALUED_ATTR},
  ASN1ObjID   {0 0 0 0 0 0 0 0 0 0}
}

"Transaction Database" ATTRIBUTE ::=
{
  SyntaxID    SYN_BOOLEAN,
  Flags       {DS_SINGLE_VALUED_ATTR},
  ASN1ObjID   {0 0 0 0 0 0 0 0 0 0}
}

-- New Classes
------------------------------------------
------------------------------------------

"NLSProduct" OBJECT-CLASS ::=
{
  Flags       {DS_CONTAINER_CLASS, DS_EFFECTIVE_CLASS},
  SubClassOf  {"TOP"},
  ContainedBy {"Organizational Unit", "Organization"},
  NamedBy     {"Publisher", "Product", "Version"},
  MustContain {"Publisher", "Product", "Version"},
  ASN1ObjID   {0 0 0 0 0 0 0 0 0 0}
}

"NLSLicenseCertificate" OBJECT-CLASS ::=
{
  SubClassOf  {"TOP"},
  Flags       {DS_EFFECTIVE_CLASS},
  ContainedBy {"NLSProduct"},
  NamedBy     {"LicenseID"},
  MustContain {"LicenseID", "CommonCertificate"},
  MayContain  {"Owner"},
  ASN1ObjID   {0 0 0 0 0 0 0 0 0 0}
}

"NLS License Server" OBJECT-CLASS ::=
{
  SubClassOf  {"Server"},
  Flags       {DS_EFFECTIVE_CLASS},
  MustContain {"License Database", "Transaction Database", "Host Server"},
  ASN1ObjID   {0 0 0 0 0 0 0 0 0 0}
}

-- Modification of Existing Classes
------------------------------------------
------------------------------------------

END
