--
-- NetWare Directory Service Schema Extensions for NetWare Audit
--
-- Copyright 1996 by Novell, Inc.  All rights reserved.
--

AuditSchemaExtensions {2 16 840 1 113719 1 12} DEFINITIONS ::=
BEGIN

"Audit:A Encryption Key" ATTRIBUTE ::=
{
   Operation            ADD,
   Flags                {DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
   SyntaxID             SYN_OCTET_STRING,
   LowerBound           0,
   UpperBound           0,
   ASN1ObjID            {2 16 840 1 113719 1 12 4 1 0}
}

"Audit:B Encryption Key" ATTRIBUTE ::=
{
   Operation            ADD,
   Flags                {DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
   SyntaxID             SYN_OCTET_STRING,
   LowerBound           0,
   UpperBound           0,
   ASN1ObjID            {2 16 840 1 113719 1 12 4 2 0}
}

"Audit:Contents" ATTRIBUTE ::=
{
   Operation            ADD,
   Flags                {DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
   SyntaxID             SYN_INTEGER,
   LowerBound           0,
   UpperBound           0,
   ASN1ObjID            {2 16 840 1 113719 1 12 4 3 0}
}

"Audit:Type" ATTRIBUTE ::=
{
   Operation            ADD,
   Flags                {DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
   SyntaxID             SYN_INTEGER,
   LowerBound           0,
   UpperBound           0,
   ASN1ObjID            {2 16 840 1 113719 1 12 4 4 0}
}

"Audit:Current Encryption Key" ATTRIBUTE ::=
{
   Operation            ADD,
   Flags                {DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
   SyntaxID             SYN_OCTET_STRING,
   LowerBound           0,
   UpperBound           0,
   ASN1ObjID            {2 16 840 1 113719 1 12 4 5 0}
}

"Audit:File Link" ATTRIBUTE ::=
{
   Operation            ADD,
   Flags                {DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
   SyntaxID             SYN_DIST_NAME,
   LowerBound           0,
   UpperBound           0,
   ASN1ObjID            {2 16 840 1 113719 1 12 4 6 0}
}

"Audit:Link List" ATTRIBUTE ::=
{
   Operation            ADD,
   Flags                {DS_SYNC_IMMEDIATE},    -- MULTI-VALUED --
   SyntaxID             SYN_DIST_NAME,
   LowerBound           0,
   UpperBound           0,
   ASN1ObjID            {2 16 840 1 113719 1 12 4 7 0}
}

"Audit:Path" ATTRIBUTE ::=
{
   Operation            ADD,
   Flags                {DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
   SyntaxID             SYN_PATH,
   LowerBound           0,
   UpperBound           0,
   ASN1ObjID            {2 16 840 1 113719 1 12 4 8 0}
}

"Audit:Policy" ATTRIBUTE ::=
{
   Operation            ADD,
   Flags                {DS_SYNC_IMMEDIATE, DS_SINGLE_VALUED_ATTR},
   SyntaxID             SYN_OCTET_STRING,
   LowerBound           0,
   UpperBound           0,
   ASN1ObjID            {2 16 840 1 113719 1 12 4 9 0}
}


"Audit:File Object" OBJECT-CLASS ::=
{
   Operation            ADD,
   Flags                {DS_EFFECTIVE_CLASS},
   SubClassOf           {"Top"},
   ContainedBy          {  "Top", 
                           "Country", 
                           "Locality", 
                           "Organization",
                           "Organizational Unit"
                        },
   NamedBy              {"CN"},
   MustContain          {"CN", "Audit:Policy", "Audit:Contents"},
   MayContain           {
                           "Description", 
                           "Audit:Path", 
                           "Audit:Link List", 
                           "Audit:Type", 
                           "Audit:Current Encryption Key", 
                           "Audit:A Encryption Key", 
                           "Audit:B Encryption Key"
                        },
   ASN1ObjID            {2 16 840 1 113719 1 12 6 1 0}
}

"Top" OBJECT-CLASS ::=
{
   Operation            MODIFY,
   Flags                {DS_EFFECTIVE_CLASS},
   MayContain           {"Audit:File Link"}
}

END

