' (C) Copyright 1993-1996 HITECSOFT CORP. All rights reserved.
'
' -------------------------------------------------------------------
' This Pogram will Scan and print the directory
' Format: DIR [Path][/W][/P]
' PATH = Directory Path to view
' /W   = Print directory in wide format
' /P   = Stops at the end of each screen
' -------------------------------------------------------------------

Sub CheckPage
'--------------------------------------------------------------------
' This Procedure will check if the end of the screen has been
' reached, prints a prompt, and waits for a key stroke.
'--------------------------------------------------------------------

If (i >= 23)
   Print("Press any key to continue ....",DATA:Char(13))
   KEY:Read()
   Print("                               ",DATA:Char(13))
   i = 1
EndIf
i = i + 1

End Sub

Sub DoStdDir
'--------------------------------------------------------------------
' This Procedure will scan all files for specified path
' and then prints one at a time with the size and date
'--------------------------------------------------------------------

DirObject = DIR:File:First(dirpar)

Do While (DirObject.ERROR = 0)
   If (DirObject.type = "FILE")
      NumberOfFiles = NumberOfFiles + 1
      SizeOfFiles = SizeOfFiles + DATA:Integer(DirObject.Size)
      Print(STR:Pad:Right(DirObject.name,8)," ",STR:Pad:Right(DirObject.extension,3)," ",STR:Pad:Left(DATA:String(DirObject.size),9)," ",DirObject.date,"  ",DirObject.time)
   Else
      NumberOfDir = NumberOfDir + 1
      Print(STR:Pad:Right(DirObject.name,8)," ",STR:Pad:Right(DirObject.extension,3)," ","<DIR>","     ",DirObject.date,"  ",DirObject.time)
   EndIf
   NewLine

   If (DirPage = "/P")
      CheckPage
   EndIf

   DirObject = DIR:File:Next(DirObject)
EndDo

End Sub

Sub DoWideDir
'--------------------------------------------------------------------
'This Procedure will scan all files for specified path
'and then prints them in the wide format
'--------------------------------------------------------------------


DirObject = DIR:File:First(dirpar)
Do While (DirObject.ERROR = 0)
   If (DirObject.extension != "")
      dot = "."
   Else
      dot = ""
   EndIf
   If (DirObject.type = "FILE")
      NumberOfFiles = NumberOfFiles + 1
      SizeOfFiles = SizeOfFiles + DATA:Integer(DirObject.Size)
      TempStr = DirObject.name + dot + DirObject.extension
   Else
      NumberOfDir = NumberOfDir + 1
      TempStr = "[" + DirObject.name + dot + DirObject.extension + "]"
   EndIf
   TempStr = STR:Pad:Right(TempStr,16)
   Print(TempStr)
   DirObject = DIR:File:Next(DirObject)
EndDo
NewLine

End Sub

Sub main

dirpar="*.*"       ;' Directory Pattern
dirwide=""         ;' Directory Format
dirpage=""         ;' Page Prompt
NumberOfFiles=0    ;' Number of files found
NumberOfDir=0      ;' Number of Directories found
SizeOfFiles=0      ;' Total Size of all Files
i=0                ;' Line Counter used for Page Format
'--------------------------------------------------------------------
' if there is more than one parameter, Scan them
'--------------------------------------------------------------------
If (SYS:Param:Count > 1)
   i = 2
   Do While (i <= SYS:Param:Count)
      If ((SYS:Param(i) = "/W") | (SYS:Param(i) = "/w"))
         dirwide = "/W"
      EndIf
      If ((SYS:Param(i) = "/P") | (SYS:Param(i) = "/p"))
         dirpage = "/P"
      EndIf
      If ((SYS:Param(i) != "/W") & (SYS:Param(i) != "/w") & (SYS:Param(i) != "/P") & (SYS:Param(i) != "/p"))
         dirpar = SYS:Param(i)
      EndIf
      i = i + 1
   EndDo
EndIf
'--------------------------------------------------------------------
' Parse The User Input into its components
'--------------------------------------------------------------------
dirparO = DIR:Object(dirpar)
If (dirparO.error != 0)
   Print("Error (",dirparO.error,") has occurred");Newline
   quit
Endif
'--------------------------------------------------------------------
' Make a full path from parsed information
'--------------------------------------------------------------------
dirpar = dirparO.volume.name + dirparO.path + dirparO.file.name + "." + dirparO.File.Extension
Print("Directory of ",Dirpar)
NewLine
'--------------------------------------------------------------------
' IF /W is set then run wide dir --- else run standard dir
'--------------------------------------------------------------------
If (dirwide = "/W")
   DoWideDir
Else
   DoStdDir
EndIf
Print("   ",NumberOfDir," Dir(s).    ",NumberOfFiles," File(s).    ",SizeOfFiles," Bytes Used.")
NewLine
NewLine
Return


End Sub


