'[PROCEDURE]
'Purpose - Displays a menu window with two selections ( Yes and No).
'[PARAM1]
'Purpose - Title of menu window, can be up to 74 characters long
'Type    - String
'Default - "Exit?"
'[PARAM2]
'Purpose - The default menu selection.
'Type    - String
'Default - True
'[RETURN]
'Purpose - Returns a boolean TRUE for Yes, or FALSE for No
'Type    - Boolean
'[EXAMPLE]
'Do While (TRUE)
'   If (RPC:Call("","YESNO.BAS","Exit Program?"))
'      Quit
'   EndIf
'EndDo

#include "KEY.H"
Local("Msg","MsgLen","Answer","Title")

If (MATH:Mod(STR:Length(Param(1,"Exit?")),2) != 0) & (STR:Length(Param(1,"Exit?")) < 74)
   Msg = " " + Param(1,"Exit?")
Else
   Msg = Param(1,"Exit?")
EndIf

MsgLen = STR:Length(Msg)
NoChoice = "No " + (STR:Repeat(" ",MsgLen - 3))
YesChoice = "Yes" + (STR:Repeat(" ",MsgLen - 3))
If (MsgLen <= 74)
   WIN:Menu:Define(14,38 - MsgLen / 2)
   WIN:Title(Msg)
Else
   MsgLen = 74
   WIN:Menu:Define(14,38 - MsgLen / 2)
   WIN:Title(STR:Sub(Msg,1,74))
EndIf

WIN:Menu:Item:Add(NoChoice)
WIN:Menu:Item:Add(YesChoice)
If (!(Param(2,False)))
   Answer = WIN:Menu:Start(1)
Else
   Answer = WIN:Menu:Start(2)
EndIf

WIN:Close

If (Answer = 2) & (KEY:Last() = KEY_ENTER)
   Return(True)
EndIf


Return(False)

