'[PROCEDURE]
'Purpose - Retrieves a string from within a window.
'[PARAM 1]
'Purpose - Title of string retrieval window
'Type    - String
'Default - Null ( Empty string)
'[PARAM 2]
'Purpose - Maximum length of string to be retrieved
'Type    - Integer
'Default - 100 characters
'[PARAM 3]
'Purpose - Displays length of retrieval string
'Type    - Integer
'Default - 20 characters
'[PARAM 4]
'Purpose - Style of string retrieval display ( 0 = Hidden), ( 1 = Visible)
'Type    - Integer
'Default - Visible
'[PARAM 5]
'Purpose - Beginning row of string retrieval window
'Type    - Integer
'Default - Display window will be centered
'[PARAM 6]
'Purpose - Beginning column of string retrieval window
'Type    - Integer
'Default - Display window will be centered
'[PARAM 7]
'Purpose - Initial display string ( If unchanged will be returned)
'Type    - String
'Default - NULL
'[PARAM 8]
'Purpose - Input Filter Type
'Type    - Integer
'Default - 0 ( No Filter)
'[RETURN]
'Purpose - Returns an object with the attributes STRING,ERROR.
'Type    - Object
'   STRING  - A string.
'   ERROR   - An integer representing success ( = 0 ) or failure ( < 0 ).
'[EXAMPLE]
'StrObj = RPC:Call("","GETSTRNG.BAS")
'If (StrObj.Error = 0)
'   Print("The string is ",StrObj.String); NewLine
'Else
'   Print("No string entered"); NewLine
'EndIf

#define DEFAULT_STYLE      	1
#define MAX_TITLE_LEN      	30
#define DEFAULT_TITLE	   	""
#define MAX_MSG_LEN        	100
#define DEFAULT_MSG_LEN    	50
#define MAX_SHOW_MSG   	   	40
#define DEFAULT_SHOW_MSG   	20
#define MAX_ROW   	   	23
#define DEFAULT_ROW   	   	12
#define DEFAULT_COLUMN     	-1
#define DEFAULT_INIT_STRING     ""
#include "Win.H"

Local("Title","MsgLen","MsgShw","Style","Row","Column","InitStr","Filter")
Local("SzBuf","I","Picture","ColEnd","Window","ExitKey","StrObj","SysObj")

Title = DATA:String(Param(1,DEFAULT_TITLE))
MsgLen = Param(2,DEFAULT_MSG_LEN)
MsgShw = Param(3,DEFAULT_SHOW_MSG)
Style = Param(4,DEFAULT_STYLE)
Row = Param(5,DEFAULT_ROW)
Column = Param(6,DEFAULT_COLUMN)
InitStr = DATA:String(Param(7,DEFAULT_INIT_STRING))
Filter = Param(8,0)

If (STR:Length(Title) > MAX_TITLE_LEN)
   Title = STR:Sub(Title,1,MAX_TITLE_LEN)
EndIf

If (MsgLen > MAX_MSG_LEN)
   MsgLen = MAX_MSG_LEN
EndIf

If (MsgShw > MAX_SHOW_MSG)
   MsgShw = MAX_SHOW_MSG
EndIf

If (Row > MAX_ROW)
   Row = MAX_ROW
EndIf

' If no beginning column was sent as a parameter center the retrieval
' window in the middle of the screen.
If (Column = DEFAULT_COLUMN)
   Column = (80 - (STR:Length(Title) + MsgShw + 3)) / 2
   ColEnd = Column + STR:Length(Title) + MsgShw + 3
Else
   ColEnd = Column + STR:Length(Title) + MsgShw + 3
   'If the retrieval window ends beyond the end of the screen place it as
   'far right as possible.
   If (ColEnd > 80)
      Column = Column - (ColEnd - 80 + 1)
      ColEnd = Column + STR:Length(Title) + MsgShw + 3
   EndIf
EndIf

Window = WIN:Define(Row,Column,Row + 2,ColEnd); WIN:Show
WIN:At(1,2); WIN:Say(Title)

' If Style = 0 hide the string retrieval display.
If (Style = 0)
   SysObj = SYS:Info
   
   If (SysObj.Monitor.Type = "COLOR")
      WIN:Get:Color(WIN_FG_BLUE + WIN_BG_BLUE)
   Else
      WIN:Get:Color(WIN_FG_BLACK + WIN_BG_BLACK)
   EndIf
EndIf

If (MsgLen > STR:Length(InitStr))
   SzBuf = STR:Pad:Right(" ",MsgLen - STR:Length(InitStr))
   SzBuf = InitStr + SzBuf
Else
   SzBuf = STR:Sub(InitStr,1,MsgLen)
EndIf

Picture = ""

If (Filter = 1)
   I = 0
   Do While (I < STR:Length(SzBuf))
      I = I + 1
      Picture = Picture + "9"
   EndDo
Else
   If (Filter = 2)
      Picture = Picture + "Y"
   EndIf
EndIf

If (Filter = 0)
   WIN:At(1,(3 + STR:Length(Title))); WIN:Get(SzBuf)
Else
   WIN:At(1,(3 + STR:Length(Title))); WIN:Get(SzBuf); WIN:Get:Picture(Picture)
EndIf

ExitKey = WIN:Get:Read

WIN:Close(Window)

If (ExitKey = KEY_ENTER)
   StrObj = OBJECT:Make("String",STR:Trim:Right(SzBuf))
   StrObj = StrObj + OBJECT:Make("Error",0)
Else
   StrObj = OBJECT:Make("Error", - 107)
EndIf

WIN:Cursor:Hide


Return(StrObj)

