'[PROCEDURE]
'Purpose = This procedure creates a popup Window to get the login
'          information to the NDS tree, then logs using this information.
'[PARAM1]
'Purpose = Password
'Type = String
'Default = Blank string 40 charaters long
'[PARAM2]
'Purpose = Common name
'Type = String
'Default = Blank string 64 charaters long
'[PARAM3]
'Purpose = Org Name 1
'Type = String
'Default = Blank string 64 charaters long
'[PARAM4]
'Purpose = Org Name 2
'Type = String
'Default = Blank string 64 charaters long
'[PARAM5]
'Purpose = Org Unit Name 1
'Type = String
'Default = Blank string 64 charaters long
'[PARAM6]
'Purpose = Org Unit Name21
'Type = String
'Default = Blank string 64 charaters long
'[RETURN]
'Purpose = Current session number
'Type = Integer
'Note = will return -1 if Esc key is pressed,
'                    0 if could not login
'
'[EXAMPLE]
'CurrSess = RPC:Call("","DSLOGIN.BAS")
'If (CurrSess > 0)
'  Path = NDS:Context:Path(CurrSess)
'  Print("Context path     : ",Path); Newline
'EndIf


#include "WIN.H"
#include "KEY.H"

Local("CommonName","Password","LogObj","Window","EKey","SysObj")
Local("OrgName1","OrgName2","OrgUnit1","OrgUnit2")

Password = STR:Pad:Right(Param(1,""),40)
CommonName = STR:Pad:Right(Param(2,""),64)
OrgName1 = STR:Pad:Right(Param(3,""),64)
OrgName2 = STR:Pad:Right(Param(4,""),64)
OrgUnit1 = STR:Pad:Right(Param(5,""),64)
OrgUnit2 = STR:Pad:Right(Param(6,""),64)

Window = WIN:Define(7,12,17,68)
WIN:Title("Please Log In")
WIN:Show

WIN:At(2,2); WIN:Say("Enter Common Name              : ")
WIN:Get(CommonName,20)

WIN:At(3,2); WIN:Say("Enter Organization Name 1      : ")
WIN:Get(OrgName1,20)

WIN:At(4,2); WIN:Say("Enter Organization Name 2      : ")
WIN:Get(OrgName2,20)

WIN:At(5,2); WIN:Say("Enter Organization Unit Name 1 : ")
WIN:Get(OrgUnit1,20)

WIN:At(6,2); WIN:Say("Enter Organization Unit Name 2 : ")
WIN:Get(OrgUnit2,20)

WIN:At(8,2); WIN:Say("Enter Password   : ")
WIN:Get(Password,18)
WIN:Get:Picture("*")

WIN:Get:Color(WIN_BG_BLACK + WIN_FG_WHITE)
EKey = WIN:Get:Read

Buf = ".CN=" + STR:Trim:All(CommonName)

If (STR:Trim:All(OrgName1) != "")
   Buf = Buf + ".O=" + STR:Trim:All(OrgName1)
EndIf

If (STR:Trim:All(OrgName2) != "")
   Buf = Buf + ".O=" + STR:Trim:All(OrgName2)
EndIf

If (STR:Trim:All(OrgUnit1) != "")
   Buf = Buf + ".OU=" + STR:Trim:All(OrgUnit1)
EndIf

If (STR:Trim:All(OrgUnit2) != "")
   Buf = Buf + ".OU=" +STR:Trim:All(OrgUnit2)
EndIf


If (EKey = KEY_ESC)
   CurrSess =  - 1
Else
   CurrSess = NDS:Session:Login(Buf,STR:Trim:All(Password))
   If (CurrSess = 0)
      WIN:Popup("",STR:Sub(STR:Trim:Right("  Error login in as " + CommonName),1,78),"")
   EndIf
EndIf

WIN:Close(Window)

Return(CurrSess)



