{$V-,I-}

program TUndoc;

uses
  Crt, Dos, Undoc;

  procedure MakeLotsOfFiles;
    {-Creates a lot of files, write to them and delete them}
  const
    FilesNeeded = 30;
    AlreadyOpen = 5;
  var
    N : Byte;
    TextFile : array[1..FilesNeeded] of Text;

    function StringIt(N : LongInt) : String;
      {-Turn a long integer to a string; no validity checking}
    var
      S : String;
    begin
      Str(N, S);
      StringIt := S;
    end;

  begin
    {make sure we have enough file handles. Normally DOS allows
     about 15 files. If running in IDE increase AlreadyOpen}
    if not SetHandleCount(30+AlreadyOpen) then begin
      WriteLn('Couldn''t set new handle count; check DOS version');
      Halt(1);
    end;

    for N := 1 to FilesNeeded do begin
      Assign(TextFile[N], 'FILE'+StringIt(N));
      Write('Creating ', 'FILE'+StringIt(N), ', ');
      Rewrite(TextFile[N]);
      if IoResult <> 0 then begin
        WriteLn('Could''t create this file');
        Halt(1);
      end;
      WriteLn('writing some stuff to it.');
    end;

    for N := 1 to FilesNeeded do begin
      WriteLn('Closing and erasing ', 'FILE'+StringIt(N), '.');
      Close(TextFile[N]);
      Erase(TextFile[N]);
    end;
  end;

var
  Ch : Char;

begin
  ClrScr;

  WriteLn('Test Undoc, Test Programs 1.0, Copyright 1993 by Sren Granfeldt');
  WriteLn;

  {check switch char}
  WriteLn('Character used to introduce command line switches is ', GetSwitchChar);

  {check network}
  if not MSNetworkInstalled then
    Write('No ');
  WriteLn('Microsoft-compatible network installed.');

  Write(^M^J'Press any key to test lots of open files...');
  Ch := ReadKey;
  WriteLn;

  MakeLotsOfFiles;
end.
