#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <dir.h>
#include <string.h>
#include <mem.h>
#include <stdlib.h>
#include <graphics.h>
#include <ctype.h>

typedef unsigned char BYTE;
typedef unsigned int  WORD;
typedef unsigned long LONG;

#define zap(a)				{memset ( &a, NULL, sizeof(a));}
#define MaxLines			20
#define TRUE                1

// printdebug: 0=off, 1=on

#include "select.h"

char ProgName[]="Select";
int  VerMaj=1;
int  VerMin=6;
char ENET[]="000000000000";
char *ptr;
FILE *LocationSrt;
FILE *SelectIni;
char DefQ[48];
char qlst[100][100];
char qloc[100][100];
int  qrdy[100];
int  qcnt=0;
int  MaxQueueNameLength=0;
int  MaxServerNameLength=0;
int  fullnameoffset;
int  printdebug=0;
int  printcommand=1;
int  Banner=1;
int  LptNum=1;
int  timeout=30;
int  xl,xh,yl,yh;
char *qstat[]={	"  <Off>  ",
				"Available",
				" Default ",
				"  Local  "};

void pause()
{
	getch();
}

#include "apisubs.h"

void GetDefaultQueue()
{
	char *s1;
	char *s2;
	char s[100];
	int t;

	strcpy(qlst[qcnt],"NONE");
	strcpy(qloc[qcnt],"Local printer");
	qrdy[qcnt]=3;
	qcnt++;

	ptr = getenv("PATH");
	s1=ptr;
	s2=ptr;
	while (*s1!=NULL)
	{
		while ((*s2!=NULL)&&(*s2!=';')) s2++;
		if (*s2==';')
		{
			*s2=NULL;
			strcpy(s,s1);
			*s2=';';
			s2++;
		}
		else
		{
			strcpy(s,s1);
		}
		s1=s2;
		s2++;
		strcat(s,"\\LOCATION.SRT");
		LocationSrt=fopen(s,"rt");
		if (LocationSrt!=NULL) break;
	}
	strcpy(DefQ,"NONE");
	if (LocationSrt==NULL) return;
	t=1;
	while (t==1)
	{
		if (fgets(s,sizeof(s),LocationSrt)==NULL)
		{
			fclose(LocationSrt);
			strcpy(DefQ,"NONE");
			return;
		}
		if (strlen(s)<20)
		{
			fclose(LocationSrt);
			strcpy(DefQ,"NONE");
			return;
		}
		s1=(char *)&s;
		s2=s1;
		while (*s1!=' ') s1++;
		while ((s1>s2)&&(*s1!=':')) s1--;
		if (*s1==':') s1++;
		while (*s2!=' ') s2++;
		*s2=NULL;
		t=strcmp(ENET,s1);
		*s2=' ';
		if (t==0)
		{
			s2++;
			for (t=32;t>0;t--) s2++;
			s2++;
			s1=(char *)&DefQ;
			while ((*s2!=' ')&&(*s2!='\n')) *(s1++)=*(s2++);
			*s1=NULL;
		}
		if (t!=0) t=1;
	}
	fclose(LocationSrt);
	strcpy(qlst[qcnt],DefQ);
	strcpy(qloc[qcnt],"Normal network location");
	qrdy[qcnt]=2;
	qcnt++;
}

void GetEthernetNumber()
{
	union REGS regs;

	regs.h.ah = 0xEE;
	intdos(&regs, &regs);
	sprintf(ENET,"%04X%04X%04X",regs.x.cx,regs.x.bx,regs.x.ax);
}

void LoadList()
{
	BYTE searchObjectName[48]="*";
	WORD searchObjectType=0x0300; // 0x0300 = Print Queue
	long objectID;
	BYTE objectName[48];
	WORD objectType;
	BYTE objectHasProperties;
	BYTE objectFlag;
	BYTE objectSecurity;

	int result;
	result=0;

	while (result==0)
	{
		result=ScanBinderyObject (
			   searchObjectName, searchObjectType, &objectID, objectName,
			   &objectType, &objectHasProperties, &objectFlag,
			   &objectSecurity);
		if (result!=0 && result!=0xFC) perror(result);
		if (qcnt<100-1 && result==0)
		{
			qrdy[qcnt]=QueueServerReady(objectID);
			strcpy(qlst[qcnt],objectName);
			GetQueueLocation(objectID,qloc[qcnt]);
			if (*qloc[qcnt]==NULL)
			{
				GetQueueDefaultLocation(objectName,qloc[qcnt]);
			}
			if (*qloc[qcnt]!=NULL) qcnt++;
		}
	}
}

void SortList()
{
	char tstr[100];
	int  i,j,t;

	for (i=0;i<qcnt-1;i++)
	{
		for (j=i+1;j<qcnt;j++)
		{
			if (strcmp(qlst[i],qlst[j])>0)
			{
				strcpy(tstr,qlst[i]);
				strcpy(qlst[i],qlst[j]);
				strcpy(qlst[j],tstr);
				strcpy(tstr,qloc[i]);
				strcpy(qloc[i],qloc[j]);
				strcpy(qloc[j],tstr);
				t=qrdy[i]; qrdy[i]=qrdy[j]; qrdy[j]=t;
			}
		}
	}
}

int getArrow()
{
	char ch;

	ch=' ';
	while (ch==' ')
	{
		ch=getch();
		if (ch==0x000D) {ch='s'; break;}  // Return
		if (ch==0x001B) {ch='e'; break;}  // Escape
		if (ch==0x0018) {ch='X'; break;}  // Ctl-X
		if (ch==0x0042) {ch='b'; break;}  // 'B'
		if (ch==0x0062) {ch='b'; break;}  // 'b'
		if (ch==0x0031) {ch='1'; break;}  // '1'
		if (ch==0x0032) {ch='2'; break;}  // '2'
		if (ch==0x0033) {ch='3'; break;}  // '3'
		if (ch==0X003F) {ch='?'; break;}  // '?'
		if (ch==0x0058) {ch='X'; break;}  // 'X'
		if (ch==0x0078) {ch='X'; break;}  // 'x'
		if (ch==0x002B) {ch='+'; break;}  // '+'
		if (ch==0x002D) {ch='-'; break;}  // '-'
		if (ch==0x0000)  // Extended key as follows:
		{
			ch=getch();
			if (ch==0x0047) {ch='H'; break;}  // Home
			if (ch==0x0048) {ch='u'; break;}  // Up
			if (ch==0x0049) {ch='U'; break;}  // PgUp
			if (ch==0x004F) {ch='E'; break;}  // End
			if (ch==0x0050) {ch='d'; break;}  // Down
			if (ch==0x0051) {ch='D'; break;}  // PgDn
			if (ch==0x003B) {ch='?'; break;}  // F1 (Help)
			if (ch==0x002D) {ch='X'; break;}  // Alt-X
		}
		ch=' ';
	}
	return (ch);
}

void ShowQ(int i, int j)
{
	int t;

	if (j==0)
	{
		textcolor(WHITE);
		textbackground(BLUE);
	}
	t=xh-xl-1-MaxQueueNameLength-MaxServerNameLength;
	cprintf("%-*s %-*s %*s",MaxQueueNameLength,qlst[i],
							MaxServerNameLength,qloc[i],
							t,qstat[qrdy[i]]);
	textcolor(LIGHTGRAY);
	textbackground(BLACK);
}

int ShowUpdate(int WinTop, int WinPos)
{
	static OldTop=-2;
	static OldPos=-2;
	int i,j;
	REGS scroll;

	if (OldTop==WinTop)
	{
		gotoxy(xl,2+OldPos-OldTop);
		ShowQ(OldPos,1);
		gotoxy(xl,2+WinPos-WinTop);
		ShowQ(WinPos,0);
	}
	else
	if (OldTop-WinTop==1)
	{
		gotoxy(xl,2+OldPos-OldTop);
		ShowQ(OldPos,1);
		zap(scroll);
		scroll.h.ah=0x07;
		scroll.h.al=1;
		scroll.h.bh=BLACK<<4+LIGHTGRAY;
		scroll.h.ch=yl-1;
		scroll.h.cl=xl-1;
		scroll.h.dh=yh-1;
		scroll.h.dl=xh-1;
		int86(0x10,&scroll,&scroll);
		gotoxy(xl,yh);
		gotoxy(xl,2+WinPos-WinTop);
		ShowQ(WinPos,0);
	}
	else
	if (WinTop-OldTop==1)
	{
		gotoxy(xl,2+OldPos-OldTop);
		ShowQ(OldPos,1);
		zap(scroll);
		scroll.h.ah=0x06;
		scroll.h.al=1;
		scroll.h.bh=BLACK<<4+LIGHTGRAY;
		scroll.h.ch=yl-1;
		scroll.h.cl=xl-1;
		scroll.h.dh=yh-1;
		scroll.h.dl=xh-1;
		int86(0x10,&scroll,&scroll);
		gotoxy(xl,yl);
		gotoxy(xl,2+WinPos-WinTop);
		ShowQ(WinPos,0);
	}
	else
	{
		j=qcnt-1;
		if (j>MaxLines) j=MaxLines;
		for (i=0; i<j; i++)
		{
			gotoxy(xl,2+i);
			ShowQ(WinTop+i,WinTop+i-WinPos);
		}
	}

	gotoxy(xl-1,2);
	cprintf("%s",(WinTop>0)?"":"");
	gotoxy(xl-1,MaxLines+1);
	cprintf("%s",(WinTop+MaxLines<qcnt)?"":"");

	gotoxy(xl,yh+2);
	cprintf("<ESC> to Exit, <CR> to Select, B=Banner: <%s>",
			Banner==0?"yes":"no ");
	gotoxy(xl,yh+3);
	cprintf("1=LPT1, 2=LPT2, 3=LPT3: <%d>      =Timeout %3d",LptNum,timeout);
	gotoxy(1,1);

	OldTop=WinTop;
	OldPos=WinPos;
	return getArrow();
}

void ShowList()
{
//	͹
//	
	int i,j,o;

	o=(79-MaxQueueNameLength-MaxServerNameLength-strlen(qstat[0])) / 2;
	if (o>17) o=17;
	j=qcnt;
	if (j>MaxLines) j=MaxLines;

	xl=o+1;
	yl=2;
	xh=xl+80-o-o;
	yh=yl+j-1;

	clrscr();
	gotoxy(o,1);
	cprintf("");
	for (i=1; i<(82-o-o); i++) cprintf("");
	cprintf("");

	for (i=0; i<j; i++)
	{
		gotoxy(xl-1,2+i);
		cprintf("");
		ShowQ(i,i);
		gotoxy(xh+1,2+i);
		cprintf("");
	}

	if (j>=MaxLines)
	{
		gotoxy(xl-1,j+1);
		cprintf("");
	}

	gotoxy(o,j+2);
	cprintf("");
	for (i=1; i<(82-o-o); i++) cprintf("");
	cprintf("");

	gotoxy(o,j+3);
	cprintf("");
	for (i=1; i<(82-o-o); i++) cprintf(" ");
	cprintf("");

	gotoxy(o,j+4);
	cprintf("");
	for (i=1; i<(82-o-o); i++) cprintf(" ");
	cprintf("");

	gotoxy(o,j+5);
	cprintf("");
	for (i=1; i<(82-o-o); i++) cprintf("");
	cprintf("");

	gotoxy(o+1,j+3);
	cprintf("<ESC> to Exit, <CR> to Select, B for %sbanner",
			Banner==0?"no ":"a ");

	gotoxy(o+1,j+4);
	cprintf("1=LPT1, 2=LPT2, 3=LPT3: <%d>      =Timeout %3d",LptNum,timeout);

	gotoxy(1,j+5);

	return;
}

void SelectQueue(int i)
{
	char stmp[100];

	strcpy(stmp,"");

	if (i==-2) i=qcnt-2;
	if (i==-3) i=qcnt-1;

	if (i==qcnt-1) // reset
	{
		if (strcmp("NONE",qlst[i])==0) i--; // reset IS none
		Banner=0; // reset already has banner defined
	}
	if (i==qcnt-2) // none
	{
		sprintf(stmp,"ENDCAP");
	}
	if (i==-1)
	{
		sprintf(stmp,"CAPTURE /SHOW");
	}
	if ((i>=0)&&(i<qcnt)&&(i!=qcnt-2))
	{
		sprintf(stmp,"CAPTURE /Q=%s%s /NT /TI=%d /L=%d",
				qlst[i],Banner>0?" /NB":"",timeout,LptNum);
	}
	normvideo();
	if (_argc==1) clrscr();
	if (printcommand) printf("%s\n",stmp);
	system(stmp);
	return;
}

void usage()
{
	printf("%s v%d.%d\n",ProgName,VerMaj,VerMin);
	printf("Created by Jeff Pilant <pilant@nadc.nadc.navy.mil>\n");
	printf("\n");
	printf("Usage:\n");
	printf("\n");
	printf("   SELECT <queue> [/NB] | <keyword> | FILE <filename>\n");
	printf("\n");
	printf("Where:\n");
	printf("   <queue> is the name of a print queue or printer\n");
	printf("   /NB     selects no banner\n");
	printf("   HELP    this text\n");
	printf("   RESET   reset to login setup\n");
	printf("   LPT     set for no capturing of printers\n");
	printf("   NONE    set for no capturing of printers\n");
	printf("   LOCAL   set for no capturing of printers\n");
	printf("   SHOW    display capture status\n");
	printf("   FILE    set for capture to file <filename>\n");
	printf("           the captured file must reside on the server\n");
	printf("\n");
	printf("With no arguments, select give a menu and allows you to\n");
	printf("set the timeout and choose queues for lpt2 and lpt3 as well.\n");

	exit (0);
	return;
}

void SetFile(char *fn)
{
	char stmp[100];

	zap(stmp);

	sprintf(stmp,"CAPTURE /CR=%s /TI=300 /NT /NFF /NB",fn);
	system(stmp);
	exit(0);
}

void UseArg()
{
	char *kw[]={"HELP","?","/?","RESET","LPT","NONE","LOCAL","SHOW","FILE",""};
	int i;
	int reset=0;
	int help=0;
	int local=0;
	int show=0;

	char *ch;

	ch=_argv[1];
	while (*ch!=NULL) {*ch=toupper(*ch); ch++;}

	Banner=0; // default command line entry to banner

	if (_argc==3)
	{
		ch=_argv[2];
		while (*ch!=NULL) {*ch=toupper(*ch); ch++;}
		if (strcmp("/NB",_argv[2])==0) Banner=1;
		if (strcmp("NB",_argv[2])==0) Banner=1;
		if (Banner==0)
		{
			if (strcmp(_argv[1],kw[8])==0)
			{
				SetFile(_argv[2]);
			}
			else usage();
		}
	}

	for (i=0; kw[i][0]!=NULL; i++)
	{
		if (strcmp(kw[i],_argv[1])==0)
		{
			switch (i)
			{
				case 0: help=1;  break;
				case 1: help=1;  break;
				case 2: help=1;  break;
				case 3: reset=1; break;
				case 4: local=1; break;
				case 5: local=1; break;
				case 6: local=1; break;
				case 7: show=1;  break;
			}
		}
	}
	if (help==1)  {usage();         exit (0);}
	if (show==1)  {SelectQueue(-1); exit (0);}
	LoadList();
	SortList();
	GetEthernetNumber();
	GetDefaultQueue();
	if (local==1) {SelectQueue(-2); exit (0);}
	if (reset==1) {SelectQueue(-3); exit (0);}

//	given queue name
	for (i=0;i<qcnt;i++)
	{
		ch=qloc[i];
		while (*ch!=NULL) {*ch=toupper(*ch); ch++;}

		if (strcmp(_argv[1],qlst[i])==0)
		{
			SelectQueue(i);
			exit (0);
		}
		if ((qlst[i][0]=='Q')&&(qlst[i][1]=='_')&&strcmp(_argv[1],&qlst[i][2])==0)
		{
			SelectQueue(i);
			exit (0);
		}
		if (stricmp(_argv[1],&qloc[i][fullnameoffset])==0)
		{
			SelectQueue(i);
			exit(0);
		}
	}
	printf("Queue \"%s\" is unknown\n",_argv[1]);
	exit (1);

	return;
}

void GetINIfile()
{
	int i;
	char far *s;
	char ini[100];
	char *c;
	char l[100];

// INI file:
//
// Start with:
	char ini1[]="[SELECT]";

// Parameter recognised:
	char ini2[]="DEBUG";
// Usage of parameter:
//
// If this parameter exists, it turns debugging info on

	char ini3[]="NAME OFFSET";
// Usage of parameter:
//
// Print server's fullnames are of the form "aaaa bbbb cccc"
// and the "cccc" is to be the key, and allways starts at position 'n'
// needs a name offset of 'n'

	char ini4[]="SILENT";
// Usage of parameter:
//
// If exists, turns off printing of shelled command

	i=peek(_psp,44);
	s=(char far *) MK_FP(i,0);

	i=1;
	while (i==1)
	{
		while (*s!=NULL) s++;
		s++;
		if (*s==NULL) i=0;
	}
	s++;
	s++;
	s++;
	zap(ini);
	c=(char *) &ini;
	while (*s!=NULL) *c++=*s++;
	i=strlen(ini)-3;
	strcpy(&ini[i],"INI");

	SelectIni=fopen(ini,"rt");
	if (SelectIni==NULL)
	{
		SelectIni=fopen(ini,"wt");
		fprintf(SelectIni,"%s\n",ini1);
		fprintf(SelectIni,"%s=0\n",ini3);
		fclose(SelectIni);
		SelectIni=fopen(ini,"rt");
	}

	zap(l);
	i=0;
	while (TRUE)
	{
		strcpy(l,fgets(l,sizeof(l),SelectIni));
		if (l[0]==NULL) break;
		if (strnicmp(l,ini1,strlen(ini1))==0) i=1;
		if (strnicmp(l,ini2,strlen(ini2))==0 && i==1)
		{
			printdebug=1;
		}
		if (strnicmp(l,ini3,strlen(ini2))==0 && i==1)
		{
			c=&l[11];
			while (*c==' ' || *c=='\t') c++;
			if (*c=='=') c++;
			while (*c==' ' || *c=='\t') c++;
			sscanf(c,"%i",&fullnameoffset);
		}
		if (strnicmp(l,ini4,strlen(ini4))==0 && i==1)
		{
			printcommand=0;
		}
	}
	fclose(SelectIni);
}

main()
{
	int i,j,k;
	int WinPos;
	int WinTop;
	char result;

	GetINIfile();
	if (_argc>3) usage();
	if (_argc>1) UseArg();

	clrscr();
	textcolor(LIGHTGRAY);
	textbackground(BLACK);

	LoadList();
	SortList();
	GetEthernetNumber();
	GetDefaultQueue();

	for (i=0;i<qcnt;i++)
	{
		j=strlen(qlst[i]);
		k=strlen(qloc[i]);
		if (j>MaxQueueNameLength ) MaxQueueNameLength =j;
		if (k>MaxServerNameLength) MaxServerNameLength=k;
	}
	j=MaxQueueNameLength;
	k=MaxServerNameLength;

	WinPos=0;
	WinTop=0;
	result=' ';

	ShowList();

	while (result==' ')
	{
		result=ShowUpdate(WinTop,WinPos);
		switch (result)
		{
			case 'H':	WinPos=0;
						result=' '; break;
			case 'U': 	WinPos-=(MaxLines-1);
						if (WinPos<0) WinPos=0;
						result=' '; break;
			case 'u': 	if (--WinPos<0) WinPos=qcnt-1;
						result=' '; break;
			case 'd': 	if (++WinPos>qcnt-1) WinPos=0;
						result=' '; break;
			case 'D': 	WinPos+=(MaxLines-1);
						if (WinPos>qcnt-1) WinPos=qcnt-1;
						result=' '; break;
			case 'E': 	WinPos=qcnt-1;
						result=' '; break;
			case 'b': 	Banner=1-Banner;
						result=' '; break;
			case 's': 	SelectQueue(WinPos);
						break;
			case 'e': 	SelectQueue(-1);
						break;
			case '1':	LptNum=1; result=' '; break;
			case '2':	LptNum=2; result=' '; break;
			case '3':	LptNum=3; result=' '; break;
			case '?':   clrscr(); usage(); break;
			case 'X':   clrscr(); break;
			case '+':	timeout++; if (timeout>900) timeout=0; result=' '; break;
			case '-':	timeout--; if (timeout<0) timeout=900; result=' '; break;
			default :	break;
		}
		if (WinPos<WinTop) WinTop=WinPos;
		if ((WinPos-WinTop)>=MaxLines) WinTop=WinPos-MaxLines+1;
	}

	exit(0);
	return(0);
}
