/*
 * Copyright (c) 1986 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)maketape.c	1.1 (2.10BSD Berkeley) 12/1/86
 */

#include <stdio.h>

#define MAXB 30

int	mt;
int	fd;
char	buf[MAXB*512];
char	name[50];
int	blksz;
int	cnt, ii;

main(argc, argv)
	int argc;
	char *argv[];
{
	int i, j, k;
	FILE *mf;

	if (argc != 3) {
		fprintf(stderr, "usage: maketape tapedrive makefile\n");
		exit(1);
	}
	if ((mt = creat(argv[1], 0666)) < 0) {
		perror(argv[1]);
		exit(1);
	}
	if ((mf = fopen(argv[2], "r")) == NULL) {
		perror(argv[2]);
		exit(1);
	}

	j = 0;
	k = 0;
	for (;;) {
		if ((i = fscanf(mf, "%s %d", name, &blksz))== EOF)
			exit(0);
		if (i != 2) {
			fprintf(stderr, "Help! Scanf didn't read 2 things (%d)\n", i);
			exit(1);
		}
		if (blksz <= 0 || blksz > MAXB) {
			fprintf(stderr, "Block size %d is invalid\n", blksz);
			exit(1);
		}
		if (strcmp(name, "*") == 0) {
			close(mt);
			sleep(3);
			mt = open(argv[1], 2);
			j = 0;
			k++;
			continue;
		}
		fd = open(name, 0);
		if (fd < 0) {
			perror(name);
			exit(1);
		}
		printf("%s: block %d, file %d\n", name, j, k);

		/*
		 * wfj fix to final block output.
		 * we pad the last record with nulls
		 * (instead of the bell std. of padding with trash).
		 * this allows you to access text files on the
		 * tape without garbage at the end of the file.
		 * (note that there is no record length associated
		 *  with tape files)
		 */

		while ((cnt=read(fd, buf, 512*blksz)) == 512*blksz) {
			j++;
			write(mt, buf, 512*blksz);
		}
		if (cnt>0) {
			for (ii=cnt; ii < 512*blksz; ii++)
				buf[ii] = '\0';
			write(mt, buf, 512*blksz);
		}
	}
}
