/*
 *	alloc.c
 *
 *	Allocate and free blocks on a device.
 *	Free blocks are kept in a chain, the with 100 block
 *	in the superblock.
 */
#include "h\types.h"
#include "h\param.h"
#include "h\buf.h"
#include "h\filsys.h"
#include "h\conf.h"
#include "h\user.h"
#include "h\inode.h"
#include "h\systm.h"

struct inode inode[NINODE];	/* the in core inode list	*/
int updlock;

/*
 * initialize root filesystem
 */
void iinit(void)
	{
	register struct buf *bp;
	register struct filsys *cp;

	(*bdevsw[major(rootdev)].d_open)(rootdev,1);
	bp = bread(rootdev,1);
	cp=(struct filsys*)getblk(NODEV,0);
	if (u->u_error)
		{
		printf("IINIT\n");
		panic("IINIT");
		}
	bcopy (bp->b_addr,((struct buf*)cp)->b_addr,256);
	brelse(bp);
	mount[0].m_bufp=(struct buf*)cp;
	mount[0].m_dev=rootdev;
	cp=(struct filsys*)((struct buf*)cp)->b_addr;
	cp->s_flock=0;
	cp->s_ilock=0;
	cp->s_ronly=0;

	}
/*
 *	struct buf * alloc(dev)
 *	Allocate a free block on dev
 *	returns pointer to buf header of the block
 */
struct buf *alloc(dev)
dev_t dev;
	{
	register struct buf *bp;
	register struct filsys *fp;
	int *ip;
	int bno;


	fp=getfs(dev);
	while(fp->s_flock)
		sleep((int)&fp->s_flock,PINOD);
	do	{
		if (fp->s_nfree<=0)
			goto NOSPACE;
		bno = fp->s_free[--fp->s_nfree];/* Next free in the sb	*/
		fp->s_bfree--;
		if (bno==0)                     /* end of free chain	*/
			goto NOSPACE;
		}
		while (badblock(fp,bno,dev));
	if (fp->s_nfree<=0)			/* No free in the sb	*/
		{
		fp->s_flock++;
		bp=bread(dev,bno);		/* read in next block	*/
		ip = (int*)bp->b_addr;
		fp->s_nfree=*ip++;              /* and store another	*/
		bcopy (ip,fp->s_free,100);	/* 100 free in the sb	*/
		brelse(bp);
		fp->s_flock=0;
		wakeup((int)&fp->s_flock);
		}
	bp=getblk(dev,bno);
	clrbuf(bp);				/* free block is zeroed	*/
	fp->s_fmod=1;
	return(bp);

NOSPACE:
	fp->s_nfree=0;
	prdev("no space",dev);
	u->u_error=ENOSPC;
	return(NULL);
	}
/*
 *	free(dev,bno)
 *	Free block bno on dev dev
 */

void free(dev,bno)
dev_t dev;
blk_t bno;
	{
	register struct filsys *fp;
	register struct buf *bp;
	int *ip;

	fp = getfs(dev);
	fp->s_fmod = 1;
	while(fp->s_flock)
		sleep((int)&fp->s_flock, PINOD);

	if (badblock(fp, bno, dev))
		return;

	if(fp->s_nfree <= 0)
		{
		fp->s_nfree = 1;
		fp->s_free[0] = 0;
		}
	if(fp->s_nfree >= 100)			/* sb is full of free blks*/
		{
		fp->s_flock++;
		bp =getblk(dev, bno);
		ip =(int*) bp->b_addr;
		*ip++=fp->s_nfree;
		bcopy(fp->s_free,ip, 100);
		fp->s_nfree = 0;
		bwrite(bp);
		fp->s_flock = 0;
		wakeup((int)&fp->s_flock);
		}
	fp->s_free[fp->s_nfree++] = bno;
	fp->s_bfree++;
	fp->s_fmod = 1;
	}
/*
 * check that bn is a valid block on dev
 */
badblock(fp, bn, dev)
register struct filsys *fp;
register blk_t bn;
dev_t dev;
	{

	if (bn < fp->s_isize+2 || bn >= fp->s_fsize)
		{
		prdev("bad block", dev);
		return(1);
		}
	return(0);
	}
/*
 * ialloc(dev)
 * Allocate an inode on dev
 * The sb stores 100 free i-node in a similar manner as the block free list
 */
struct inode *ialloc(dev)
	{
	register int *bp,*ip;
	register struct filsys *fp;
	int i,j,k,ino;

	fp=getfs(dev);
	while(fp->s_ilock)
		sleep((int)&fp->s_ilock,PINOD);
LOOP:
	if (fp->s_ninode>0)
		{
		ino=fp->s_inode[--fp->s_ninode];
		ip=(int *)iget(dev,ino);
		if (ip==NULL)
			return(NULL);
		if (((struct inode*)ip)->i_mode==0)
			{
			fp->s_ifree--;
			for(bp=(int*)&((struct inode*)ip)->i_mode;
			 bp<(int*)&((struct inode*)ip)->i_addr[8];)
			*bp++=0;
			fp->s_fmod=1;
			return((struct inode*)ip);
			}
		iput((struct inode*)ip);
		goto LOOP;
		}
	fp->s_ilock++;
	ino=0;
	for(i=0;i<fp->s_isize;i++)
		{
		bp=(int*)bread(dev,i+2);
		ip=(int*)((struct buf*)bp)->b_addr;
		for(j=0;j<256;j+=16)
			{
			ino++;
			if(ip[j]!=0)
				continue;
			for(k=0;k<NINODE;k++)
			if(dev==inode[k].i_dev && ino==inode[k].i_number)
				goto CONT;
			fp->s_inode[fp->s_ninode++]=ino;
			if(fp->s_ninode>=100)
				break;
			CONT:;
			}
		brelse((struct buf*)bp);
		if(fp->s_ninode>=100)
			break;
		}
	fp->s_ilock=0;
	wakeup((int)&fp->s_ilock);
	if(fp->s_ninode>0)
		goto LOOP;
	prdev("Out of inodes",dev);
	u->u_error=ENOSPC;
	return(NULL);
	}
/*
 * free(dev,ino)
 * Free allocated inode ino on dev
 */
void ifree(dev,ino)
dev_t dev;
ino_t ino;
	{
	register struct filsys *fp;

	fp=getfs(dev);
	fp->s_ifree++;
	if(fp->s_ilock)
		return;
	if(fp->s_ninode>=100)
		return;
	fp->s_inode[fp->s_ninode++]=ino;
	fp->s_fmod=1;
	}
/*
 * Get the sb from the fs on mounted dev
 */
struct filsys *getfs(dev)
dev_t dev;
	{
	register struct mount *p;
	register int n1,n2;
	for (p=&mount[0];p<&mount[NMOUNT];p++)
	if(p->m_bufp!=NULL&&p->m_dev==dev)
		{
		p=(struct mount*)p->m_bufp->b_addr;
		n1=((struct filsys*)p)->s_nfree;
		n2=((struct filsys*)p)->s_ninode;
		if(n1>100||n2>100)
			{
			prdev("bad count",dev);
			((struct filsys*)p)->s_nfree=0;
			((struct filsys*)p)->s_ninode=0;
			}
		return((struct filsys*)p);
		}
	panic("no fs");
	return(0);
	}
/*
 *	The sync syscall
 */
void update(void)
{
	struct filsys *ip;
	register struct mount *mp;
	struct buf *bp;
	register struct inode *inp;
	if(updlock)
		return;
	updlock++;
	for(mp = &mount[0]; mp < &mount[NMOUNT]; mp++)
		if(mp->m_bufp != NULL)
			{
			ip =(struct filsys*) mp->m_bufp->b_addr;
			if(ip->s_fmod==0 ||ip->s_ilock!=0 ||
			    ip->s_flock!=0 || ip->s_ronly!=0)
				continue;
			bp = getblk(mp->m_dev, 1);
			ip->s_fmod = 0;
			ip->s_time = time;
			bcopy(ip, bp->b_addr, 256);
			bwrite(bp);
			}
	for(inp = &inode[0];inp < &inode[NINODE]; inp++)
		if((inp->i_flag&ILOCK) == 0) {
			inp->i_flag |= ILOCK;
			iupdat(inp, time);
			prele(inp);
		}
	updlock = 0;
	bflush(NODEV);
}
