/* 	mem.c
 *	memory device driver
 *
 *	(c) Szigeti Szabolcs 1992
 *
 *		minor device : 0 -> phys mem
 *			       1 -> kernel data mem
 *			       2 -> /dev/null bit bucket
 */

/* TODO : (1) video mem
 *	  (2) CMOS mem
 */

#include "h\types.h"
#include "h\param.h"
#include "h\proc.h"
#include "h\user.h"
#include "h\machine.h"
#include "h\systm.h"

#define MAJOR	5
#define NUNIT	3

extern struct sys_desc memdesc;
extern word endofd;

mmread(dev)
	{
	register char *mp;
	register word essav;

	if (minor(dev)==2)
		return;		/* bitkuka */
	if (minor(dev)>=NUNIT)
		{
		u->u_error=ENXIO;
		return;
		}
	if (minor(dev)==1)
		{
		u->u_segflg=0;
		do
			{
			mp=(char *)u->u_offset;
			}
		while (u->u_error==0 && passc(*mp)>=0 && mp<=&endofd);
		}
	else
		{
		memdesc.base_h=((u->u_offset)>>16)&0xff;
		memdesc.base_l=(u->u_offset)&0xffff;
		memdesc.limit=u->u_count;
		essav=_ES;
		_ES=MEMSEL;
		do
			;

		while((subyte((word)u->u_base++,\
			*(byte _es *)(u->u_offset++))!=-1)
		      || (--u->u_count>=0));
		_ES=essav;
		}
	}

mmwrite(dev)
	{
	register char *mp;
	register int c;
	if (minor(dev)==2)
		{
		c = u->u_count;
		u->u_count = 0;
		u->u_base  += c;
		u->u_offset+= c;
		return;
		}		
		if (minor(dev)>=NUNIT)
		{
		u->u_error=ENXIO;
		return;
		}
	mp=(char*)u->u_offset;
	for(;;)
		{
		mp=(char *)u->u_offset;
		if (u->u_error||(c=cpass())<0||mp>&endofd)
			break;
		*mp=c;
		}

	}