/*
	## fd.c ##		
									*/


/* IBM AT floppy driver							
	minor 0 => floppy a: blokkos
	minor 1 => floppy b: blokkos					*/

#include "h\param.h"
#include "h\proc.h"
#include "h\user.h"
#include "h\conf.h"
#include "h\buf.h"
#include "h\glo.h"
#include "h\machine.h"
wakeup(int);

#define NUNIT 2		/* 2 egyseg a: & b: MSDOSnal			*/
#define MAJOR	2	/* major 					*/

/* I/O Ports used by floppy disk task. */
#define DOR            0x3F2	/* DigitalOutputRegister moror & reset	*/
#define FDC_STATUS     0x3F4	/* vezerlo statusz regiszter 		*/
#define FDC_DATA       0x3F5	/* vezerlo adat regiszter		*/
#define FDC_RATE       0x3F7	/* transfer rate register */
#define DMA_ADDR       0x004	/* port for low 16 bits of DMA address */
#define DMA_TOP        0x081	/* port for top 4 bits of 20-bit DMA addr */
#define DMA_COUNT      0x005	/* port for DMA count (count =  bytes - 1) */
#define DMA_M2         0x00C	/* DMA status port */
#define DMA_M1         0x00B	/* DMA status port */
#define DMA_INIT       0x00A	/* DMA init port */

/* Status registers returned as result of operation. */
#define ST0             0x00	/* status register 0 */
#define ST1             0x01	/* status register 1 */
#define ST2             0x02	/* status register 2 */
#define ST3             0x00	/* status register 3 (return by DRIVE_SENSE) */
#define ST_CYL          0x03	/* slot where controller reports cylinder */
#define ST_HEAD         0x04	/* slot where controller reports head */
#define ST_SEC          0x05	/* slot where controller reports sector */
#define ST_PCN          0x01	/* slot where controller reports present cyl */
#define OK		0
/* Fields within the I/O ports. */
#define MASTER          0x80	/* ki a jelenlegi maszter ?		*/
#define DIRECTION       0x40	/* adatatvitel iranya			*/
#define CTL_BUSY        0x10	/* used to see when controller is busy */
#define CTL_ACCEPTING   0x80	/* kepes az adatfogadasra az fdc	*/
#define MOTOR_MASK      0xF0	/* these bits control the motors in DOR */
#define ENBL_INT        0x0C	/* megszakitas engedelyezve, reset nincs*/
#define ST0_BITS        0xF8	/* check top 5 bits of seek status */
#define ST3_FAULT       0x80	/* if this bit is set, drive is sick */
#define ST3_WR_PROTECT  0x40	/* set when diskette is write protected */
#define ST3_READY       0x20	/* set when drive is ready */
#define TRANS_ST0       0x00	/* top 5 bits of ST0 for READ/WRITE */
#define SEEK_ST0        0x20	/* top 5 bits of ST0 for SEEK */
#define BAD_SECTOR      0x05	/* if these bits are set in ST1, recalibrate */
#define BAD_CYL         0x1F	/* if any of these bits are set, recalibrate */
#define WRITE_PROTECT   0x02	/* bit is set if diskette is write protected */
#define CHANGE          0xC0	/* value returned by FDC after reset */

/* FDC parancs byte-ok 							*/
#define FDC_SEEK        0x0F	/* seek parancs				*/
#define FDC_READ        0xE6	/* read parancs				*/
#define FDC_WRITE       0xC5	/* write parancs			*/
#define FDC_SENSE       0x08	/* kerjuk az fdc statusat 		*/
#define FDC_RECALIBRATE 0x07	/* recalibrate parancs			*/
#define FDC_SPECIFY     0x03	/* parameterek beallitasa		*/

/* DMA vezerlo parancsok						*/
#define DMA_READ        0x46	/* DMA read parancs 			*/
#define DMA_WRITE       0x4A	/* DMA write parancs			*/

/* Parameters for the disk drive. */
#define SECTOR_SIZE      512	/* 512 bytos szektorokat hasznalunk	*/
#define NHEAD   	0x02	/* a floppyknak 2 fejuk van		*/
#define DTL             0xFF	/* determines data length (sector size) */
#define SPEC1           0xDF	/* SPECIFY elso parametere		*/
#define SPEC2           0x02	/* SPECIFY masodik parametere		*/



/* Miscellaneous. */
#define MAX_ERRORS        20	/* how often to try rd/wt before quitting */
#define MAX_FDC_RETRY    100	/* hanyszor probal szot erteni az fdc-vel  */
#define MAX_RESTIM	HZ/5	/* maximalisan eddig tarthat a reset	*/
#define MAX_SEEKTIM	HZ*2	/* maximalisan eddig tarthat egy seek	*/

/* Six combinations of diskette/drive are supported:
 * # Drive  diskette  Sectors  Tracks  Data-rate  
 * 0  1.2M    1.2M     15       80     500 kbps
 * 1  1.44M   1.44M    18       80     500 kbps   
 */
int gap[NUNIT] =
	{0x1B, 0x15}; 				/* gap meret		*/
int rate[NUNIT] = 
	{0x00, 0x00}; 				/* adatsebesseg		*/
int sectors[NUNIT] = 
	{15,18};   				/* sectors/track 	*/
int blocks[NUNIT] = 
	{2400,2880}; 				/* sectors/disk		*/
int oncyl[NUNIT]=
	{-1,-1};				/* aktualis cylinder	*/
int calib[NUNIT]=
	{0,0};					/* kalibralt allapot	*/
int msetup[NUNIT] = 
	{3*HZ/4,3*HZ/4};			/* motor indulasi ido	*/
int mtoff[NUNIT] =
	{2*HZ,2*HZ};				/* motor leallasi ido   */
char result[NUNIT][8];				/* visszaadott status	*/
int cyl,blk,trk,sec,cnt,head,mode;
dword addr;

byte	dev_moton;	/* melyik egyseg motorjat kapcsoltak be?	*/
byte	dev_busy;	/* melyik egysegen van muvelet?			*/
byte	wantreset;	/* kell-e reseteli az fdc-t			*/
byte	lastdev;	/* utolso dev					*/

int	nunit=NUNIT;	/* kesobb a CMOSbol lesz beallitva		*/

#define L_NO	0	/* ha erre jon: hiba!!	*/
#define L_RESET	1	/* reset interrupt	*/
#define L_RECAL 2	/* recalibrate		*/
#define L_SEEK	3	/* seek			*/
#define L_RDWR	4	/* read-write		*/

#define C_READ	0
#define C_WRITE 1

struct devtab fdtab;
struct buf fdbuf;

fdopen(dev,flag)
int dev,flag;
	{
	}

fdclose(dev,flag)
int dev,flag;
	{
	}

fdstrategy(bp)
register struct buf *bp;
	{
	register word save;
	if (minor(bp->b_dev)>=nunit || bp->b_blkno>=blocks[minor(bp->b_dev)])
		{
		bp->b_flags|=B_ERROR;
		iodone(bp);
		return;
		}
	bp->av_forw=0;
	save=lock1();
	if (fdtab.d_actf==0)
		fdtab.d_actf=bp;
	else
		fdtab.d_actl->av_forw=bp;
	fdtab.d_actl=bp;
	unlock(save);
	if (fdtab.d_active==0)
		fdstart();
	}


	
fdstart()
	{
	register struct buf *bp;
	register int dev;

	if ((bp=fdtab.d_actf)==0)
		{
		return;
		}        
	

	mode= (bp->b_flags & B_READ) ? C_READ : C_WRITE;
	dev = minor(bp->b_dev);
	lastdev=dev;
	motor_on();
	addr=bp->b_xmem+(word)(bp->b_addr);

	blk = bp->b_blkno;
	cyl = (int)(blk / (NHEAD * sectors[dev]));
	sec = (int)(blk % sectors[dev])+1;
	head= (int)(blk % (NHEAD * sectors[dev])) / sectors[dev];
	cnt = (-bp->b_wcount)*2; 

	fdtab.d_errcnt=0;

	wantreset=0;
	fdistart();
	}
fdistart()
	{
	int i;
	int dev=lastdev;
	register word save;
	register struct buf *bp=fdtab.d_actf;

	if (fdtab.d_errcnt>5)
		{
ERROR:		prdev("General error",MAJOR<<8|dev);
		save=lock1();
		fdtab.d_active=0;
		fdtab.d_actf=bp->av_forw;
		bp->b_flags|=B_ERROR; 
		unlock(save);
		iodone(bp);
		fdstart();
		return;
		}

	if(wantreset)
		{
		fdc_reset();
		return;
		}
	if(!calib[dev])
		{
		if(recalibrate())
			goto ERROR;
		return;
		}
		 
	if(fdseek(dev)==1)	/* ha mar a megfelelo cylinderen vagyunk */
		{
		if (fdrdwr(dev))
			goto ERROR;
		return;
		}
	else
		{
		return;
		}
	}
fdrdwrit()
	{
	register int dev=lastdev;
	register int r;

	r=fresult();
	if (r!=OK)
		{
		 prdev("Gen error",MAJOR<<8|dev);
		 return(-1);
		 }
	if ((result[dev][ST1]&BAD_SECTOR)||(result[dev][ST2]&BAD_CYL))
		{
		prdev("Head misplace",MAJOR<<8|dev);
		calib[dev]=0;
		return(-1);
		}
	if (result[dev][ST1]&WRITE_PROTECT)
		{
		prdev("Write protect",MAJOR<<8|dev);
		fdtab.d_errcnt=99;
		return(-1);
		}
	if (((result[dev][ST0]&ST0_BITS)!=TRANS_ST0)||(result[dev][ST1]|
		result[dev][ST2]))
		{
		prdev("Transfer error",MAJOR<<8|dev);
		return(-1);
		}
	r= (result[dev][ST_CYL]-cyl)*NHEAD*sectors[dev];
	r+=(result[dev][ST_HEAD]-head)*sectors[dev];
	r+=(result[dev][ST_SEC]-sec);
	if (r*SECTOR_SIZE!=cnt)
		{
		prdev("Transfer count mismatch",MAJOR<<8|dev);
		return(-1);
		}
	return(0);
	}

fdrdwr()
	{
	register int dev=lastdev;
	register int op;

	fdtab.d_active=L_RDWR;
	outbyte(FDC_RATE,rate[dev]);
	op=(mode==C_READ) ? FDC_READ : FDC_WRITE;
	set_dma ();

	fdc_out(op);
	fdc_out((head<<2)|dev);
	fdc_out(cyl);
	fdc_out(head);
	fdc_out(sec);
	fdc_out(2);	/* sector hossz	*/
	fdc_out(sectors[dev]);
	fdc_out(gap[dev]);
	fdc_out(0xff);
	if (wantreset)
		{     
		printf ("pgm not OK!\n");
		return(-1);
		}
		
	return(0);
        }

	
set_dma()
	{                                               
	register int taddr,tend;
	dword save;


	taddr= (byte)((addr >>16)&0xff);
	tend = (byte)(((addr+cnt-1)>>16)&0xff);

	if (addr==0)
		panic("FD ADDR==0");	/* biztosan rossz cim		*/

	if (tend != taddr)		/* dma 64k hataron at!?		*/
		panic("FD DMA 64K");

	save=lock1();
	outbyte (DMA_TOP,(byte)taddr);
	outbyte (DMA_M2,(mode == C_READ) ? DMA_READ : DMA_WRITE);
	outbyte (DMA_M1,(mode == C_READ) ? DMA_READ : DMA_WRITE);
	outbyte (DMA_ADDR,(byte)(addr      &0xff));
	outbyte (DMA_ADDR,(byte)(addr >>8) &0xff);
	outbyte (DMA_COUNT,(byte)(cnt-1)     &0xff);
	outbyte (DMA_COUNT,(byte)((cnt-1)>>8)&0xff);

	outbyte (DMA_INIT,2);
	unlock(save);

	}

/* floppy interrupt ide erkezik						*/
fdc_intr()         
	{
	int r;
	register struct buf *bp;
	register word save;
	outbyte (0x3c,0x02);
	intack1();
	bp=fdtab.d_actf;

	switch(fdtab.d_active)
		{
		case L_RDWR:
			if (fdrdwrit())
				{
				++fdtab.d_errcnt;
				fdistart();
				break;
				}
			save=lock1();
			fdtab.d_active=0;
			fdtab.d_actf=bp->av_forw;
			unlock(save);
			iodone(bp);
			motor_off();
			fdstart();
			break;

		case L_SEEK:
			{
			r=seekit();
			if (r==-1)
				{
				++fdtab.d_errcnt;
				fdistart();
				break;
				}
			if(fdrdwr())
				{
				++fdtab.d_errcnt;
				fdistart();
				break;
				}
			break;
			}
		case L_RECAL:
			{
			if(recalit())
				{
				++fdtab.d_errcnt;
				}
			fdistart();
			break;
			}
		case L_RESET:
			{
			if(resetit())	/* megjott az it a resetrol	*/
				{
				++fdtab.d_errcnt;
				}
			fdistart();
			break;
			}
		default :
			{
		prdev("Unexpected interrupt",MAJOR<<8|fdtab.d_active);
			fdstart();

			}
		}
	return;

ERROR:	bp->b_flags|=B_ERROR;
	iodone(bp);
	motor_off();
	fdtab.d_active=L_NO;
	return;
	}


motor_on()
	{
	register int dev=lastdev;
	register word save;
	byte new_mot;

	save=lock1();

	dev=minor(dev);
	new_mot=1<<(dev+4);	/* az adott egyseg motorja	*/
	new_mot|=0x30;
	dev_busy|=new_mot;	/* nehogy timer kikapcsolja	*/
	if (dev_moton&new_mot)
		{
		dev_moton|=new_mot;
		outbyte (DOR,dev_moton|ENBL_INT|(dev&3));
		unlock(save);
		return;		/* mar mukodik a motor		*/
		}	
	dev_moton|=new_mot;
	dev_moton&=0x30;
		
	outbyte (DOR,dev_moton|ENBL_INT|(dev&3));
	timeout (wakeup,&dev_moton,msetup[dev]);
	sleep (&dev_moton,PRIBIO);
	unlock(save);
	return;
	}
/* callout altal hivott motor kikapcsolas			*/
motor_offt(dev)
int dev;
	{
	static byte bit;
	bit = 1<<(4+dev);
	if (dev_busy&bit)	/* ujra hasznaljak, nem kell kikapcsolni*/
		return;
	dev_moton&=(~bit)&0xf0;		/* az uj motor status			*/

	outbyte(DOR,dev_moton|ENBL_INT|(lastdev&3));
	}

motor_off()
	{
	register int dev=lastdev;
	dev_busy&=~(1<<(dev+4));
	timeout(motor_offt,dev,mtoff[dev]);
	}
/* status kiolvasasa							*/
fresult()
	{
	int i,j,k,r,s,dev=lastdev;

	for (i=0;i<8;i++)
		{
		r=0;
		for (j=0;j<MAX_FDC_RETRY;j++)
			{
			for (k=0;k<40;k++);
			s=inbyte(FDC_STATUS);
			if (s&MASTER)
				{
				r=1;
				break;
				}
			}
		if (r==0)
			{
			printf ("TOUT\n");
			return(-1);
			}
		if ((s&CTL_BUSY)==0)
			return(OK);
		if ((s&DIRECTION)==0)
			{
			printf("DIR\n");
			return(-1);
			}
		s=inbyte(FDC_DATA);
		result[dev][i]=s&0xff;
		}
	wantreset=1;
	printf("MORE\n");
	return(-1);
	}
seekit()
	{
	register int dev=lastdev;

	fdc_out(FDC_SENSE);
	oncyl[dev]=-1;
	fresult();
	if ((result[dev][ST0]&ST0_BITS)!=SEEK_ST0)
		{
		printf("noseek\n");
		return(-1);
		}
	if (result[dev][ST1]!=cyl)
		{
		printf("nocyl\n");
		calib[dev]=0;
		return(-1);
		}
	oncyl[dev]=cyl;
	return(0);
	}

fdseek()
	{
        int dev=lastdev;
	if (cyl==oncyl[dev])
		return(1);
	fdtab.d_active=L_SEEK;
	fdc_out(FDC_SEEK);
	fdc_out(dev|(head<<2));
	fdc_out(cyl);
	if (wantreset)
		{
		prdev ("BAD SEEK",MAJOR<<8|dev);
		return (-1);
		}
	return(0);
	}
/* recalibrate int							*/
recalit()
	{
	register int res;
	register int dev=lastdev;

	fdc_out(FDC_SENSE);
	res=fresult(dev);
	oncyl[dev]=-1;
	if ((res!=OK)||((result[dev][ST0]&ST0_BITS)!=SEEK_ST0)||
		(result[dev][ST_PCN]!=0))
		{
		wantreset=1;
		calib[dev]=0;
		oncyl[dev]=-1;
		prdev("Recalibrate error",MAJOR<<8|dev);
		return(-1);
		}

	  else
		{
		calib[dev]=1;
		oncyl[dev]=0;
		return(0);
		}
	}

/* recalibrate								*/
recalibrate ()
	{
	register int dev=lastdev;
	fdtab.d_active=L_RECAL;
	lastdev=dev;
	fdc_out(FDC_RECALIBRATE);
	fdc_out(dev&3);
	if (wantreset)
		{
		return(-1);	/* halott az fdc			*/
		}
	return(0);
	}


/* kiad 1 byte-ot a kontrollernek, ha az halott reseteli		*/

fdc_out(c)
byte c;
	{
	register int try,r;
	try = MAX_FDC_RETRY;
	if (wantreset)
		{
		return;
		}
	while (try-->0)
		{
		r=inbyte(FDC_STATUS);
		r&=(MASTER|DIRECTION);
		if (r!=CTL_ACCEPTING)
			continue;
		outbyte (FDC_DATA,c);
		return;
		}
	wantreset=1;
	}

/* reset utani interrupt 						*/

resetit()
	{
	fdc_out(FDC_SENSE);
	if (wantreset)
		{
		prdev("Controller faliure",MAJOR<<8);
		return(-1);
		}
	fresult(0);
	fdc_out(FDC_SPECIFY);
	fdc_out(SPEC1);
	fdc_out(SPEC2);
	return(0);
	}

/* reseteli a kontrollert 						*/

fdc_reset()
	{
	register word save;
	register int i;

	save=lock1();
	wantreset=0;
	fdtab.d_active=L_RESET;
	printf ("FDC RESET\n");
	dev_busy=dev_moton=0;
	for (i=0;i<=nunit;i++);
		{
		oncyl[i]=-1;
		calib[i]=0;
		}
	outbyte(DOR,0);		/* reszet le				*/
	outbyte(DOR,ENBL_INT);	/* bekapcsolni				*/
	unlock(save);
	}

