/*      ## CO.C ##
	(c) Szigeti Szabolcs 2 apr 1992

	IBM AT 102 gombos billentyuzet					*/

#include "h\param.h"
#include "h\user.h"
#include "h\proc.h"
#include "h\glo.h"
#include "h\machine.h"
#include "h\co.h"

#include "h\tty.h"

extern	struct tty coat;
extern int video;
static byte km_next,km_flag; 	/* tobb bytos parancs tovabbi byte 	*/
static byte km_break;		/* a kovetkezo kod break		*/
static byte km_sh,km_ash,km_lsh;

byte	scantab[3][8*16]=
	{
	{
/* normal 0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f  */

/*  0 */  0,  0,  0,  0,  0,  0,  0,  0, 27,  0,  0,  0,  0,  9,'`',  0,
/* 10 */  0,  0,  0,  0,  0,'q','1',  0,  0,  0,'z','s','a','w','2',  0,
/* 20 */  0,'c','x','d','e','4','3',  0,  0,' ','v','f','t','r','5',  0,
/* 30 */  0,'n','b','h','g','y','6',  0,  0,  0,'m','j','u','7','8',  0,
/* 40 */  0,',','k','i','o','0','9',  0,  0,'.','/','l',';','p','-',  0,
/* 50 */  0,  0, 39,',','[','=',  0,  0,  0,  0, 13,']', 92,  0,  0,  0,
/* 60 */  0,  0,  0,  0,127,  0,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 70 */  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,

	},
	{
/* shift  0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f  */

/*  0 */  0,  0,  0,  0,  0,  0,  0,  0, 27,  0,  0,  0,  0,  9,'~',  0,
/* 10 */  0,  0,  0,  0,  0,'Q','!',  0,  0,  0,'Z','S','A','W','@',  0,
/* 20 */  0,'C','X','D','E','$','#',  0,  0,' ','V','F','T','R','%',  0,
/* 30 */  0,'N','B','H','G','Y','^',  0,  0,  0,'M','J','U','&','*',  0,
/* 40 */  0,'<','K','I','O',')','(',  0,  0,'>','?','L',':','P','_',  0,
/* 50 */  0,  0, 34,'<','{','+',  0,  0,  0,  0, 13,'}','|',  0,  0,  0,
/* 60 */  0,  0,  0,  0,127,  0,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 70 */  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,

	},
	{
/* caps   0   1   2   3   4   5   6   7   8   9   a   b   c   d   e   f  */

/*  0 */  0,  0,  0,  0,  0,  0,  0,  0, 27,  0,  0,  0,  0,  9,'`',  0,
/* 10 */  0,  0,  0,  0,  0,'Q','1',  0,  0,  0,'Z','S','A','W','2',  0,
/* 20 */  0,'C','X','D','E','4','3',  0,  0,' ','V','F','T','R','5',  0,
/* 30 */  0,'N','B','H','G','Y','6',  0,  0,  0,'M','J','U','7','8',  0,
/* 40 */  0,',','K','I','O','0','9',  0,  0,'.','/','L',';','P','-',  0,
/* 50 */  0,  0, 39,',','[','=',  0,  0,  0,  0, 13,']', 92,  0,  0,  0,
/* 60 */  0,  0,  0,  0,127,  0,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 70 */  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,

	}
	};
extern struct clist prob,cfreelist;
waitcon()
	{
	while(inbyte(KBCTL)&KR_IBF) asm {nop; nop; nop; nop;}
        }

/*	t_coint():
		billentyuzet interrupt 					*/
corint()
	{
	static byte sc,ks;		/* scan code,status	*/
	lock();
	intack1();

	ks=inbyte(KBCTL);

	if (!(ks&KR_OBF))
		goto OUT;

	sc=inbyte(KBDAT);

/************************************************************************/
/*		DEBUG	DEBUG	DEBUG	DEBUG	DEBUG			*/

	if (sc==1)//&&(km_sh&8))
		{
		asm cli;
		closedevices();	/*	***ESC***	*/
		}
/*    		DEBUG	DEBUG	DEBUG	DEBUG	DEBUG			*/
/************************************************************************/

	switch	(sc)
		{
		case KK_BRPREF:	km_break=1;
				break;

		case KK_ACK:	if(km_flag)
					{
					km_flag=0;
					outbyte(KBDAT,km_next);
					}
                                break;
		case SC_CAPSL:	km_sh^=4;
				break;
		case SC_NUML:	km_sh^=2;
				break;
		case SC_SCRL:   coat.t_state^=STOP;
				if ((coat.t_state&STOP)==0)
					wakeup(&coat.t_outq);
				break;
		case SC_LSHF:   if (km_break)	{km_break=0;km_ash&=~1;}
				else            {km_ash|=1;}
				if (km_ash&9)	{km_sh|=8;}
                                else		{km_sh&=~8;}
				break;
		case SC_RSHF:   if (km_break)	{km_break=0;km_ash&=~8;}
				else            {km_ash|=8;}
				if (km_ash&9)	{km_sh|=8;}
                                else		{km_sh&=~8;}
				break;

		case SC_LCTR:	if (km_break)	{km_break=0;km_ash&=~2;}
				else            {km_ash|=2;}
				if (km_ash&18)	{km_sh|=16;}
				else		{km_sh&=~16;}
				break;
		case SC_RCTR:	if (km_break)	{km_break=0;km_ash&=~16;}
				else            {km_ash|=16;}
				if (km_ash&18)	{km_sh|=16;}
				else		{km_sh&=~16;}
				break;

		case SC_LALT:   if (km_break)	{km_break=0;km_ash&=~4;}
				else            {km_ash|=4;}
				if (km_ash&36)	{km_sh|=32;}
				else		{km_sh&=~32;}
				break;
		case SC_RALT:   if (km_break)	{km_break=0;km_ash&=~32;}
				else            {km_ash|=32;}
				if (km_ash&36)	{km_sh|=32;}
				else		{km_sh&=~32;}
				break;

		default:
				if (!(km_sh&12)) 	/* normal */
					sc=scantab[0][sc];
				else
					if (km_sh&8) 	/* shift */
						sc=scantab[1][sc];
					else            /* caps lock */
						sc=scantab[2][sc];

				if (!sc) goto OUT; 	/* ervenytelen */
				if (sc==127) sc=0;
				if ((km_sh&16)&&(sc>63))
					{
					sc&=95;
					sc-=64;		/* controll */
					}
				ttyinput(sc,&coat);
		}

	if (coat.t_state&STOP)
		km_sh|=1;
	else
		km_sh&=~1;

	if (km_sh!=km_lsh)
		{
		km_flag=1; km_next=km_sh&7;
		outbyte (KBDAT,KB_SETIND);
		km_lsh=km_sh;
		}
OUT:	enable();


	}


initcon()
	{
	initkeyb();
	initvid();

	}

initkeyb()
	{
	register int save,i;
	save=lock1();
	outbyte(KBCTL,KC_READINP);
	for (i=0;i<30;i++);
	if (inbyte(KBDAT)&64)
		video=1;
	else
		video=0;
	waitcon();
	inbyte(KBDAT);
	outbyte(KBCTL,KC_WRITEST);
	waitcon();
	inbyte(KBDAT);
	outbyte(KBDAT,KW_PCMOD|KW_FLAG|KW_INTR);
	waitcon();
	inbyte(KBDAT);
	outbyte(KBDAT,KB_SELSCAN);
	waitcon();
	inbyte(KBDAT);
	outbyte(KBDAT,3);
	waitcon();
	inbyte(KBDAT);
	waitcon();
	outbyte(KBDAT,KB_ALLTM);	/* mindenki ismetel */
	waitcon();
	inbyte(KBDAT);
	i=0;
	while (keymode[i].scan)
		{
		outbyte(KBDAT,keymode[i].type);
		waitcon();
		inbyte (KBDAT);
		outbyte(KBDAT,keymode[i++].scan);
		waitcon();
		inbyte (KBDAT);
		}
	outbyte(KBDAT,KB_ENABLE);
	waitcon();
	inbyte(KBDAT);
	unlock(save);
	}
closecon()
	{
	closekeyb();
	closevid();
	}
closekeyb()
	{
	outbyte(KBDAT,KB_SELSCAN);
	waitcon();
	inbyte(KBDAT);
	outbyte(KBDAT,2);
	waitcon();
	inbyte(KBDAT);
	outbyte (KBCTL,KC_WRITEST);
	waitcon();
	outbyte (KBDAT,KW_PCCOM|KW_INTR|KW_FLAG);
	waitcon();
	outbyte (KBDAT,KB_SETRATE);
	waitcon();
	inbyte(KBDAT);
	outbyte (KBDAT,0);
	waitcon();
	}
