#include "param.h"
#include "systm.h"
#include "callo.h"
#include "dir.h"
#include "signal.h"
#include "seg.h"
#include "ipm.h"
#include "sid.h"
#include "user.h"
#include "proc.h"
#include "text.h"
#include "psl.h"

/*
 * clock is called straight from
 * the real time clock interrupt.
 *
 * Functions:
 *	reprime clock
 *	implement callouts
 *	maintain user/system times
 *	maintain date
 *	profile
 *	alarm clock signals
 *	jab the scheduler
 */



time_t	time, lbolt;
struct	load_info	{
	int	runque;
	int	runocc;
	int	swpque;
	int	swpocc;
} load_info;

extern	int selwait;



clock(r0,r1,r2,r3,r4,r5,r6,r7,r8,r9,r10,r11,r12,r13,r14,r15,pc,ps)
	caddr_t pc;
{
	register struct callo *p1, *p2;
	register struct proc *pp;
	register a;
	static short lticks;
	static rqlen, sqlen;
	extern caddr_t waitloc;

	if(clkreld(1)) 
		return;

	a = dk_busy & 07;
	if (USERMODE(ps)) {
		u.u_utime++;
		if (u.u_prof.pr_scale)
			addupc(pc, &u.u_prof, 1);
		if (u.u_procp->p_nice > NZERO)
			a += 8;
	} else {
		a += 16;
		if (pc == waitloc)
			a += 8;
		u.u_stime++;
	}
	dk_time[a] += 1;
	pp = u.u_procp;
	if (pp->p_stat == SRUN) {
		u.u_mem += (unsigned)pp->p_size;
		if (pp->p_textp) {
			a = pp->p_textp->x_ccount;
			if (a==0)
				a++;
			u.u_mem += pp->p_textp->x_size/a;
		}
	}
	if (pp->p_cpu < 80)
		pp->p_cpu++;
	lbolt++;	/* time in ticks */
	if (--lticks <= 0) {
		if (BASEPRI(ps))
			return;
		lticks += HZ;
		time = rtc_to_l();
		runrun++;
		rqlen = 0;
		sqlen = 0;
		wakeup((caddr_t) &lbolt);
		for (pp = &proc[0]; pp < &proc[NPROC]; pp++)
		if (pp->p_stat) {
			if (pp->p_time != 127)
				pp->p_time++;
			if (pp->p_clktim)
				if (--pp->p_clktim == 0)
					psignal(pp, SIGALRM);
			if (pp->p_seltim)
				if (--pp->p_seltim == 0)
					wake1up(&selwait, pp);
			pp->p_cpu >>= 1;
			if (pp->p_pri >= (PUSER-NZERO)) {
				pp->p_pri = (pp->p_cpu>>1) + PUSER +
					pp->p_nice - NZERO;
			}
			if (pp->p_stat == SRUN)
				if (pp->p_flag & SLOAD)
					rqlen++;
				else
					sqlen++;
		}
		if (rqlen) {
			load_info.runque += rqlen;
			load_info.runocc++;
		}
		if (sqlen) {
			load_info.swpque += sqlen;
			load_info.swpocc++;
		}
		if (runin!=0) {
			runin = 0;
			setrun(&proc[0]);
		}
	}

	/*
	 * if any callout active, update first non-zero time
	 */

	if (callout[0].c_func == NULL)
		return;
	p2 = &callout[0];
	while (p2->c_time <= 0 && p2->c_func != NULL)
		p2++;
	p2->c_time--;
	/*
 	 * If ps is high, just return
	 */
	if (BASEPRI(ps))
		return;
	/*
	 * Callout.
	 */
	if (callout[0].c_time <= 0) {
		p1 = &callout[0];
		while (p1->c_func != NULL && p1->c_time <= 0) {
			a = splsoftclock();
			(*p1->c_func)(p1->c_arg);
			splx(a);
			p1++;
		}
		p2 = &callout[0];
		while (p2->c_func = p1->c_func) {
			p2->c_time = p1->c_time;
			p2->c_arg = p1->c_arg;
			p1++;
			p2++;
		}
	}
}

/*
 * timeout is called to arrange that fun(arg) is called in tim/HZ seconds.
 * An entry is sorted into the callout structure.
 * The time in each structure entry is the number of HZ's more
 * than the previous entry. In this way, decrementing the
 * first entry has the effect of updating all entries.
 *
 * The panic is there because there is nothing
 * intelligent to be done if an entry won't fit.
 */

timeout(fun, arg, tim)
	int (*fun)();
	caddr_t arg;
{
	register struct callo *p1, *p2;
	register int t;
	int s;

	t = tim;
	p1 = &callout[0];
	s = splhigh();
	while(p1->c_func != 0 && p1->c_time <= t) {
		t -= p1->c_time;
		p1++;
	}
	if (p1 >= &callout[NCALL-1])
		panic("Timeout table overflow");
	p1->c_time -= t;
	p2 = p1;
	while(p2->c_func != 0)
		p2++;
	while(p2 >= p1) {
		(p2+1)->c_time = p2->c_time;
		(p2+1)->c_func = p2->c_func;
		(p2+1)->c_arg = p2->c_arg;
		p2--;
	}
	p1->c_time = t;
	p1->c_func = fun;
	p1->c_arg = arg;
	splx(s);
}

/*
 * untimeout will search for a callout entry with a matching
 * func and arg entry, then remove it, closing the hole.
 */

untimeout(func, arg)
	int (*func)();
	caddr_t arg;
{
	register struct callo *p;
	register s;

	s = splhigh();
	p = &callout[0];
	while (p->c_func && (p->c_func != func || p->c_arg != arg))
		p++;
	if (p->c_func == 0) {
		splx(s);
		return;		/* nothing to remove */
	}

	/* otherwise, we have an entry to toss */

	if ((p+1)->c_func)
		(p+1)->c_time += p->c_time;	/* give time to next */
	while (p->c_func) {
		*p = *(p+1);
		p++;
	}
	splx(s);
}


clkset(t)		/* set the time */
time_t t;
{
	if (rtcrun())
		time = rtc_to_l();
	else {
		/* 
		 * restart chip and set chip 
		 * and sys time from disk 
		 */
		time = t;
		rtcstart();
		rtcset(t);
	}
}
