/* loopback.c: internet loop back device */

#include "param.h"
#include "types.h"
#include "errno.h"
#include "stream.h"


int	lbsrv();
extern	putq(), srv(), nullsys();

struct	qinit	lbqinit[] = {
/* up */ { putq, srv, nullsys, nullsys, 1000, 16 },
/* dn */ { putq, lbsrv, nullsys, nullsys, 1000, 16 }
};


lbsrv(q)	/* loop back */
	register struct queue *q;
{
	while (q->first && (OTHERQ(q)->flag & QFULL) == 0) {
		qreply(q, getq(q));
	}
	if (q->first)
		q->next->flag |= QWANTW;
}
