/* interrupt/trap handler */


/*
 * Table of offset for things in interrupt routines.
 *
 * The top of the stack at the time of the interrupt is:
 *
 *	sp->	Status register
 *	+6	Vector/cause
 *	+4	pc lo 
 *	+2	pc hi
 *	sp->	status
 *
 *	There may be more stuff you want above the vector.
 *
 * After we save the registers and mash things around to make
 * the C calls arguments convenient the stack looks thus:
 *
 *	offset	index	register
 *	+46		vector/cause
 *	+44	17	status register
 *	+40	16	pc
 *	+3c	15	sp
 *	+38	14	a6
 *	+34	13	a5
 *	+30	12	a4
 *	+2c	11	s3
 *	+28	10	a2
 *	+24	 9	a1
 *	+20	 8	a0
 *	+1c	 7	d7
 *	+18	 6	d6
 *	+14	 5	d5
 *	+10	 4	d4
 *	+0c	 3	d3
 *	+08	 2	d2
 *	+04	 1	d1
 *	sp->	 0	d0
 */

	.data
fr_size:
	.long	8, 8, 12, 8, 8, 8, 8, 8
	.long	58, 20, 32, 92, 8, 8, 8
	.text

	.set	SP,0x3c
	.set	PS,0x44		/* offset after juggle */
	.set	TTYPE,0x46
	.text
	nop
	nop
	.globl	buserr
	.globl	nullvect

	.data
saved_sr:	.word	0
saved_vo:	.word	0
saved_a0:	.long	0
saved_d0:	.long	0
	.text

buserr:
	tstl	nofault
	beq	nullvect
	movw	sp@,saved_sr		/* save the status for later */
	movl	a0,saved_a0		/* must preserve all regs */
	movl	d0,saved_d0
	clrl	d0
	movl	d0,a0
	movw	sp@(6),d0		/* get the vector word */
	movw	d0,a0
	andw	#0xfff,d0		/* mask out the format number */
	movw	d0,saved_vo		/* save for later */
	movw	a0,d0			/* get the original vector word */
	lsrw	#8,d0			/* turn into offset in size table */
	lsrw	#2,d0
	lea	fr_size,a0		/* get the address of the size table */
	addl	d0,a0			/* point to stip amount */
	addl	a0@,sp			/* strip back the stack */
	movw	saved_vo,sp@-		/* push vo */
	movl	nofault,sp@-		/* push no fault address */
	movw	saved_sr,sp@-		/* finish the new exception frame */
	movl	saved_a0,a0
	movl	saved_d0,d0
	rte

	.globl	pccacfailint, pccberrint, pccabortint, pcclanint
	.globl	pccscsiportint, pccscsidmaint, pccprinterint
	.globl	pccserialint
	.globl	pcctick1int, pcctick2int, pccsi1int, pccsi2int

pccscsiportint:
	movml	#0xffff,sp@-
	movl	#_pccscsiportintr,a0
	bra	call

	.globl	zixint
zixint:
	movml	#0xffff,sp@-
	movl	#_zixintr,a0
	bra	call

	.globl	zisrint
zisrint:
	movml	#0xffff,sp@-
	movl	#_zisrintr,a0
	bra	call

	.globl	zieint
zieint:
	movml	#0xffff,sp@-
	movl	#_zieintr,a0
	bra	call

	.globl	zirint
zirint:
	movml	#0xffff,sp@-
	movl	#_zirintr,a0
	bra	call

pcctick1int:
	movml	#0xffff,sp@-
	movl	#_clock,a0
	bras	call

pccabortint:
	movml	#0xffff,sp@-
/*	movl	#_pccabort,a0*/
	movl	#_trap, a0
	bras	call

pcclanint:
	movml	#0xffff,sp@-
	movl	#_enintr,a0
	bras	call

pccsi1int:
	movml	#0xffff,sp@-
	movl	#_stintr,a0
	bras	call

/* 
 * interrupt code for ncm
 */

	.globl	cmint
cmint:
	movml	#0xffff, sp@-
	movl	#_cmintr, a0
	bras 	call

	.globl	cm2int
cm2int:
	movml	#0xffff, sp@-
	movl	#_cm2intr, a0
	bras	call

	.globl	cmfifoint
cmfifoint:
	movml	#0xffff, sp@-
	movl	#_cmfifointr, a0
	bras	call

	.globl	pimint
pimint:
	movml	#0xffff,sp@-
	movl	#_pimintr,a0
	bras	call

pccacfailint:
pccberrint:
pccserialint:
pccscsidmaint:
pccprinterint:
pcctick2int:
pccsi2int:
nullvect:
	movml	#0xffff,sp@-
	movl	#_trap,a0
	/* fall thru */

call:
	movw	sp@(0x40), d0		/* juggle the sr and pc to line up */
	movl	sp@(0x42), d1		/*  so that pc is long aligned */
	movl	d1,sp@(0x40)
	movw	d0, sp@(0x44)
	movl	usp, a1
	movl	a1, sp@(SP)		/* get a copy of the user stack ptr */
	jsr	a0@
	btst	#5,sp@(PS)		/* if prev mode was kernel */
	bne	1f			/*   don't check runrun */
	tstb	_runrun			/* if nobody else needs to run */
	beq	1f			/*   just return */
/*	movw	#0x2000,sr		/* why did v7 do this??? */
	andw	#0xf000, sp@(TTYPE)	/* call trap with resched type */
	jsr	_trap
1:
	movl	sp@(SP), a1
	movl	a1, usp
	movl	sp@(0x40), d1		/* get the frame back the way */
	movw	sp@(0x44), d0		/* the processor likes it */
	movw	d0, sp@(0x40)
	movl	d1, sp@(0x42)
	movml	sp@+, #0x7fff		/* load everything */
	addl	#4, sp			/* toss ksp */
	rte
