/*
 * The user structure.
 * One allocated per process.
 * Contains all per process data that doesn't need to be referenced
 * while the process is swapped.
 * The user block is USIZE*click bytes long; resides at virtual kernel
 * loc 0x7ffff800(vax), 0140000(11/70), floating(11/34),
 * 0x40000000 (68030);
 * contains the system stack per user; is cross referenced
 * with the proc structure for the same process.
 */
 
#define	EXCLOSE	01

struct	user	{
	long	u_pte[NPTE];		/* must be first!  message space */
	label_t	u_rsav;			/* save info when exchanging stacks */
	label_t	u_qsav;			/* label variable for quits and intrs */
	label_t	u_ssav;			/* label variable for swapping */
	char	u_segflg;		/* IO flag: 0:UD; 1:S; 2:UI */
	char	u_error;		/* return error code */
	u_short	u_uid;			/* effective user id */
	u_short	u_gid;			/* effective group id */
	u_short	u_ruid;			/* real user id */
	u_short	u_rgid;			/* real group id */
	struct proc *u_procp;		/* pointer to proc structure */
	int	*u_ap;			/* pointer to arglist */
	union {				/* syscall return values */
		struct	{
			int	r_val1;
			int	r_val2;
		}r_reg;
		off_t	r_off;
		time_t	r_time;
	} u_r;
	caddr_t	u_base;			/* base address for IO */
	unsigned u_count;		/* bytes remaining for IO */
	off_t	u_offset;		/* offset in file for IO */
	struct	inode *u_cdir;		/* current directory of process */
	struct	inode *u_rdir;		/* root directory of process */
	caddr_t	u_dirp;			/* pathname pointer */
	char	u_dbuf[DIRSIZ];		/* current pathname component */
	struct	direct u_dent;		/* current directory entry */
	struct	inode *u_pdir;		/* inode of parent directory of dirp */
	struct	file *u_ofile[NOFILE];	/* pointers to file structures of open files */
	char	u_pofile[NOFILE];	/* per-process flags of open files */
	int	u_arg[10];		/* arguments to current system call */
	u_int	u_tsize;		/* text size (clicks) */
	u_int	u_dsize;		/* data size (clicks) */
	u_int	u_ssize;		/* stack size (clicks) */
	int	u_signal[NSIG];		/* disposition of signals */
	time_t	u_utime;		/* this process user time */
	time_t	u_stime;		/* this process system time */
	time_t	u_cutime;		/* sum of childs' utimes */
	time_t	u_cstime;		/* sum of childs' stimes */
	int	*u_ar0;			/* address of users saved R0 */
	struct {			/* profile arguments */
		short	*pr_base;	/* buffer base */
		unsigned pr_size;	/* buffer size */
		unsigned pr_off;	/* pc offset */
		unsigned pr_scale;	/* pc scaling */
	} u_prof;
	short	*u_ttyp;		/* pointer to pgrp in "tty" struct */
	dev_t	u_ttyd;			/* controlling tty dev */
	struct {			/* header of executable file */
		unsigned ux_mag;	/* magic number */
		unsigned ux_tsize;	/* text size */
		unsigned ux_dsize;	/* data size */
		unsigned ux_bsize;	/* bss size */
		unsigned ux_ssize;	/* symbol table size */
		unsigned ux_entloc;	/* entry location */
		unsigned ux_unused;
		unsigned ux_relflg;
	} u_exdata;
	char	u_comm[DIRSIZ];
	time_t	u_start;
	time_t	u_ticks;
	long	u_mem;
	long	u_ior;
	long	u_iow;
	long	u_iosw;
	long	u_ioch;
	char	u_acflag;
	short	u_cmask;		/* mask for file creation */
	short	u_traptype;		/* records the type of last trap */
#define TRAPNORM 0			/* "normal" trap */
#define TRAPBUS	 1			/* bus error trap */
#define TRAPADDR 2			/* address error trap */
#define TSAVSIZE 43			/* size of long format save area */
	short   u_trapsave[TSAVSIZE];	/* long format save area */
	short   u_trapvalid;		/* flag that trapsave has valid info */
	struct	mesg	*u_msglist;	/* messages allocated by user */
	struct	segment	u_proto[3];	/* prototype segment entries */
	struct	stdata	*u_stream;	/* current stream */
	int	u_stflag;		/* stream state of proc */
	int	u_stack[1];
					/* kernel stack per user
					 * extends from u + USIZE * 512 - 16
					 *    (the size of the upte)
					 * backward not to reach here
					 */
};



extern struct user u;

#define	u_rval1	u_r.r_reg.r_val1
#define	u_rval2	u_r.r_reg.r_val2
#define	u_roff	u_r.r_off
#define	u_rtime	u_r.r_time

