/*
**	Sky board (IEEE) versions of frexp, ldexp, modf
*/

# include <errno.h>
int errno;

static
union foo {
	double ddat;
	struct foo2 {
		long l1;
		long l2;
	} ldat;
} dat;

double
frexp(value, eptr)
double value;
int *eptr;
{

	dat.ddat = value;
	*eptr = ((dat.ldat.l1 & 0x7ff00000) >> 20) - 1022;
	dat.ldat.l1 = (dat.ldat.l1 & ~0x7ff00000) | 0x3fe00000;
	return (dat.ddat);
}

double
ldexp(value, exp)
double value;
int exp;
{
	int vexp;

	dat.ddat = value;
	vexp = (dat.ldat.l1 & 0x7ff00000) >> 20;
	vexp += exp;
	if (vexp > 0x7ff) { /* deal with large exponent */
	/* Figure out later what to do with denormalized */
		errno = EDOM;
		if (dat.ldat.l1 & 0x80000000)
			dat.ldat.l1 = 0xffffffff;
		else
			dat.ldat.l1 = 0x7fffffff;
		dat.ldat.l2 = 0xffffffff;
		return (dat.ddat);
	}
	else if (vexp < 0) {
		errno = EDOM;
		if (dat.ldat.l1 & 0x80000000)
			return (-0.);
		else
			return (0.);
	}
	else {
		dat.ldat.l1 &= ~0x7ff00000;
		dat.ldat.l1 |= (vexp << 20);
		return (dat.ddat);
	}
}

double
modf(value, iptr)
double value, *iptr;
{
	int negflg = 0;
	int exp;
	double tval, tint;

	if (value < 0) {
		negflg = 1;
		value = -value;
	}
	dat.ddat = value;
	exp = ((dat.ldat.l1 & 0x7ff00000) >> 20) - 1023;
	if (exp <= -1) {
		tval = value;
		tint = 0.;
	}
	else if (exp <= 20) {
		dat.ldat.l1 &= (-1 << (20 - exp));
		dat.ldat.l2 = 0;
		tint = dat.ddat;
		tval = value - tint;
	}
	else if (exp <= 52) {
		dat.ldat.l2 &= (-1 << (52 - exp));
		tint = dat.ddat;
		tval = value - tint;
	}
	else {
		tval = 0.;
		tint = value;
	}
	
	*iptr = (negflg ? -tint : tint);
	return (negflg ? -tval : tval);
}
