/* remroutes.c: Purge all routes from the route table */
#include <stdio.h>
#include <stdarg.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/inet/in.h>
#include <sys/inio.h>
#include <sys/inet/ip_var.h>

#define	IPDEV "/dev/ip3"
int	ipfd;
char	*progname;

main(argc, argv)
	int argc;
	char *argv[];
{
	FILE *fp;
	FILE *popen();
	struct route route;
	char line[BUFSIZ];
	char dest[128], gate[128];
	int n;

	progname = argv[0];
	ipfd = ipopen();
	if ((fp = popen("/bin/netstat -r", "r")) == NULL)
		error("Can't run netstat");
	while (fgets(line, sizeof line, fp)) {
		if (line[0] == 'D')
			continue;
		if (line[0] == 'R')
			continue;
		if ((n = sscanf(line, "%s %s", dest, gate)) != 2)
			continue;
		if ((route.dst = in_address(dest)) == 0)
			continue;
		ioctl(ipfd, IPIODROUTE, (char *)&route);
	}
	pclose(fp);
	close(ipfd);
	exit(0);
}

ipopen()
{
	int fd;

	if ((fd = open(IPDEV, 2)) == -1)
		error("Can't open %s", IPDEV);
	return fd;
}

error(fmt)
	char *fmt;
{
	va_list args;

	va_start(args, fmt);
	fprintf(stderr, "%s: ", progname);
	vfprintf(stderr, fmt, args);
	va_end(args);
	exit(1);
}
