/* cm.c:  Read the bits from the ncm board */
#include <sys/param.h>
#include <sys/inode.h>
#include <sys/types.h>
#include <saio.h>


#define	FIFO	((unsigned short *) 0xfe100000)
#define	FIFO_ST	((unsigned short *) 0xfe500000)
#define	LANCERAM	((unsigned short *) 0xfe000000)

static	ncm_missing;


cmopen(iob)
	register struct iob *iob;
{
	if (probe(LANCERAM) == -1)
		ncm_missing = 1;
	return;
}

cmstrat(iob)
	register struct iob *iob;
{
	unsigned short n;
	register i;

	if (ncm_missing) {
		*iob->i_ma = 'n';
		return;
	}
	*FIFO = 0x0000;
	*FIFO = 0x0010;
	*FIFO = 0x0055;
	for (i = 0; i < 2; i++) {
		while ((*FIFO_ST & 1) == 0)
			;
		*FIFO;
	}
	while ((*FIFO_ST & 1) == 0)
		;
	n = *FIFO;
	for (i = 0; i < 4; i++) {
		while ((*FIFO_ST & 1) == 0)
			;
		*FIFO;
	}
	*iob->i_ma = (n & 0x80) ? 'n' : 'a';
	return 1;
}
