/* srec -- takes an a.out file and coverts it into Motorolla S-records on
 *      the standard output.
 * File may be read from the command line or standard input.
 * This can process only one file at a time.
 */
#include <stdio.h>
#include <a.out.h>

#ifndef LINELEN
#define	LINELEN 72
#endif

#define	DEBUG(l,a,b,c,d,e)	if (dbug>=l){PRDBG;fprintf(stderr,a,b,c,d,e);fflush(stderr);}
#define	PRDBG	fprintf(stderr,"DEBUG: ")

char	*progname;
char	*filename = "standard input";
int	stype;		/* keeps up with s-type used */
FILE	*fp = NULL;
int	inprec = 0;
int	outrec = 0;
int	dbug = 0;
int	mult = 0;

main(argc, argv)
	char	*argv[];
{
	int	n;
	unsigned long	size, addr, maxin;
	unsigned long	offset = 0L;
	unsigned long	st_addr;
	char	ibuff[BUFSIZ];
	struct exec	hdr;

	progname = argv[0];

	/* open the file or use stdin */
	for (argv++; --argc; argv++) {
		if (argv[0][0] == '-') {
			switch (argv[0][1]) {
			case 'x':	/* debug */
				if (argv[0][2])
					dbug = argv[0][2] - 0x30;
				else
					dbug = 1;
			case 0:
				break;
			case 'T':	/* starting Text segment */
					/* used for adjusting st_addr */
				sscanf(&argv[0][2], "%lx", &offset);
				break;
			case 'm':	/* multiplier */
				if (argv[0][2])
					mult = atoi(&argv[0][2]);
				else
					mult = 1;
				break;
			default:
				usage();
			}
			continue;
		}
		if ((fp = fopen(filename = *argv, "r")) == NULL) {
			serror("can't open file");
			usage();
		}
	}
	if (fp == NULL && (fp = fopen(filename = "a.out", "r")) == NULL) {
		perror(filename);
		usage();
	}

	sleep(1);
	/* read the header, first making sure this is an a.out file */
	if (fread(&hdr, sizeof(struct exec), 1, fp) != 1) {
		perror(filename);
		serror("can't read a.out header");
		exit(1);
	}
	if (N_BADMAG(hdr)) {
		serror("not an a.out file");
		exit(1);
	}
	size = hdr.a_text + hdr.a_data;	 /* size of binary */
	st_addr = hdr.a_entry;			/* entry point */
	DEBUG(1, "text size = %ld, data size = %ld, total size = %ld\n", hdr.a_text, hdr.a_data, size, 0)
	DEBUG(1, "entry point = %08x\n", st_addr, 0, 0, 0)
	DEBUG(1, "entry will offset from = %08x\n", offset, 0, 0, 0)

	/* determine s type to use */
	if (size < 0x10000)
		stype = 1;
	else if (size < 0x1000000)
		stype = 2;
	else
		stype = 3;
	DEBUG(1, "producing S%d/S%d records\n", stype, 10-stype, 0, 0)

	/* first output the header */
	s(0, addr = 0, strlen(filename), filename);

	/* now output the binary */
	maxin = (LINELEN - 4 - ((stype + 1) * 2)) / 2;
	if (size < maxin)
		maxin = size;
	while (size && (n = fread(ibuff, 1, maxin, fp)) == maxin) {
		inprec++;
		DEBUG(2, "Input record number %d\n", inprec, 0, 0, 0)
		DEBUG(3, "max input = %d, num read = %d\n", maxin, n, 0, 0)
		s(stype, addr, n, ibuff);
		addr += (unsigned long)n;
		if ((size -= maxin) < maxin)
			maxin = size;
	}

	/* output trailer */
	s(10-stype, st_addr - offset, 0L, NULL);

	DEBUG(2, "%d input records, %d output records\n", inprec, outrec, 0, 0)
	exit(0);
}

s(stype, addr, size, buffer)
	unsigned long	addr, size;
	char	*buffer;
{
	int	length, addrlen, n;
	unsigned long	checksum;

	outrec++;
	printf("S%d", stype);
	if (!stype)
		addrlen = 2;
	else if (stype > 0 && stype < 4)
		addrlen = stype + 1;
	else
		addrlen = 10 - stype + 1;
	DEBUG(1, "S%d record address = %0X of size %ld with a %ld byte addr field\n", stype, addr, size, addrlen<<1)

	if ((length = addrlen + size + 1) > 0xff)
		serror("WARNING: a length of %d is too big\n", length);
	checksum = (length &= 0xff);
	printf("%02.2X", length);
	DEBUG(3, "length = %02.2X\n", length, 0, 0, 0)

	for (n = addrlen; n--; checksum += (addr >> (8*n)) & 0xff)
		DEBUG(4, "address byte = %02X\n", (addr >> (8*n)) & 0xff,0,0,0)
	printf("%0.*X", addrlen<<1, addr);
	DEBUG(3, "address = %0.*X\n", addrlen<<1, addr, 0, 0)

	while (size--) {
		n = *buffer;
		printf("%0.2X", n&0xff);
		checksum += n&0xff;
		DEBUG(4, "data = %0.2X\n", n&0xff, 0, 0, 0)
		buffer++;
	}

	DEBUG(1, "byte sum = %0X, checksum = %02.2X\n",checksum,(~checksum)&0xff,0,0)
	DEBUG(2, "output record number %d\n", outrec, 0, 0, 0)
	printf("%02.2X\n", (~checksum)&0xff);
#ifdef notdef
	if (!dbug) {
		register int	i = 0x1fe00;
		if (mult)
			if (mult < 0)
				i >>= (mult * -1);
			else
				i <<= mult;
		while (i) --i;
	}
#endif
}

serror(s1, s2)
	char	*s1, *s2;
{
	fprintf(stderr, "%s: %s: ", progname, filename);
	fprintf(stderr, s1, s2);
	putc('\n', stderr);
}

usage()
{
	fprintf(stderr, "usage: %s [-x{0-4}] [-T offset] [a.out_file]\n", progname);
	fprintf(stderr, " <or>  %s [-x{0-4}] [-T offset ] < a.out_file\n", progname);
	exit(1);
}
