#include <stdio.h>
	/*
	 * Print service port stuff
	 */
	
#define mask(x) (x&0377)
#include <sys/param.h>
#include <sys/conf.h>
#include <sys/tty.h>
#include <nlist.h>
#include <sys/ipm.h>
#include <sys/sid.h>
#include <sys/map.h>
#include <sys/proc.h>
#include <sys/inode.h>
#include <sys/dir.h>
#include <sys/file.h>
#include <sys/seg.h>
#include <sys/signal.h>
#include <sys/user.h>
#include <sid.h>
#include <ctype.h>

#define  NZITTY 4

struct xlat_tbl_s   {
	int 	 key;
	char	*name;
};
typedef struct xlat_tbl_s xlat_tbl_t;

#define PU_NAME_SIZE 100
struct pu_s {
	struct proc	p;
	long      	u_addr;
	int       	u_file;
	struct user	u;
	struct file	ofile[NOFILE];
	char      	name[PU_NAME_SIZE];
	int       	num_ptes;
	int       	num_msgs;
	int       	num_sids;
};
typedef struct pu_s  pu_t;

pu_t	        pu[NPROC];
int             num_pu = NPROC;
struct sid      xsid[NSIDS];
int             nsids = NSIDS;
char	       *fcore	= "/dev/kmem";
char 	       *fnlist	= "/unix";
char 	       *version = "Version: 2.1";
int	        mem;
int             swap;
int             swmem;
daddr_t	        swplo;
long 	        sidloc;

struct	user	udot;

struct	nlist setup[] = {
#define	SSID		0
	{ "_sid" },
#define	SMSG		1
	{ "_mesg"},
#define	SMSGLIST	2
	{ "_mesglist"},
#define	SMSGMAP		3
	{ "_msgmap"},
#define SPROC	    	4
	{ "_proc"},
#define SSWPLO          5
	{ "_swplo"},
	0
};

xlat_tbl_t sid_xlat[] = {
	{SID_NULL, 	      	"null"},
	{SID_SNM, 	      	"snm"},
	{SID_PCS_NET,           "pcs_net"},
	{SID_PCS_CLIENT,        "pcs_client"},
	{SID_PCS_TRUNK,         "pcs_trunk"},
	{SID_PCS_TPS,           "pcs_tps"},
	{SID_PCS_SWITCH,        "pcs_switch"},
	{SID_CM_PCS, 	      	"cm_pcs"},
	{SID_PTM_PCS,           "ptm_pcs"},
	{SID_CM_DEBUG,          "cm_debug"},
	{SID_DM_CM, 	      	"dm_cm"},
	{SID_CM_DM, 	      	"cm_dm"},
	{SID_PCS_REROUTE,       "pcs_reroute"},
	{SID_LOI_CLIENT,        "loi_client"},
	{SID_TPS, 	      	"tps"},
	{SID_ES_SINK,           "es_sink"},
	{SID_ES_MGMNT,          "es_mgmnt"},
	{SID_ES_BACKUP,         "es_backup"},
	{SID_ES_ALARM,          "es_alarm"},
	{SID_NIP, 	      	"nip"},
	{SID_ES_NETWORK,        "es_network"},
	{SID_TPSTESTER,         "tpstester"},
	{SID_PCS_TEST,          "pcs_test"},
	{SID_LCI_CLIENT,        "lci_client"},
	{SID_DM_MGMNT,          "dm_mgmnt"},
	{SID_CM_MGMNT,          "cm_mgmnt"},
	{SID_ES_DEBUG,          "es_debug"},
	{SID_DM_PLAT,           "dm_plat"},
	{SID_PCS_MGMNT,         "pcs_mgmnt"},
	{SID_CCB_MGMNT,         "ccb_mgmnt"},
	{SID_PTM_CONN,          "ptm_conn"},
	{SID_PTM_TRUNKSTATUS,	"ptm_trunkstatus"},
	{SID_PTM_ADMIN,         "ptm_admin"},
	{SID_PTM_PTM,           "ptm_ptm"},
	{SID_PTM_TPS,           "ptm_tps"},
	{SID_NODE_MGMNT,        "node_mgmnt"},
	{SID_ADAPTD, 	      	"adaptd"},
	{SID_ECHO, 	      	"echo"},
	{SID_CSM_MGR,           "csm_mgr"},
	{SID_NCC_MGMNT,         "ncc_mgmnt"},
	{SID_PTM_NCC,           "ptm_ncc"},
	{SID_ADAPTD_CSMM,       "adaptd_csmm"},
	{SID_PTM_MGMNT,         "ptm_mgmnt"},
	{SID_TST_MGMNT,         "tst_mgmnt"},
        {SID_GD_DM,		"gd_dm"},
	{SID_DM_GD,		"dm_gd"},
	{SID_GD,		"gd"},
	{SID_TPS_MGMNT,		"tps_mgmnt"},
	{33333,			"mon"},
	{NULL,    	      	NULL},
};

xlat_tbl_t scope_xlat[] = {
	{SCOPE_LOCAL,       	"local"},
	{SCOPE_ACTIVE,      	"active"},
	{SCOPE_INACTIVE,	"inactive"},
	{NULL,    	    	NULL},
};

int	sidf, mesgf, verbf;
int	msgmapf;
int	userf;
int  	nflag;
int     procf;
int     procallf;
char 	*progname;
int sidallf;

extern char *xlater();
extern char *xlat_sid();
extern char *xlat_scope();
extern char *strpbrk();
extern pu_t *find_pid();
extern long  strtol();

main(argc, argv)
char **argv;
{
	register char *p;
	int    i;
	char   *pid_argv;
	int     pid;
	int paddr;		/* physical address of upage */
	
	stackhack(10);		/* remove */
	progname = *argv;
	while (--argc && **++argv == '-') {
		p = *argv;
		while (*++p)
			switch (*p) {
				
			case 'a':
				sidf++;
				verbf++;
				mesgf++;
				msgmapf++;
				procallf++;
				break;
				
			case 's':		/* sid */
				sidf++;
				break;
			case 'v':
				verbf++;
				break;
			case 'm':
				mesgf++;
				break;
			case 'M':		/* message space */
				msgmapf++;
				break;
			case 'n':
				nflag++;
				break;
			case 'u':		/* a user process */
				userf++;
				if (argc < 2)
					usage();
				sscanf(*++argv, "%x", &paddr);
				argc--;
				break;
			case 'p':
				procf++;
				if (argc < 2)
					usage();
				pid_argv = *++argv;
				argc--;
				break;
			case 'P':
				procallf++;
				break;
			case 'S':
				sidallf++;
				break;
			default:
				usage();
			}
	}
	if (argc>0)
		fcore = argv[0];
	if ((mem = open(fcore, 0)) < 0) {
		printf("Can't find %s\n", fcore);
		exit(1);
	}
	if ((swap = open("/dev/swap", 0)) < 0) {
		printf("Can't open /dev/swap\n");
		exit(1);
	}
	if ((swmem = open(fcore, 0)) < 0) {
		printf("Can't open %s\n", fcore);
		exit(1);
	}
	
	if (argc>1)
		fnlist = argv[1];
	nlist(fnlist, setup);
	if (setup[SSID].n_type == -1) {
		printf("no namelist\n");
		exit(1);
	}
	kseek(mem, (long)setup[SSWPLO].n_value, 0);
	read(mem, (char *)&swplo, sizeof(swplo));
	fill_sid(&nsids, xsid);
	fill_pu(&num_pu, pu);
	if (sidf)
		dosid();
	if (msgmapf)
		domsgmap();
	if (userf)
		douser(paddr);
	if (procf) {
		if (isdigit(*pid_argv)) {
			pid = strtol(pid_argv, NULL, 0);
		}
		else {
			pid = cvt_pid(pid_argv);
			if (pid < 0) {
				printf("couldn't find process %s\n", pid_argv);
				exit(-1);
			}
		}
		doproc(pid);
	}
	if (procallf) {
		for (i = 0; i < num_pu; i++) {
			if (pu[i].num_sids != 0 || pu[i].num_msgs != 0 ||
			    pu[i].num_ptes != 0) {
				doproc(pu[i].p.p_pid);
			}
		}
	}
}

putf(v, n)
{
	if (v)
		printf("%c", n);
	else
		printf(" ");
}

#define	LOC(x)	((int)setup[SSID].n_value + ((int)(x) - (int)xsid))

sidcmp(a, b)
struct sid *a, *b;
{
	return a->serv_id - b->serv_id;
}

dosid()
{
	int savemsgf;
	register struct sid *sp;
	register v;
	int      i;
	register count;
	struct sid  *addr;
	int   tmp1, tmp2, tmp3;
	
	
	printf("%16s %-5s %-5s %-5s %-5s\n", "SID", "IMPRT", "NORML", "TOTAL",
	       "PROCS");
	for (sp = xsid; sp < &xsid[NSIDS]; sp++) {
		if (sp->serv_id == 0 && sidallf == 0)
			continue;
		printf("%16s ", xlat_sid(sp->serv_id));
		
		v = (int)sp->import.first;
		savemsgf = mesgf;
		mesgf = 0;
		count = 0;
		while (v) {
			v = prmesg(v);
			count++;
		}
		printf("%5d ", count);
		v = (int)sp->norm.first;
		count = 0;
		while (v) {
			v = prmesg(v);
			count++;
		}
		printf("%5d ", count);
		printf("%5d ", sp->count);
		for (i = 0; i < num_pu; i++) {
			if (check_pu_files(&pu[i], sp)) {
				if (nflag) {
					printf("%d ", pu[i].p.p_pid);
				}
				else {
					printf("%s(%d) ", pu[i].u.u_comm,
					       pu[i].p.p_pid);
				}
			}
		}
		printf("\n");
		if (mesgf = savemsgf) {
			v = (int)sp->import.first;
			while (v)
				v = prmesg(v);
			v = (int)sp->norm.first;
			while (v)
				v = prmesg(v);
		}
		
	}
	printf ("%d/%d sids used\n", nsids, NSIDS);
}

kseek(fd, offset, how)
{
	return lseek(fd, offset & ~0xC0000000, how);
}

prmesg(addr)		/* display message structure */
{
	char buf[128];
	struct mesg m;
	
	kseek(mem, addr, 0);
	read(mem, (char *)&m, sizeof m);
	if (mesgf == 0)
		return (int)m.next;
	sprintf(buf, "%d:%d:%d:%s", m.header.orig.net, m.header.orig.node, 
		m.header.orig.scope, xlat_sid(m.header.orig.sid));
	printf("\tsrc:%s ", buf);
	sprintf(buf, "%d:%d:%d:%s", m.header.dest.net, m.header.dest.node, 
		m.header.dest.scope, xlat_sid(m.header.dest.sid));
	printf("dest:%s ", buf);
	printf("%c%c%c len: %d\n", 
	       (m.header.flags & 1) ? 'I' : '-',
	       (m.header.flags & 2) ? 'F' : '-',
	       (m.header.flags & 4) ? 'R' : '-',
	       m.header.length);
	return (int)m.next;
}

domsgmap()
{
	struct map xmsgmap[NMESG];
	register struct map *mp;
	register total = 0, largest = 0;
	register count = 0;
	
	kseek(mem, setup[SMSGMAP].n_value, 0);
	read(mem, (char *)xmsgmap, sizeof xmsgmap);
	for (mp = xmsgmap; mp < &xmsgmap[NMESG]; mp++) {
		if (mp->m_addr == 0)
			break;
		count++;
		if (mp->m_size > largest)
			largest = mp->m_size;
		total += mp->m_size;
	}
	printf("%5d bytes free, %5d bytes contiguous, %d/%d messages\n",
	       ctob(total), ctob(largest), count, NMESG);
}

do_default()	/* print out default sid values */
{
	printf("Net %d, node %d, scope %d\n", getnet(), getnode(),
	       xlat_scope(getscope()));
}

douser(paddr)	/* print sid stuff for process */
{
	char *stoa();
	register f;
	struct mesg mesg;
	register l;
	register count = 0;
	register long *lp;
	
	kseek(mem, paddr, 0);
	read(mem, (char *)&udot, sizeof udot);
	for (lp = udot.u_pte; lp < &udot.u_pte[NPTE]; lp++)
		if (*lp == 0)
			count++;
	printf("%d/%d free\n", count, NPTE);
	count = 0;
	for (l = (int)udot.u_msglist; l;) {
		kseek(mem, l, 0);
		read(mem, (char *)&mesg, sizeof mesg);
		if (verbf) {
			printf("dest: %s ", stoa(mesg.header.dest));
			printf("src: %s ", stoa(mesg.header.orig));
			printf("len: %d, ", mesg.header.length);
			f = mesg.header.flags;
			printf("%c", f & MESG_IMPORTANT ? 'I' : '-');
			printf("%c", f & MESG_FAST ? 'F' : '-');
			printf("%c", f & MESG_RETURNED ? 'R' : '-');
			printf("\n");
		}
		count++;
		l = (int) mesg.next;
	}
	printf("%d message in users space\n", count);
}

doproc(pid)	/* print sid stuff for process */
int pid;
{
	char *stoa();
	register f;
	struct mesg mesg;
	register l;
	register count = 0;
	register long *lp;
	int    i;
	pu_t   *my_pu;
	
	my_pu = find_pid(pid);
	if (my_pu == NULL)
		return;
	
	if (nflag) {
		printf("pid %d:\n", pid);
	}
	else {
		printf("%s(%d):\n", my_pu->name, pid);
	}
	
	udot = my_pu->u;
	
	printf("\tbound sids: ");
	for (i = 0; i < NOFILE; i++) {
		if (my_pu->ofile[i].f_flag & FSID &&
		    my_pu->ofile[i].f_sid != NULL) {
			printf("%s ", xlat_sid(my_pu->ofile[i].f_sid->serv_id));
		}
	}
	printf("\n");
	
	printf("\t%d/%d ptes free\n", NPTE - my_pu->num_ptes, NPTE);
	if (verbf) {
		for (l = (int)udot.u_msglist; l; l = (int) mesg.next) {
			kseek(mem, l, 0);
			read(mem, (char *)&mesg, sizeof mesg);
			
			printf("\tdest: %s ", stoa(mesg.header.dest));
			printf("src: %s ", stoa(mesg.header.orig));
			printf("len: %d, ", mesg.header.length);
			f = mesg.header.flags;
			printf("%c", f & MESG_IMPORTANT ? 'I' : '-');
			printf("%c", f & MESG_FAST ? 'F' : '-');
			printf("%c", f & MESG_RETURNED ? 'R' : '-');
			printf("\n");
		}
	}
	printf("\t%d message in users space\n", my_pu->num_msgs);
}

usage()
{
	fprintf(stderr, "usage: %s -[asvmnpPMu] [paddr] [pid] [core]\n",
		progname);
	fprintf(stderr, "%s: %s\n", progname, version);
	exit(1);
}

char *stoa(ana)		/* format adaptive network address */
struct ana ana;
{
	static char b[512];
	
	sprintf(b, "%d:%d:%s:%s", ana.net, ana.node, xlat_scope(ana.scope),
		xlat_sid(ana.sid));
	return b;
}

/* remove */

stackhack(n)
{
	char get_the_sp_bigger[10*1024];
	
	if (n > 0)
		stackhack(n-1);
}

char *xlat_sid(sid)
int  sid;
{
	return(xlater(sid, sid_xlat));
}

char *xlat_scope(scope)
int  scope;
{
	return(xlater(scope, scope_xlat));
}

char *xlater(key, tbl)
int  	        key;
xlat_tbl_t     *tbl;
{
	static char b[100];
	int    i;
	
	if (nflag) {
		sprintf(b, "%d", key);
		return(b);
	}
	
	for (i = 0; tbl[i].name != NULL; i++) {
		if (tbl[i].key == key) {
			return(tbl[i].name);
		}
	}
	
	sprintf(b, "Unknown(%d)", key);
	return(b);
}

int cvtr(key, tbl)
char 	       *key;
xlat_tbl_t     *tbl;
{
	int  ret;
	int  i;
	
	if (nflag) {
		ret = strtol(key, NULL, 0);
		return(ret);
	}
	
	ret = 0;
	for (i = 0; tbl[i].name != NULL; i++) {
		if (strcmp(tbl[i].name, key) == 0)
			return(tbl[i].key);
	}
	
	return(ret);
}

int cvt_pid(name)
char *name;
{
	int  i;
	
	for (i = 0; i < num_pu; i++) {
		if (strcmp(pu[i].name, name) == 0) {
			return(pu[i].p.p_pid);
		}
	}
	return(-1);
}

fill_sid(num, sid)
int  	       *num;
struct sid     *sid;
{
	struct sid *sp;
	int         size;
	int       	 max;
	int         ret;
	
	ret = 0;
	max  = *num;
	size = max * sizeof(*sid);
	sidloc = setup[SSID].n_value;
	kseek(mem, sidloc, 0);
	read(mem, (char *)sid, size);
	for (sp = sid; sp < &sid[max]; sp++) {
		if (sp->serv_id) {
			ret++;
		}
	}
	*num = ret;
	return(ret);
}

fill_pu(num, pu)
int  *num;
pu_t *pu;
{
	struct proc    *p;
	struct proc    *tmp_p;
	pu_t      	    *tmp_pu;
	int       	     max;
	int       	     i;
	int       	     j;
	int       	     size;
	long      	    *lp;
	
	bzero((char *)pu, *num * sizeof(*pu));
	
	max  = *num;
	i    = 0;
	size = max * sizeof(*p);
	p = (struct proc *)malloc(size);
	if (p != NULL) {
		kseek(mem, (long)setup[SPROC].n_value, 0);
		read(mem, (char *)p, size);
		
		tmp_pu = pu;
		for (tmp_p = p; tmp_p < &p[max]; tmp_p++) {
			if (tmp_p->p_stat != 0 && tmp_p->p_stat != SZOMB) {
				tmp_pu->p = *tmp_p;
				get_uarea(tmp_pu);
				get_ofiles(tmp_pu);
				get_name(tmp_pu);
				fill_stats(tmp_pu);
				i++;
				tmp_pu++;
			}
		}
		free(p);
	}
	*num = i;
}

fill_stats(pu)
pu_t *pu;
{
	int       	    i;
	int       	    l;
	struct mesg    mesg;
	
	
	for (i = 0; i < NPTE; i++) {
		if (pu->u.u_pte[i] != 0) {
			pu->num_ptes++;
		}
	}
	
	for (i = 0; i < NOFILE; i++) {
		if (pu->ofile[i].f_flag & FSID) {
			pu->num_sids++;
		}
	}
	
	for (l = (int)pu->u.u_msglist; l; l = (int)mesg.next) {
		pu->num_msgs++;
		kseek(mem, l, 0);
		read(mem, (char *)&mesg, sizeof(mesg));
	}
}

get_uarea(pu)
pu_t *pu;
{
	if (pu->p.p_flag & SLOAD) {
		pu->u_addr = ctob((long)pu->p.p_addr);
		pu->u_file = swmem;
	}
	else {
		pu->u_addr = (long)(pu->p.p_addr + swplo) << 9;
		pu->u_file = swap;
	}
	
	lseek(pu->u_file, pu->u_addr, 0);
	read(pu->u_file, &pu->u, sizeof(pu->u));
}

get_ofiles(pu)
pu_t *pu;
{
	int  i;
	long f_addr;
	int  addr;
	
	for (i = 0; i < NOFILE; i++) {
		if (pu->u.u_ofile[i] != NULL) {
			f_addr = (long)pu->u.u_ofile[i];
			kseek(pu->u_file, f_addr, 0);
			read(pu->u_file, &pu->ofile[i], sizeof(pu->ofile[i]));
			if (pu->ofile[i].f_flag & FSID) {
				addr = (int)pu->ofile[i].f_sid;
				addr = addr - sidloc + (int)xsid;
				pu->ofile[i].f_sid = (struct sid *)addr;
			}
		}
	}
	
}

get_name(pu)
pu_t *pu;
{
	char abuf[512];
	int  *ip;
	char *cp, *cp1;
	int   c, nbad;
	long addr;
	
	if (pu->p.p_pid == 0) {
		strcpy(pu->u.u_comm, "swapper");
	}
	bcopy(pu->u.u_comm, pu->name, DIRSIZ);
	pu->name[DIRSIZ] = 0;
	return;
	
#ifdef notdef
	addr = pu->u_addr + ctob((long)pu->p.p_size) - 512;
	lseek(pu->u_file, addr, 0);
	if (read(file, abuf, sizeof(abuf)) == sizeof(abuf)) {
		for (ip = (int *)&abuf[512]-3; ip > (int *)abuf; ) {
			if (*--ip == -1 || *ip==0) {
				cp = (char *)(ip+1);
				if (*cp==0)
					cp++;
				nbad = 0;
				for (cp1 = cp; cp1 < &abuf[512]; cp1++) {
					c = *cp1&0177;
					if (c==0)
						*cp1 = ' ';
					else if (c < ' ' || c > 0176) {
						if (++nbad >= 10) {
							*cp1++ = ' ';
							break;
						}
						*cp1 = '?';
					} else if (c=='=') {
						*cp1 = 0;
						while (cp1>cp && *--cp1!=' ')
							*cp1 = 0;
						break;
					}
				}
				while (*--cp1==' ')
					*cp1 = 0;
				cp1 = strpbrk(cp, " \t");
				if (cp1 != NULL)
					*cp1 = 0;
				strncpy(pu->name, cp, PU_NAME_SIZE);
			}
		}
	}
#endif /* notdef */
}

check_pu_files(pu, sid)
pu_t *pu;
struct sid *sid;
{
	int  i;
	
	for (i = 0; i < NOFILE; i++) {
		if (pu->ofile[i].f_flag & FSID && pu->ofile[i].f_sid == sid)
			return(1);
	}
}

pu_t *find_pid(pid)
short pid;
{
	pu_t *ret;
	int   i;
	
	ret = NULL;
	for (i = 0; i < num_pu; i++) {
		if (pu[i].p.p_pid == pid) {
			ret = &pu[i];
			break;
		}
	}
	
	return(ret);
}
