/*
 * enter a password in the password file
 * this program should be suid
 * with an owner with write permission on /etc/passwd
 *
 * This one is hacked to work with the first release of the
 * switch software.
 * It uses stderr for all output.
 */
#include <stdio.h>
#include <signal.h>
#include <pwd.h>
#include <string.h>

char	passwd[] = "/etc/passwd";
char	temp[]	 = "/etc/ptmp";
struct	passwd *pwd;
struct	passwd *getpwent();
int	endpwent();
char	*strcpy();
char	*crypt();
char	*getpass();
char	*getlogin();
char	*pw;
char	pwbuf[10];
char	buf[512];

main(argc, argv)
char *argv[];
{
	char *sprompt();
	char line[128];
	int nextuid;
	char *p;
	int i;
	char saltc[2];
	long salt;
	int u,fi,fo;
	int insist;
	int ok, flags;
	int nflag, aflag;
	int c;
	int pwlen;
	FILE *tf;
	char *uname;

	if (argc > 1) {
		if (strcmp(argv[1], "-a") == 0) {
			aflag++;
			argc--;
			argv++;
		} else if (strcmp(argv[1], "-n") == 0) {
			if (getuid() != 0) {
				fprintf(stderr, "passwd: must be root for -n\n");
				exit(1);
			}
			nflag++;
			argc--;
			argv++;
		}
	}
	insist = 0;
	if(argc < 2) {
		if ((uname = getlogin()) == NULL) {
			printf ("Usage: passwd user\n");
			goto bex;
		} else
			fprintf(stderr, "Changing password for %s\n", uname);
	} else
		uname = argv[1];
	while(((pwd=getpwent()) != NULL)&&(strcmp(pwd->pw_name,uname)!=0))
		;
	u = getuid();
	if((pwd==NULL) || (u!=0 && u != pwd->pw_uid)) {
		fprintf(stderr, "Permission denied.\n");
		goto bex;
	}
	endpwent();
	if (pwd->pw_passwd[0] && u != 0) {
		strcpy(pwbuf, getpass("Old password:"));
		pw = crypt(pwbuf, pwd->pw_passwd);
		if(strcmp(pw, pwd->pw_passwd) != 0) {
			fprintf(stderr, "Sorry.\n");
			goto bex;
		}
	}
tryagn:
	strcpy(pwbuf, getpass("New password:"));
	pwlen = strlen(pwbuf);
	if (pwlen == 0) {
		fprintf(stderr, "Password unchanged.\n");
		goto bex;
	}
	ok = 0;
	flags = 0;
	p = pwbuf;
	while(c = *p++){
		if(c>='a' && c<='z') flags |= 2;
		else if(c>='A' && c<='Z') flags |= 4;
		else if(c>='0' && c<='9') flags |= 1;
		else flags |= 8;
	}
	if(flags >=7 && pwlen>= 4) ok = 1;
	if(((flags==2)||(flags==4)) && pwlen>=6) ok = 1;
	if(((flags==3)||(flags==5)||(flags==6))&&pwlen>=5) ok = 1;

	if ((ok==0) && (insist<2)) {
		if(flags==1)
			fprintf(stderr, "Please use at least one non-numeric character.\n");
		else
			fprintf(stderr, "Please use a longer password.\n");
		insist++;
		goto tryagn;
	}

	if (strcmp(pwbuf,getpass("Retype new password:")) != 0) {
		printf ("Mismatch - password unchanged.\n");
		goto bex;
	}

	time(&salt);
	salt += getpid();

	saltc[0] = salt & 077;
	saltc[1] = (salt>>6) & 077;
	for(i=0;i<2;i++){
		c = saltc[i] + '.';
		if(c>'9') c += 7;
		if(c>'Z') c += 6;
		saltc[i] = c;
	}
	pw = crypt(pwbuf, saltc);
	signal(SIGHUP, SIG_IGN);
	signal(SIGINT, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);

	if(access(temp, 0) >= 0) {
		fprintf(stderr, "Temporary file busy -- try again\n");
		goto bex;
	}
	close(creat(temp,0600));
	if((tf=fopen(temp,"w")) == NULL) {
		fprintf(stderr, "Cannot create temporary file\n");
		goto bex;
	}

/*
 *	copy passwd to temp, replacing matching lines
 *	with new password.
 */

	while((pwd=getpwent()) != NULL) {
		nextuid = 0;
		if(strcmp(pwd->pw_name,uname) == 0) {
			u = getuid();
			if(u != 0 && u != pwd->pw_uid) {
				fprintf(stderr, "Permission denied.\n");
				goto out;
			}
			pwd->pw_passwd = pw;
			if (aflag) {		/* and other info */
				printf("Gecos[%s]: ", pwd->pw_gecos);
				gets(line);
				if (strlen(line) > 0)
					pwd->pw_gecos = strdup(line);
				printf("Shell[%s]: ", pwd->pw_shell);
				gets(line);
				if (strlen(line) > 0)
					pwd->pw_shell = strdup(line);
			}
		}
		nextuid = pwd->pw_uid > nextuid ? pwd->pw_uid : nextuid;
		fprintf(tf,"%s:%s:%d:%d:%s:%s:%s\n",
			pwd->pw_name,
			pwd->pw_passwd,
			pwd->pw_uid,
			pwd->pw_gid,
			pwd->pw_gecos,
			pwd->pw_dir,
			pwd->pw_shell);
	}
	if (nflag) { 		/* new user */
		pwd->pw_name = sprompt("Name [%s]: ", "John Doe");
		pwd->pw_uid = dprompt("UID[%d]: ", nextuid);
		pwd->pw_gid = dprompt("GID[%d]: ", 100);
		pwd->pw_gecos = sprompt("Gecos [%s]: ", "New user");
		pwd->pw_dir = sprompt("Directory [/usr/%s]: ",  pwd->pw_name);
		pwd->pw_dir = sprompt("Shell [%s]: ", "/bin/sh");
		fprintf(tf,"%s:%s:%d:%d:%s:%s:%s\n",
			pwd->pw_name,
			pwd->pw_passwd,
			pwd->pw_uid,
			pwd->pw_gid,
			pwd->pw_gecos,
			pwd->pw_dir,
			pwd->pw_shell);
		sprintf(line, "/bin/mkdir %s", pwd->pw_dir);
		system(line);
		chown(pwd->pw_dir, pwd->pw_uid, pwd->pw_gid);
		sprintf(line, "/bin/cp /etc/stdprofile %s", pwd->pw_dir);
		system(line);
		sprintf(line, "%s/.profile", pwd->pw_dir);
		chown(line, pwd->pw_uid, pwd->pw_gid);
	}
	endpwent();
	fclose(tf);

/*
 *	copy temp back to passwd file
 */

	if((fi=open(temp,0)) < 0) {
		fprintf(stderr, "Temp file disappeared!\n");
		goto out;
	}
	if((fo=creat(passwd, 0644)) < 0) {
		fprintf(stderr, "Cannot recreat passwd file.\n");
		goto out;
	}
	while((u=read(fi,buf,sizeof(buf))) > 0) write(fo,buf,u);

out:
	unlink(temp);

bex:
	exit(1);
}

char *
sprompt(s1, s2)		/* prompt and get responce for string */
	char *s1, *s2;
{
	char line[128];

	fprintf(stderr, s1, s2);
	gets(line);
	if (line[0] != '\0')
		return strdup(line);
	return strdup(s2);
}

dprompt(s, d)		/* prompt and get responce for decimal number */
	char *s;
{
	char line[128];

	fprintf(stderr, s, d);
	gets(line);
	if (line[0] != '\0')
		return atoi(line);
	return d;
}
