#ifndef ops_h
#define ops_h
typedef unsigned short Opcode;

#define OP_BPT 0x4E4F		/* break point fault, (actually = trap #14) */
#define OP_RTD 0x4E74		/* return from procedure, deallocate params */
#define OP_RTS 0x4E75		/* return from procedure */
#define OP_JSR 0x4E80		/* jump to subroutine */
#define OP_JMP 0x4EC0		/* jump */
#define OP_DBT  0x50C8		/* decr & branch true */
#define OP_DBRA 0x51C8		/* decr & branch */
#define OP_DBHI 0x52C8		/* decr & branch on high */
#define OP_DBLS 0x53C8		/* decr & branch on low or same */
#define OP_DBCC 0x54C8		/* decr & branch on carry clear */
#define OP_DBCS 0x55C8		/* decr & branch on carry set */
#define OP_DBNE 0x56C8		/* decr & branch on not equal */
#define OP_DBEQ 0x57C8		/* decr & branch on equal */
#define OP_DBVC 0x58C8		/* decr & branch on overflow clear */
#define OP_DBVS 0x59C8		/* decr & branch on overflow set */
#define OP_DBPL 0x5AC8		/* decr & branch on positive */
#define OP_DBMI 0x5BC8		/* decr & branch on negative */
#define OP_DBGE 0x5CC8		/* decr & branch on greater or equal */
#define OP_DBLT 0x5DC8		/* decr & branch on less */
#define OP_DBGT 0x5EC8		/* decr & branch on greater */
#define OP_DBLE 0x5FC8		/* decr & branch on less or equal */
#define OP_BRA 0x6000		/* branch */
#define OP_BSR 0x6100		/* branch to subroutine */
#define OP_BHI 0x6200		/* branch on high */
#define OP_BLS 0x6300		/* branch on low or same */
#define OP_BCC 0x6400		/* branch on carry clear */
#define OP_BCS 0x6500		/* branch on carry set */
#define OP_BNE 0x6600		/* branch on not equal */
#define OP_BEQ 0x6700		/* branch on equal */
#define OP_BVC 0x6800		/* branch on overflow clear */
#define OP_BVS 0x6900		/* branch on overflow set */
#define OP_BPL 0x6A00		/* branch on positive */
#define OP_BMI 0x6B00		/* branch on negative */
#define OP_BGE 0x6C00		/* branch on greater or equal */
#define OP_BLT 0x6D00		/* branch on less */
#define OP_BGT 0x6E00		/* branch on greater */
#define OP_BLE 0x6F00		/* branch on less or equal */

Address disasm (/* print, addr, dest */);
#endif ops_h
