#ifndef eval_h
#define eval_h

#include "machine.h"

#define STACKSIZE 20000

typedef Char Stack;

#ifdef mc68000
#define push(type, value) { \
    _push(sizeof(type), (value)); \
}

#define pop(type) ( \
    (*((type *) _pop(sizeof(type)))) \
)
#else (vax)
#define push(type, value) { \
    ((type *) (sp += sizeof(type)))[-1] = (value); \
}

#define pop(type) ( \
    (*((type *) (sp -= sizeof(type)))) \
)
#endif mc68000

#define popn(n, dest) { \
    sp -= n; \
    bcopy(sp, dest, n); \
}

#define alignstack() { \
    sp = (Stack *) (( ((int) sp) + sizeof(int) - 1)&~(sizeof(int) - 1)); \
}

Stack stack[STACKSIZE];
Stack *sp ;
Boolean useInstLoc ;
_push(/* sz, value */);
char * _pop(/* sz */);
eval(/* p */);
evalcmdlist(/* cl */);
rpush(/* addr, len */);
Boolean canpush(/* n */);
pushsmall(/* t, v */);
long popsmall(/* t */);
Boolean cond(/* p */);
Address lval(/* p */);
trace(/* p */);
stop(/* p */);
assign(/* var, exp */);
gripe(/*  */);
help(/*  */);
setout(/* filename */);
unsetout(/*  */);
Boolean isredirected(/*  */);
#endif eval_h
