/* input.c:  read commands. */

#include <stdio.h>

static	lastc = -1;

next_c()
{
	int c;

	if (lastc > -1) {
		c = lastc;
		lastc = -1;
		return c;
	}
	if ((c = getchar()) == EOF)
		exit(0);
	return c;
}

push_c(c)
{
	lastc = c;
}

peek_c()		/* snatch a quick peek */
{
	int c;

	c = next_c();
	push_c(c);
	return c;
}
