/* commands.c:  command processor. */
#include <stdio.h>
#include <a.out.h>
#include <ctype.h>
#include <setjmp.h>

static	lastcomm = '?';
static	lastcount = 1;
static	dot = 0;

command()
{
	jmp_buf jbuf;

	if (setjmp(jbuf))
		puts("adb");
	if (feof(stdin))
		exit(0);
	for (;;)
		comm();
}

static
comm()
{
	int addr, count;
	int cmd;
	int c;

	if ((addr = exp()) == -1)
		addr = dot;
	else
		dot = addr;
	if (peek_c() == ',') {
		c = next_c();
		if ((count = exp()) == -1)
			count = lastcount;
	} else
		count = lastcount;
	if (peek_c() == ';' || peek_c() == '\n')
		cmd = lastcomm;
	else
		cmd = next_c();
	lastcount = count;
	switch(cmd) {
	case '?':
		do_print(addr, count, 1);
		break;
	case '/':		/* print from core file */
		do_print(addr, count, 0);
		break;
	case '=':		/* just print the address */
		do_equ(addr);
		break;
	case '$':		/* misc commands */
		misc();
		break;
	case '!':
		system("sh -t");
		break;
	default:
		puts("unknown command\n");
	}
	lastcomm = cmd;
	while ((c = next_c()) != ';' && c != '\n')
		;
}

static
exp()
{
	int c;

	c = next_c();
	if (isdigit(c))
		return getnum(c);
	else if (c == '_' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')
		return getname(c);
	push_c(c);
	return -1;
}

static
getnum(c)			/* read a number starting with 'c' */
{
	int num;

	num = 0;
	while (isxdigit(c)) {
		num *= 16;
		num += c <= '9' ? c - '0' : c - 'a' + 10;
		c = next_c();
	}
	push_c(c);
	return num;
}


do_print(addr, count, obj)
{
	int w;
	char *mkascii();

	while (count--) {
		if (fetch(obj, addr, &w) == 0)
			return;
		printf("%08x %08x '%s'\n", addr, w, mkascii(w));
		addr += sizeof w;
	}
	dot = addr;
}

static
do_ext()		/* print external variables */
{
	register struct nlist *sp;
	int t, c, word;
	struct nlist *get_next_sym();
	char *mkascii();

	for (sp = get_next_sym(NULL); sp != NULL; sp = get_next_sym(sp)) {
		t = sp->n_type;
		if (t != (N_EXT | N_DATA) && t != (N_EXT | N_BSS))
			continue;
		if (fetch(0, sp->n_value, &word) == 0)
			word = 0;
		printf("%08x '%s' %s\n", word, mkascii(word), sp->n_un.n_name);
	}
}

static
misc()				/* misc commands */
{
	int c;

	c = next_c();
	switch(c) {
	case 'c':		/* stack back trace */
		do_back();		
		break;
	case 'e':			/* print externals */
		do_ext();
		break;
	case 'm':
		pr_maps();
		break;
	case 'q':
		exit(0);
	case 'r':			/* display registers */
		regs();
		break;
	default:
		puts("unknown commandd");
	}
}

static
getname(c)		/* return the value of the symbol */
{
	register struct nlist *np;
	char buf[80];
	int offset;
	char *cp;
	struct nlist *lookup();

	cp = buf;
	*cp++ = '_';
	while (c == '_' || isalnum(c)) {
		*cp++ = c;
		c = next_c();
	}
	*cp++ = '\0';
	push_c(c);
	if ((np = lookup(&buf[1], &offset)) == NULL)
	if ((np = lookup(buf, &offset)) == NULL) {
		printf("symbol not found\n");
		return -1;
	}
	return np->n_value;
}


static	char *regnames[] = {
	"d0", "d1", "d2", "d3", "d4", "d5", "d6", "d7",
	"a0", "a1", "a2", "a3", "a4", "a5", "fp", "sp",
	"ps", "pc"
};
#define	NREGS	18

static
regs()
{
	int i, r, o, x;
	struct nlist *sp, *findfn();
	char *mkascii();

	for (i = 0; i < NREGS; i++)
		if (get_reg(&r, i)) {
			printf("%s %08x", regnames[i], r);
			printf(" '%s'\n", mkascii(r));
		}
	if (get_reg(&r, 17))		/* get PC */
	if ((sp = findfn(r, &o, &x)) != NULL)
		printf("%s+%x\n", sp->n_un.n_name, o);
}


static
do_equ(addr)			/* print value of addr */
{
	int c, offset, argsize;
	struct nlist *sp, *findfn();

	if (peek_c() == 'a') {
		c = next_c();
		sp = findfn(addr, &offset, &argsize);
		if (sp != NULL) {
			printf("%s+%x\n", sp->n_un.n_name, offset);
			return;
		}
	}
	printf("%08x\n", addr);
}


static
do_back()			/* stack back trace */
{
	int fp, ra;
	struct nlist *sp, *findfn();
	int pc, offset, x, w;

	get_reg(&pc, 17);
	if ((sp = findfn(pc, &offset, &x)) != NULL)
		printf("%s", sp->n_un.n_name);
	get_reg(&fp, 14);		/* get frame pointer */
	for (;;) {
		if (fp == 0)
			break;
		if (fetch(0, fp + sizeof(long), &ra) == 0)
			break;
		pr_args(fp);
		if ((sp = findfn(ra, &offset, &x)) != NULL) {
			printf("%s+%x", sp->n_un.n_name, offset);
		}
		if (fetch(0, fp, &fp) == 0)
			break;
	}
	printf("\n");
}

static
char *
mkascii(w)			/* turn word into a string */
{
	static char ascii[6];
	register char *cp;
	int i;

	cp = ascii;

	for (i = 24; i >= 0; i -= 8) {
		*cp = w >> i & 0xff;
		if (*cp < ' ' || *cp > '~')
			*cp = '.';
		cp++;
	}
	*cp++ = '\0';
	return ascii;
}


static
pr_args(fp)			/* print the arguments from the stack */
{
	int pfp, w, n;

	fetch(0, fp, &pfp);		/* get prev frame pointer to stop */
	n = 6;
	printf("\t(");
	fp += 8;			/* skip the return address */
	while (pfp > fp && n--) {
		fetch(0, fp, &w);
		printf("%08x", w);
		fp += 4;
		if (pfp > fp)
			printf(", ");
	}
	printf(")\n");
}
