/*
 * $Header: inst.h,v 1.1 86/02/28 13:34:16 root Exp $
 *
 * $Log:	inst.h,v $
 * Revision 1.1  86/02/28  13:34:16  root
 * Initial revision
 * 
 */



# define NULL 0

# define EA 0x0008 
# define EAM 0xffc7

# define SZ 0x00c0 
# define SZM 0xff3f

# define MSP 0x02c0 
# define MSPM 0xf93f


typedef unsigned short ushort;

struct inst
{
	char *opcode;		/* opcode string		*/
	ushort value;		/* bits to match		*/
	ushort mask1;		/* mask for don't cares		*/
	ushort inval1;		/* bits that are invalid	*/
	ushort imask1;		/* mask for inval don't cares	*/
	ushort inval2;		/* bits that are invalid	*/
	ushort imask2;		/* mask for inval don't cares	*/
	ushort *(*op)();		/* fn to return result		*/
};

extern ushort *_adr_op_ea();
extern ushort *_ar();
extern ushort *_ar_imm();
extern ushort *_bcc();
extern ushort *_dbcc();
extern ushort *_dr();
extern ushort *_dr_ea();
extern ushort *_dr_op_ea();
extern ushort *_dr_sz_ea();
extern ushort *_ea();
extern ushort *_ea_ar();
extern ushort *_ea_dr();
extern ushort *_exga();
extern ushort *_exgd();
extern ushort *_exgm();
extern ushort *_ext();
extern ushort *_imm();
extern ushort *_imm_ea();
extern ushort *_imm_sz_ea();
extern ushort *_lim_ea();
extern ushort *_move();
extern ushort *_movem();
extern ushort *_movep();
extern ushort *_moveq();
extern ushort *_mover();
extern ushort *_mvusp();
extern ushort *_noop();
extern ushort *_scc();
extern ushort *_sh_dr();
extern ushort *_shmem();
extern ushort *_sz_ea();
extern ushort *_trap();

extern ushort *disasm();
