/* ttyio.h: Definitions for tty line discipline */

struct	tchars	{
	char	t_intrc;		/* interrupt */
	char	t_quitc;		/* quit */
	char	t_startc;		/* start output */
	char	t_stopc;		/* stop output */
	char	t_eofc;			/* end-of-file */
	char	t_brkc;			/* input delimiter (like nl)*/
};

struct	sgttyb {
	char	sg_ispeed;		/* unused */
	char	sg_ospeed;		/* unused */
	char	sg_erase;		/* erase character */
	char	sg_kill;		/* kill character */
	int	sg_flags;		/* mode flags */

};


#define	ALLDELAY	0177400
#define	VTDELAY		0040000		/* form feed and vertical tab */
#define	FF0		0000000
#define	FF1		0040000
#define	CRDELAY		0030000		/* carriage return delays */
#define	CR0		0000000
#define	CR1		0010000
#define	CR2		0020000
#define	CR3		0030000
#define	TBDELAY		0006000		/* Tab delays */
#define	TAB0		0000000
#define	TAB1		0002000
#define	TAB2		0004000
#define	XTABS		0006000
#define	NLDELAY		0001400		/* new-line delays */
#define	NL0		0000000
#define	NL1		0000400
#define	NL2		0001000
#define	NL3		0001400
#define	RAW		0000040		/* raw mode: wake up on all chars */
#define	CRMOD		0000020		/* map cr->lf; echo lf or cr as crlf */
#define	ECHO		0000010		/* echo characters */
#define	LCASE		0000004		/* map upper case to lower on input */
#define	CBREAK		0000002		/* return each char as soon as typed */
#define	TANDEM		0000001		/* automatic flow control */


#define TIOCGDEV        (('t'<<8)|0)
#define TIOCSDEV        (('t'<<8)|1)
#define TIOCSETC        (('t'<<8)|2)
#define TIOCGETC        (('t'<<8)|3)
#define TIOCGETP        (('t'<<8)|4)
#define TIOCSETP        (('t'<<8)|5)
#define TIOCSPGRP       (('t'<<8)|6)
#define TIOCGPGRP       (('t'<<8)|7)
#define TIOCEXCL        (('t'<<8)|8)
#define TIOCNXCL        (('t'<<8)|9)
#define TIOCSBRK         (('t'<<8)|10)
#define TIOCFLUSH       (('t'<<8)|11)
#define TIOCHPCL        (('t'<<8)|12)

/*
 * This stuff is for the tty device driverss.
 */

struct	ttydevb {
	char	ispeed;		/* input speed */
	char	ospeed;		/* output speed */
	short	flags;		/* mode flags */
};


#define B0	0
#define B50	1
#define B75	2
#define B110	3
#define B134	4
#define B150	5
#define B200	6
#define B300	7
#define B600	8
#define B1200	9
#define	B1800	10
#define B2400	11
#define B4800	12
#define B9600	13
#define EXTA	14
#define EXTB	15

#define	ODDP	0100
#define	EVENP	0200
#define	F8BIT	0040
