/* disc boot program to load and transfer to a unix entry */
/* This strap if found in block 0 of the file system.
 * It's job is to search the file system and find the program
 * named /boot and load it into memory and give it control.
 * The is the first place that knows about the file system.
 * To change the type of file system you don't need to
 * change the boot roms on the boards.
 *
 */


start:
	movl	#start+2048,sp
	jsr	scsisave

/*	clear core to make things clean */

	movl	#end, a0
	movl	#(2048>>4)-1,d0		/* longs to zero */
1:
	clrl	a0@+
	dbra	d0,1b

/*
 * start reading the inodes
 * starting ad the root and
 * going through directories
 */

1:
	movl	#2, d0		/* inode to read */
1:
	jsr	iget
	clrl	bno
2:				/* for each block in root */
	jsr	rmblk
		bras	start	/* error return */
	movl	#buf, a4
	movw	#32-1,d6	/* (blksize/sizeof dirent) - 1 */
3:				/* for each dir entry */
	movw	a4@,d0		/* is (d0 = d_ino) == 0 ? */
	beq	5f		/* no, look at next dirent */

/*	look at the dir entry */

	cmpw	#0x626f,a4@(2)	/* 'bo' ? */
	bnes	5f		/* next */
	cmpw	#0x6f74,a4@(4)	/* 'ot' ? */
	bnes	5f		/* next */
	cmpw	#0x0000,a4@(6)	/* end of string */
	bnes	5f		/* next */
	bras	1f		/* got a match! */
5:
	addl	#16,a4
	dbra	d6,3b		/* end block loop */
	bras	2b		/* end directory loop */

/*
 * read file into core until 
 * a mapping error, (no disc address)
 */

1:
	clrl	bno
	movw	a4@,d0
	extl	d0
	jsr	iget
	movl	#ENTRY,a1
1:
	jsr	rmblk
		bras	1f		/* error return */
	movl	#buf, a2
	movl	#(512>>2)-1,d6
2:
	movl	a2@+,a1@+
	dbra	d6, 2b
	bras	1b

/*
 * reloacate core around
 * assembler header
 */
1:
	movl	#ENTRY,a0
	cmpl	#0407,a0@
	bnes	2f
	movl	#(MAXSIZE >> 2)-1,d6
1:
	movl	a0@(0x20),a0@+
	dbra	d6,1b

/*
 * Enter program and 
 * restart if return
 */
2:
	movl	#ENTRY,a0
	jsr	a0@
	bra	start

/*
 * get the inode specified in d0
 */

iget:
	addl	#15,d0		/* (2 blks * 8 inodes per block) - 1 */
	movl	d0,d5		/* save a copy */
	lsrl	#3,d0		/* d0 /= inodes per block */
	jsr	rblk		/* get that block */
	andl	#07,d5		/* d5 %= inodes per block */
	lsll	#6,d5		/* d5 *= bytes per inode */
	addl	#buf,d5		/* d5 += base of buffer */
	movl	d5,a0
	movl	#inod,a1
	movl	#(64>>2)-1,d6	/* copy inode into inod place */
1:
	movl	a0@+,a1@+
	dbra	d6,1b
	rts

/*
 * read a mapped block
 * offset in file is in bno.
 * skip if success, no skip if fail
 * the algorithm only handles a single
 * indirect block. that means that
 * files longer than 10 + 128 blocks cannot
 * be loaded.
 */

rmblk:
	addl	#2,sp@		/* assume everything will work */
	movl	bno,d0		/* the block we need */
	cmpl	#10,d0		/* do we need to do indirect? */
	blts	1f		/* no, skip */
	movl	#10,d0		/* yes,  first we get the indirect block */
1:
	movl	d0, sp@-	/* since address are stored in 3 byte */
	asll	#1, d0		/*   we need to mul by 3 */
	addl	sp@+,d0		/*   check it out! */
	addl	#addr,d0	/* now we have the address of the */
	movl	d0,a0		/*    3byte block address */
	movl	a0@,d0		/* get it.  includes an extra byte */
	lsrl	#8,d0		/*   and we dump the extra */
	beqs	2f
	jsr	rblk
	movl	bno, d0
	addl	#1,bno
	subl	#10,d0
	blts	1f		/* if less than, we are done */
	asll	#2,d0		/* else we have an indirect block */
	addl	#buf,d0
	movl	d0,a0
	movl	a0@,d0		/* get the disc block number */
	bne	rblk		/* go get it if non-zero */
2:
	subl	#2,sp@		/* if we are here, we have an error */
1:
	rts

/*
 * scsisave -- save the scsi values for calls to the boot rom scsi
 * read routines.
 */

scsisave:
	movl	#buf,d5			/* where we want the reads */
	movml	#0x00ff,scsiarea		/* <d0-d7> */
	rts

/*
 * rblk -- scsi read disc block using boot rom.
 */

rblk:
	movl	d0, a0			/* save a copy of the address */
	movml	#0xff00,sp@-		/* save all the d regs */
	movml	scsiarea,#0x00ff
	movl	a0,d0			/* first word of cdb */
	orl	#0x08000000,d0		/* put the read byte back */
	jsr	SCSIIO			/* call rom */
	movml	sp@+,#0x00ff		/* restore the d registers */
	rts

end:
	.set	BSIZE,512			/* size of blocks */
	.set	ENTRY, 0x00100000		/* 1 meg */
	.set	MAXSIZE, 138*BSIZE
	.set	SCSIIO,0xfffe0010
	.set	inod,start+1024
	.set	addr, inod+12
	.set	buf, inod+64
	.set	bno, buf+512
	.set	dno,bno+4
	.set	scsiarea, dno+4
