/* main.c */
#include <sys/types.h>
#include <time.h>
#include <sys/fcntl.h>
#include <string.h>
#include <signal.h>
#include <sys/ipm.h>
#include <stdio.h>

#define MAX_MSG   2048
#define PEP_SID 9999
int enfd;
int dbg;
int clean(), debon(), deboff(), ahand();

main(argc, argv)
int argc;
char *argv[];
{
	static char buf[MAX_MSG];
	register char *dp;
	struct nit_bufhdr *hdrp;
	int msgrecfd, cc, to;
	struct mesghdr msg;
	time_t next_time;
	fd_set rv;

	signal(SIGSEGV, clean);
	signal(SIGINT, SIG_IGN);
	signal(SIGIOT, debon);
	signal(SIGEMT, deboff);
	signal(SIGALRM, ahand);
	setpgrp(getpid(), getpid());
	msgrecfd = msgbind(PEP_SID);
        scopesid(PEP_SID);
	next_time = time((time_t *)0) + 1;

	dbg = 0;
	if (argc == 2) 
		if (strncmp(argv[1], "-d", 2) == 0)
			dbg = 1;

	enfd = getenfd();
	send_conn();
	to = 1000;
	while(1) {
		FD_ZERO(rv);
		FD_SET(enfd, rv);
		FD_SET(msgrecfd,rv);
		if (select(enfd +1,&rv,(fd_set *)0, to) > 0) {
			if (FD_ISSET(enfd,rv)) {
				cc = read(enfd, buf, MAX_MSG);
				if (cc) {
					if (dbg) {
						fprintf(stderr,
						"pep:fm enet:\n");
						hexdump(buf, cc);
						fflush(stderr);
					}
					fwdmsgs(buf, cc);
				}
			}
			if (FD_ISSET(msgrecfd,rv)) {
				dp = msgrecv(msgrecfd, &msg);
				if (dbg) {
					fprintf(stderr, "pep:msgrcv:\n");
					hexdump(&msg, sizeof msg);
					hexdump(dp, msg.length);
					fflush(stderr);
				}
				pepsend(&msg, dp);
				msgfree(dp);
			}

		}
		if (next_time <= time((time_t *)0))  {
			next_time = time((time_t *)0) + 1;
			resend();
		}
	}
}
debon()
{
	signal(SIGIOT, debon);
	fprintf(stderr, "pep:debugging turned on\n");
	fflush(1);
	dbg = 1;
}

deboff()
{
	fprintf(stderr, "pep:debugging turned off\n");
	signal(SIGEMT, deboff);
	dbg = 0;
}

clean()
{
	err("pep:got a sig_segv\n");
	exit(0);
}

err(str)
char *str;
{

	if (dbg) {
		fprintf(stderr, "pep:");
		fprintf(stderr, str);
		fflush(stderr);
	}
}
ahand()
{
	signal(SIGALRM, ahand);
}
