#include <sys/param.h>
#include <sys/ino.h>
#include <sys/inode.h>
#include <sys/filsys.h>
#include <sys/dir.h>
#include <saio.h>

#define	BASE	(16 * 1024)
#define	BUFSIZ	(16 * 1024)
#define	TAPEUNIT	5
#define	MSR	((short *)0xfff80000)

char	linebuf[100];
char	*line = linebuf;
char	*dflt = "s(0,0)unix";

main()
{
	register int i;
	int j;

	setup();
	if (*MSR >> 8 & 01) {
		printf("b)oot or d)ump: ");
		gets(linebuf);
		if (linebuf[0] == 'd')
			dump();
		boot();
	} else {
		for (j = 0; j < (2 * 1024 * 1024); j++)
			/* wait for introl !!!! KLUDGE */;
		printf ("booting from %s\n", dflt);
		do {
			i = open(dflt, 0);
			printf ("open returned 0x%x\n", i);
		} while (i < 0);
		printf ("copyunix(0x%x)\n", i);
		copyunix(i);
		printf ("loaded\n");
	}
}

boot()
{
	int i;

	printf("Boot\n");
	do {
		printf(": ");
		gets(line = linebuf);
		if (line[0] == '\0') {
			line = dflt;
			printf("%s\n", line);
		}
		i = open(line,0);
	} while (i < 0);
	copyunix(i);
}


dump()
{
	int i;
	char line[100];
	int addr;
	static char tapeout[] = { 0xa, 1, 0, 0, 32, 0 };
	static char eof[] = { 0x10, 0, 0, 0, 2, 0 };
	static char rewind[] = { 1, 0, 0, 0, 0, 0 };
	static char request[] = { 3, 0, 0, 0, 14, 0 };
	char data[14];

	printf("Dump\n");
	printf("Make streamer ready and hit return ");
	getchar();
	scsi(TAPEUNIT, request, data, sizeof data, 0);
	printf ("requested sense status\n");
	for (addr = BASE; addr < 4 * 1024 * 1024; addr += BUFSIZ) {
		printf ("-");
		scsi(TAPEUNIT, tapeout, addr, BUFSIZ, 0);
		printf(".");
	}
	scsi(TAPEUNIT, eof, 0, 0, 0);
	scsi(TAPEUNIT, rewind, 0, 0, 0);
	printf("fini...");
	for (;;);
}

copyunix(io)
register io;
{
	register addr,s;
	long phys;
	unsigned txtsiz,datsiz,bsssiz;
	int magic;


	lseek(io, (off_t)0, 0);
	magic = getw(io);
	txtsiz = getw(io);
	datsiz = getw(io);
	bsssiz = getw(io);
	switch (magic) {
	case 0407:
		/*
		 * space over the header. We do this instead of seeking
		 * because the input might be a tape which doesn't know 
		 * how to seek.
		 */
		getw(io); getw(io); getw(io); getw(io);
		phys = txtsiz;
		phys += BASE;
		printf ("%d + ", txtsiz);
		for (addr = BASE; addr < phys; addr += 4)
			*(long *)addr = getw(io);
		phys += datsiz;
		printf ("%d + ", datsiz);
		for (; addr < phys; addr += 4)
			*(long *)addr = getw(io);
		phys  += bsssiz;
		printf("%d ", bsssiz);
		for ( ; addr < phys; addr += 4)
			*(long *) addr = 0;
		printf("= %d\n", txtsiz+datsiz+bsssiz);
		return;
	dflt:
		printf("Can't load %o files\n", magic);
		exit(1);
	}
}

struct	mfp	{
	ushort	gpip;		/* general purpose io */
	ushort	aer;		/* active edge  */
	ushort	ddr;		/* data direction */
	ushort	iera;		/* interrupt enable */
	ushort	ierb;		/* interrupt enable b */
	ushort	ipra;		/* interrupt pending a */
	ushort	iprb;		/* interrupt pending b */
	ushort	isra;		/* interrupt in-service a */
	ushort	isrb;		/* interrupt in-service b */
	ushort	imra;		/* interrupt mask a */
	ushort	imrb;		/* interrupt mask b */
	ushort	vr;		/* vector */
	ushort	tacr;		/* timer A control */
	ushort	tbcr;		/* timer B control */
	ushort	tcdcr;		/* timers C and D control */
	ushort	tadr;		/* timer A data */
	ushort	tbdr;		/* timer B data */
	ushort	tcdr;		/* timer C data */
	ushort	tddr;		/* timer D control */
	ushort	scr;		/* synchronous character */
	ushort	ucr;		/* USART control */
	ushort	rsr;		/* receive status */
	ushort	tsr;		/* transmitter status */
	ushort	udr;		/* USART data */
};

#define	MFP	((struct mfp *) 0xfff80000)
#define	UCR_CLK		0200
#define	UCR_8BITS	0000
#define	UCR_1STOP	0010
#define	TSR_TE		0001
#define	RSR_RE		0001

setup()		/* do 134 kinds of things */
{
	MFP->gpip = 0;
	MFP->iera = 0;
	MFP->ierb = 0;
	MFP->isra = 0;
	MFP->isrb = 0;
	MFP->ddr = 0x38;
	MFP->aer = 0xf5;
	MFP->iera = 0x0;
	MFP->ierb = 0x00;
	MFP->ipra = 0;
	MFP->iprb = 0;
	/* set up the serial part */
	MFP->tcdcr |= 1 << 4;
	MFP->tcdr = 1;
	MFP->ucr = UCR_CLK | UCR_8BITS | UCR_1STOP;
	MFP->tsr = 04 | TSR_TE;
	MFP->rsr = RSR_RE;
}
