/*
 * setflop
 ****************************************************************
 *								*
 *	All rights reserved:	VENTURCOM INC.	1984		*
 *								*
 *	This source listing is supplied in accordance with	*
 *	the Software Agreement you have with VenturCom.		*
 *								*
 ****************************************************************
 * program to intialize VENIX/PRO boot diskette with #user and serial #
 *
 * CONFIDENTIAL: PROPRIETARY TO VENTURCOM, INC.
 */

char string[100];
char buf[512];

#define FLOP "/dev/f0"
#define BMAGIC0 0240
#define BMAGIC1 0405
#define NULOC 508L
#define SNLOC 510L

main(){
	int n, fd, x0, x1;
	unsigned int s;

	printf("VENIX/PRO 2.0 Distribution Initialization program\n\n");
	printf("Place VENIX/PRO Installation Boot Diskette in drive 0\n");
	printf("Type return when ready ...");
	while (getchar() != '\n');

	if ((fd = open(FLOP,2)) < 0){
		printf("Can't open %s\n",FLOP);
		exit(1);
	}
	
sn:	printf("\nSerial number? ");
	gets(string);
	s = atoi(string);

	if (s == 0){
		printf("Invalid\n");
		goto sn;
	}

	printf("\nNumber of users? ");
	gets(string);
	n = atoi(string);

	printf("\nSetting serial number %d for %d users.\n",s,n);

	read(fd,&x0,sizeof(x0));
	read(fd,&x1,sizeof(x1));
	if (x0 != BMAGIC0 || x1 != BMAGIC1){
		printf("Wrong floppy diskette: choices not set\n");
		exit(1);
	}
	lseek(fd,NULOC,0);
	if (write(fd,&n,sizeof(n)) < 0){
		printf("Write error: choices not set\n");
		exit(1);
	}
	lseek(fd,SNLOC,0);
	if (write(fd,&s,sizeof(s)) < 0){
		printf("Write error: choices  not set\n");
		exit(1);
	}
	printf("\nDone\n");
}
