/* 
   isDcc
   (c) 1998 Andrew de Quincey
   adq@tardis.ed.ac.uk
   See README.TXT for copying/distribution/modification details.
*/

#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <io.h>
#include <string.h>

#include "common.h"
#include "util.h"
#include "ishield.h"
#include "header.h"
#include "decode.h"
#include "output.h"
#include "optimise.h"


char version[] = "1.22";


int main(int argc, char* argv[])
{
  int fd;
  ISData isData;
 

  fprintf(stderr, "isDcc v%s, (c) 1998 Andrew de Quincey\n", version);
  fprintf(stderr, "isDcc v2.00, (c) 2000 Mr. Smith\n"); //version2
  fprintf(stderr, "isDcc v2.10, (c) 2001 Mr. Smith\n"); //version2.1

  // --------------------------------------------------------------------------
  // check params
  // modified for version2
  if (!(argc == 2 || (argc==3 && strcmp("-classic",argv[1])==0)))
    error("Syntax: isDcc [-classic] <scriptfile>\n"); 
  argnum = argc;


  // --------------------------------------------------------------------------
  // open file
  if ((fd = open(argv[argc-1], O_RDONLY | O_BINARY)) == -1)
    error("Cannot open file %s for reading\n", argv[argc-1]); //version2


  // --------------------------------------------------------------------------
  // initialise the opTable stuff
  initDecode();


  // --------------------------------------------------------------------------
  // parse the header
  parseHeader(fd, &isData);

  // decode the code
  decode(fd, &isData);

  // do any extra conversion on the code
  optimise(&isData);

  // output it
  output(fd, &isData, 1);

  close(fd);
}

