/* Dieses Programm SYSSTART tauscht Dateien zwischen zwei Mozilla-Profilen aus.  */
/* Von Windows nach OS/2!                                                  	   */
/*   							                                                      	*/
/* - Die Dateien werden flexible in einer Dateiliste gefhrt, die als erster  	*/
/*   Parameter anzugeben ist.    				                              		*/                
/* - Folgende Angaben enthlt diese Dateiliste:   	                       			*/
/*   1. vollen Profilpfad des Windows-Mozilla   		                      		*/
/*   2. vollen Profilpfad des OS/2-Mozilla 	  			                        	*/
/*   3. alle zu kopierenden Dateien	  				                              	*/
/*                                                                        			*/                                           
/* Autor: K.Steinsky  Version: 0.1 Letzte Aktualisierung: 02.04.2003            	*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* ---------- Definitionen ----------------------------- */

Log_schreiben = 0                         /* Logschreiben setzen */
LOG = "SysStart.Log"

datum = substr(date(S),7,2)||'.'||substr(date(S),5,2)||'.'||substr(date(S),1,4)
parse value time() with std ':' min ':' sek . 
uhr = std||'.'||min||'.'sek'h'

/* ---------- Initialisierung -------------------------- */ 

 parse arg dnl                         	/* Dateinamensliste aufnehmen */
 ordner=directory()	                     /* Verzeichnis feststellen */
 dnliste=strip(dnl)                      	/* mgliche Leerstellen entfernen */

If Log_schreiben then do
   Call STREAM LOG,'C','open write'    /* Logdatei ffnen */ 
   If dnliste="" then do
      Logtext=datum", "||uhr||", Kein Name fr die Dateiliste als Parameter angegeben" 
      call LINEOUT LOG , Logtext
      signal KEIN_PARM
   End /*If do*/
   else do
      Logtext=datum", "||uhr||", Log erffnet, Benutzte Dateinamensliste ist '"||dnliste||"'." 
      call LINEOUT LOG , Logtext
   End /*else do*/                                                          
End /*If do*/                                                          
 
/* **** Alle gestarteten Mozilla-Fenster werden gelscht **** */
/*"killit2.exe  Name=Mozilla UNIQUE "*/       /* alle Mozilla-Fenster lschen */

/* ---------- Dateiliste ffnen ------------------------ */ 

rc = STREAM(dnliste ,'C','open read')     /* Dateiliste ffnen */ 
IF rc <> 'READY:' THEN do
   Logtext=datum", "||uhr||", Dateiliste '"||dnliste||"' nicht gefunden." 
   If Log_schreiben then call LINEOUT LOG , Logtext 
   signal KEIN_PARM
End /*If do*/
else do
   Logtext=datum", "||uhr||", Dateinamensliste '"||dnliste||"' geffnet." 
   If Log_schreiben then call LINEOUT LOG , Logtext 
End /*else do*/                                                          

Znr=0

/* ---------- Pfad-Variable setzen --------------------- */ 

/*trace ?i */
Do UNTIL LINES(dnliste) = 0           /* Schleife bis Datei-Ende */
   Znr=Znr+1
   If Znr < 3 then do
     parse UPPER value  STRIP(LINEIN(dnliste),B) with ID '=' pfad  
     If strip(ID) = "MOZ_WIN_PFAD" then WPfad = strip(pfad)
     If strip(ID) = "MOZ_OS2_PFAD" then OPfad = strip(pfad)
     If Log_schreiben & Znr=2 then call LINEOUT LOG , "Von WIN_Pfad=<"||WPfad||"> nach OS2_Pfad=<"||OPfad||"> wird kopiert."

   End /*If do*/

/* ---------- Existenz der Datei(n) prfen ------------- */ 
/* ---------- und wenn beide vorhanden kopieren -------- */ 

   else do
     existiert2 = 0
     zeile =  STRIP(LINEIN(dnliste),B)   /* Leerstellen hinten abschneiden */    
     win_datei = stream(WPfad||"\"||zeile, "C" , "QUERY EXISTS")   /* existiert die Datei? */
     if win_datei = '' then do
        If Log_schreiben then call LINEOUT LOG , "Datei <"||WPfad||"\"||zeile||"> existiert nicht."
     End /*If do*/
     else do
        If Log_schreiben then call LINEOUT LOG , "Datei <"||win_datei"> existiert."
        existiert2 = existiert2+1
     End /* else do */

     os2_datei = stream(OPfad||"\"||zeile, "C" , "QUERY EXISTS")   /* existiert die Datei? */ 
     if os2_datei = '' then do
        If Log_schreiben then call LINEOUT LOG , "Datei <"||OPfad||"\"||zeile||"> existiert nicht."
     End /*If do*/
     else do
        If Log_schreiben then call LINEOUT LOG , "Datei <"||os2_datei"> existiert."
        existiert2 = existiert2+1
     End /* else do */

     If existiert2 = 2 then do           /* Beide Dateien existieren? */
        'COPY "'||win_datei||'"   "'||OPfad||'"'
        If RC > 0 then do
          If Log_schreiben then call LINEOUT LOG , "----> Datei <"||zeile||"> erzeugt Kopierfehler."
        End /* If do */
        else do
        If Log_schreiben then call LINEOUT LOG , "----> Datei <"||zeile||"> von <"||WPfad||"> nach <"||OPfad||"> kopiert."
        End /* else do */
     End /*If do*/
     else do
        If Log_schreiben then call LINEOUT LOG , "----> Datei <"||WPfad||"\"||zeile||"> nicht kopiert."
     End /* else do */
   End /*else do*/                                                          
end /* Do UNTIL */ 

/* ------------------------ Mozilla mit Turbo aufrufen ------------------------ */

"Start G:\mozilla15a\mozilla.exe -turbo"   /* mozilla starten */
If Log_schreiben then call LINEOUT LOG , "----> Mozilla mit Turbo gestartet." 


/* ---------- Programm abschliessen -------------------- */ 

Call STREAM dnliste,'C','close'        /* Dateinamensliste schlieen */ 
KEIN_PARM:
Call STREAM LOG,'C','close'            /* Logdatei schlieen */ 
If Log_schreiben then call LINEOUT LOG , datum", "||uhr||", Log geschlossen." 

EXIT

