/* rexx versions of edm/2 Rexx Inside & Out date routines */

basedate = date("B")
Say basedate
parse value date("U") with mm "/" dd "/" yy

Say EDMBaseDateG(yy,mm,dd)
Say EDMBaseDateJ(yy, date("D"))

Say juliFromBase( basedate )
Say gregFromBase( basedate )
Say EDMDate("D", basedate)
Say EDMDate("E", basedate)
Say EDMDate("M", basedate)
Say EDMDate("N", basedate)
Say EDMDate("O", basedate)
Say EDMDate("S", basedate)
Say EDMDate("U", basedate)
Say EDMDate("W", basedate)

exit

EDMBaseDateG: procedure

/* convert gregorian date to rexx's "base date"                    */
/* joe r wyatt 9/24/92                                             */

parse arg yyyy, mm, dd

If (length(yyyy) = 2) Then
   yyyy = substr(date("S"), 1, 2) || yyyy

 c = (365 * yyyy) + dd + (31 * (mm - 1)) - 366
 if mm < 3 then
   return c + (yyyy-1)%4 - (.75*(((yyyy-1)/100+1)%1)) % 1
 else
   return (c-(0.4*mm+2.3)%1+(yyyy%4)-(.75*((yyyy%100)+1))%1)

/*----------------------------------------------------------------*/

EDMBaseDateJ: procedure

/* convert Julian dats to rexx's base date                        */
/* joe r wyatt 3/1996                                             */

parse arg yyyy, ddd

if (length(yyyy) = 2) then
    yyyy = substr(date("S"), 1, 2) || yyyy

 c = (365 * yyyy) + ddd - 366
 return c + (yyyy-1)%4 - (.75*(((yyyy-1)/100+1)%1)) % 1

/*----------------------------------------------------------------*/

juliFromBase: procedure
baseDate = arg(1)

    q = baseDate % 146097
    r = baseDate // 146097

    yyyy = q * 400 + (r % 365.25 + 1) % 1
    if (r >= 109938) then
       r = r + 3
    else if (r >= 73414) then
       r = r + 2
    else if (r >= 36890) then
       r = r +1

    ddd   = (r // 365.25) + 1
    if (ddd // 1 > 0) then
       ddd = (ddd + 1) % 1

    return yyyy ddd

gregFromBase: procedure
baseDate = arg(1)

    days = "31 59 90 120 151 181 212 243 273 304 334"
    dayl = "31 60 91 121 152 182 213 244 274 304 335"

    parse value juliFromBase(baseDate) with yyyy ddd

    if (yyyy // 4 == 0) then
        dayArray = dayl
    else
        dayArray = days

    do k=1 to 12 while (word(dayArray, k) < ddd)
    end
    mm = k
    dd = ddd - word(dayArray, k-1)
    return yyyy mm dd

/*-------------------------------------------------------------*/
EDMDate: procedure

parse arg format, basedate

months = "January February March April May June July August",
                      "September October November December"
weekdays = "Tuesday Wednesday Thursday Friday Saturday Sunday Monday"

format = substr(format, 1, 1)
select
  when (format = 'D') then   /* days */
     parse value juliFromBase(basedate) with . retValue

  when (format = 'E') then   /* euorpean */
   do
     parse value gregFromBase(basedate) with yyyy mm dd
     retValue = right(dd, 2, '0')"/"right(mm, 2, '0')"/"substr(yyyy, 3)
   end

  when (format = 'M') then   /* month */
   do
      parse value gregFromBase(basedate) with yyyy mm dd
      retValue = word(months, mm)
   end

  when (format = 'N') then   /* normal */
   do
      parse value gregFromBase(basedate) with yyyy mm dd
      retValue = dd word(months, mm) yyyy
   end

  when (format = 'O') then   /* ordered */
   do
      parse value gregFromBase(basedate) with yyyy mm dd
      retValue = substr(yyyy, 3)"/"right(mm,2,'0')"/"right(dd,2,'0')
   end

  when (format = "S") then  /* sorted */
   do
      parse value gregFromBase(basedate) with yyyy mm dd
      retValue = right(yyyy, 4, '0') || right(mm, 2, '0') || right(dd, 2, '0')
   end

  when (format = 'U') then  /* USA */
   do
      parse value gregFromBase(basedate) with yyyy mm dd
      retValue = right(mm, 2, '0')"/"right(dd, 2, '0')"/"substr(yyyy, 3)
   end

  when (format = 'W') then /* weekday */
      retValue = word(weekdays, basedate // 7)

end

return retValue;
