//-------------------------------------------------------------------
//
// File:        STEP02.C
//
// Description: Example of Using Threads in PM
//
//-------------------------------------------------------------------
//
// Source Code from "Introduction to PM Programming Part II" in the
// Electronic Developer's Monthly Magazine (EDM/2) April 1993 Vol 2
//
// Written by Gavin Baker in March 1993
//
// net:  demogrb@lust.latrobe.edu.au
// cis:  100026,270
// bix:  gbaker
//
// For non-profit use only. Example code only - use at your own risk!
//-------------------------------------------------------------------

// Includes

#define INCL_WIN
#define INCL_GPI
#define INCL_WINDIALOGS

#include <os2.h>
#include <process.h>
#include <string.h>
#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include "step02.h"

// Defines

#define WM_BEGIN_PAINT  WM_USER+1
#define WM_END_PAINT    WM_USER+2
#define WM_ACK          WM_USER+3

// Globals

HWND    hwndMain,
        hwndWorker;

// Prototypes

MRESULT EXPENTRY MainWndProc (HWND, ULONG, MPARAM, MPARAM);
VOID             WorkerThread ();
MRESULT EXPENTRY WorkWndProc (HWND, ULONG, MPARAM, MPARAM);
MRESULT EXPENTRY DlgProc(HWND, ULONG, MPARAM, MPARAM);
VOID             WorkPaint (HWND, HPS);

// Main Program!

int main (void)
{
    HAB     hab;
    HMQ     hmq;
    HWND    hwndFrame;
    QMSG    qmsg;
    ULONG   flFrameFlags =  FCF_TITLEBAR      |     FCF_SYSMENU  |
                            FCF_SIZEBORDER    |     FCF_MINMAX   |
                            FCF_SHELLPOSITION |     FCF_TASKLIST |
                            FCF_MENU          ;

    randomize();

    hab = WinInitialize (0);
    hmq = WinCreateMsgQueue (hab, 0);

    WinRegisterClass (hab, "STEP2", MainWndProc, CS_SIZEREDRAW, 0);

    hwndFrame = WinCreateStdWindow (HWND_DESKTOP, WS_VISIBLE,
                                    &flFrameFlags, "STEP2", NULL,
                                    0, NULLHANDLE, ID_MAIN, &hwndMain);

    while (WinGetMsg (hab, &qmsg, 0, 0, 0))
            WinDispatchMsg (hab, &qmsg);

    WinDestroyWindow (hwndFrame);
    WinDestroyMsgQueue (hmq);
    WinTerminate (hab);
    return 0;
}

MRESULT EXPENTRY MainWndProc (HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    FILEDLG     fild;

    switch (msg)
    {
        case WM_CREATE:
            if (_beginthread (WorkerThread, 8192, NULL) == -1)
            {
                WinMessageBox (HWND_DESKTOP, hwnd,
                    "Creation of second thread failed!", "Step 2",
                    0, MB_OK | MB_CUACRITICAL);
                return 0;
            }

            return 0;

        case WM_ACK:
            WinPostMsg(hwndWorker, WM_BEGIN_PAINT, 0, 0);
            return 0;

        case WM_SIZE:
            WinSendMsg(hwndWorker, WM_END_PAINT, 0, 0);

            WinPostMsg(hwndWorker, WM_BEGIN_PAINT, 0, 0);
            return 0;

        case WM_PRESPARAMCHANGED:
            WinInvalidateRect(hwndMain,NULL,TRUE);
            return 0;

        case WM_PAINT:
            WinSendMsg(hwndWorker, WM_END_PAINT, 0, 0);

            WinPostMsg(hwndWorker, WM_BEGIN_PAINT, 0, 0);
            return 0;

        case WM_ERASEBACKGROUND:
            return (MRESULT) TRUE;

        case WM_COMMAND:
            switch (SHORT1FROMMP(mp1))
            {
                case ID_ABOUT:
                    WinDlgBox(HWND_DESKTOP,hwnd,(PFNWP)DlgProc,NULLHANDLE,
                        DLG_ABOUT,NULL);
                    return 0;

                case ID_FILEOPEN:
                    memset(&fild, 0, sizeof(FILEDLG));
                    fild.cbSize=sizeof(FILEDLG);
                    fild.fl=FDS_OPEN_DIALOG | FDS_CENTER ;
                    fild.pszIDrive="C:";
                    WinFileDlg(HWND_DESKTOP,hwnd,&fild);
                    return 0;

                case ID_FILEEXIT:
                    WinPostMsg(hwnd, WM_CLOSE, 0, 0);
                    return 0;

                default:
                    return WinDefWindowProc(hwnd,msg,mp1,mp2);
            }

        case WM_DESTROY:
            WinSendMsg(hwndWorker, WM_DESTROY, mp1, mp2);
            return 0;
        }
    return WinDefWindowProc (hwnd, msg, mp1, mp2);
}

VOID WorkerThread ()
{
    HAB  hab;
    HMQ  hmq;
    HWND hwndObject,
         hwndParent;
    QMSG qmsg;

    hab = WinInitialize (0);

    hmq = WinCreateMsgQueue(hab, 0);

    WinRegisterClass(hab, "STEP2_B", WorkWndProc, 0, 0);

    hwndWorker = WinCreateWindow( HWND_OBJECT, "STEP2_B", "",
             0, 0, 0, 0, 0, HWND_OBJECT, HWND_BOTTOM, 0, NULL, NULL );

    WinSendMsg( hwndMain, WM_ACK, 0, 0 );

    while( WinGetMsg ( hab, &qmsg, 0, 0, 0 ))
        WinDispatchMsg ( hab, &qmsg );

    WinPostMsg( hwndMain, WM_QUIT, 0, 0 );

    WinDestroyWindow( hwndWorker );
    WinDestroyMsgQueue( hmq );
    WinTerminate (hab);
    _endthread ();
}

MRESULT EXPENTRY DlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    switch (msg)
    {
        case WM_COMMAND:
            WinDismissDlg(hwnd,TRUE);
            return 0;
        default:
            return WinDefDlgProc(hwnd,msg,mp1,mp2);
    }
}

MRESULT EXPENTRY WorkWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    static BOOL Paint=FALSE;
    static HPS  hps;
    SIZEL       sizel;

    switch (msg)
    {
        case WM_CREATE:
            if (!WinStartTimer(WinQueryAnchorBlock(hwnd), hwnd, 1, 1000))
                WinMessageBox(HWND_DESKTOP,hwnd,"Could not start timer!",
                    "Error",0,MB_CUACRITICAL | MB_OK);
            hps = WinGetPS(hwndMain);
            GpiSetBackMix(hps, BM_OVERPAINT);
            return 0;

        case WM_BEGIN_PAINT:
            Paint = TRUE;
            return 0;

        case WM_END_PAINT:
            Paint = FALSE;
            return 0;

        case WM_TIMER:
            if (Paint)
                WorkPaint(hwndMain, hps);
            return 0;

        case WM_DESTROY:
            WinStopTimer(WinQueryAnchorBlock(hwnd), hwnd, 0);
            WinReleasePS(hps);
            return 0;
    }
    return WinDefWindowProc (hwnd, msg, mp1, mp2);
}

VOID WorkPaint (HWND hwnd, HPS hps)
{
    ULONG   x, y, cx, cy;
    RECTL   rect;
    POINTL  ptl;
    char    s[42];
    struct time  t;

    WinQueryWindowRect(hwnd, &rect);

    cx = rect.xRight - rect.xLeft;
    cy = rect.yTop - rect.yBottom;

    gettime(&t);
    sprintf(s,"Current Time: %2.2d:%2.2d:%2.2d",t.ti_hour,t.ti_min,t.ti_sec);

    ptl.x=(cx/3); ptl.y=(cy/2);
    GpiSetColor(hps, rand() % 16);
    GpiCharStringAt(hps, &ptl, strlen(s), s);
}
